/*
 * Decompiled with CFR 0.152.
 */
package com.mooltiverse.oss.nyx.version;

import com.mooltiverse.oss.nyx.version.CoreIdentifiers;
import com.mooltiverse.oss.nyx.version.Identifier;
import com.mooltiverse.oss.nyx.version.Parser;
import com.mooltiverse.oss.nyx.version.Scheme;
import com.mooltiverse.oss.nyx.version.SemanticVersionBuildIdentifier;
import com.mooltiverse.oss.nyx.version.SemanticVersionCoreIdentifier;
import com.mooltiverse.oss.nyx.version.SemanticVersionPreReleaseIdentifier;
import com.mooltiverse.oss.nyx.version.Version;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SemanticVersion
extends Version
implements Comparable<SemanticVersion> {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_BUMP_VALUE = 1;
    public static final String DEFAULT_INITIAL_VERSION = "0.1.0";
    public static final char PRERELEASE_DELIMITER = '-';
    public static final char BUILD_DELIMITER = '+';
    public static final String SEMANTIC_VERSION_PATTERN_RELAXED = "([0-9]\\d*)\\.([0-9]\\d*)\\.([0-9]\\d*)(?:-((?:[0-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:[0-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$";
    public static final String SEMANTIC_VERSION_PATTERN = "^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$";
    private transient String renderedString = null;
    private final SemanticVersionCoreIdentifier coreIdentifier;
    private final SemanticVersionPreReleaseIdentifier prereleaseIdentifier;
    private final SemanticVersionBuildIdentifier buildIdentifier;

    public SemanticVersion(int major, int minor, int patch) {
        this(major, minor, patch, null, null);
    }

    public SemanticVersion(int major, int minor, int patch, Object[] prereleaseIdentifiers, String[] buildIdentifiers) {
        this(SemanticVersionCoreIdentifier.valueOf(major, minor, patch), Parser.hasValues(prereleaseIdentifiers) ? SemanticVersionPreReleaseIdentifier.valueOf(true, prereleaseIdentifiers) : null, Parser.hasValues(buildIdentifiers) ? SemanticVersionBuildIdentifier.valueOf(true, buildIdentifiers) : null);
    }

    private SemanticVersion(SemanticVersionCoreIdentifier coreIdentifier, SemanticVersionPreReleaseIdentifier prereleaseIdentifier, SemanticVersionBuildIdentifier buildIdentifier) {
        Objects.requireNonNull(coreIdentifier, "Can't build a valid semantic version without the core version numbers");
        this.coreIdentifier = coreIdentifier;
        this.prereleaseIdentifier = prereleaseIdentifier;
        this.buildIdentifier = buildIdentifier;
    }

    @Override
    public int hashCode() {
        return 19 * this.coreIdentifier.hashCode() * (this.prereleaseIdentifier == null ? 1 : 23 * this.prereleaseIdentifier.hashCode()) * (this.buildIdentifier == null ? 1 : 29 * this.buildIdentifier.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        SemanticVersion otherVersion = (SemanticVersion)SemanticVersion.class.cast(obj);
        if (!this.coreIdentifier.equals(otherVersion.coreIdentifier)) {
            return false;
        }
        if (this.prereleaseIdentifier == null ? otherVersion.prereleaseIdentifier != null : !this.prereleaseIdentifier.equals(otherVersion.prereleaseIdentifier)) {
            return false;
        }
        return !(this.buildIdentifier == null ? otherVersion.buildIdentifier != null : !this.buildIdentifier.equals(otherVersion.buildIdentifier));
    }

    static Comparator<String> getIdentifierComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String i1, String i2) {
                if (i1.equals(i2)) {
                    return 0;
                }
                if ("major".equals(i1)) {
                    return -1;
                }
                if ("major".equals(i2)) {
                    return 1;
                }
                if ("minor".equals(i1)) {
                    return -1;
                }
                if ("minor".equals(i2)) {
                    return 1;
                }
                if ("patch".equals(i1)) {
                    return -1;
                }
                if ("patch".equals(i2)) {
                    return 1;
                }
                return i1.compareTo(i2);
            }
        };
    }

    @Override
    public int compareTo(SemanticVersion v) {
        if (v == null) {
            return 1;
        }
        if (this.getMajor() != v.getMajor()) {
            return this.getMajor() - v.getMajor();
        }
        if (this.getMinor() != v.getMinor()) {
            return this.getMinor() - v.getMinor();
        }
        if (this.getPatch() != v.getPatch()) {
            return this.getPatch() - v.getPatch();
        }
        if (this.prereleaseIdentifier != null || v.prereleaseIdentifier != null) {
            if (this.prereleaseIdentifier != null && v.prereleaseIdentifier == null) {
                return -1;
            }
            if (this.prereleaseIdentifier == null && v.prereleaseIdentifier != null) {
                return 1;
            }
        }
        if (this.prereleaseIdentifier != null) {
            Iterator thisIterator = this.prereleaseIdentifier.getValue().iterator();
            Iterator otherIterator = v.prereleaseIdentifier.getValue().iterator();
            while (thisIterator.hasNext()) {
                if (otherIterator.hasNext()) {
                    int res;
                    Object thisItem = ((Identifier)thisIterator.next()).getValue();
                    Object otherItem = ((Identifier)otherIterator.next()).getValue();
                    if (Integer.class.isInstance(thisItem)) {
                        if (Integer.class.isInstance(otherItem)) {
                            res = ((Integer)Integer.class.cast(thisItem)).compareTo((Integer)Integer.class.cast(otherItem));
                            if (res == 0) continue;
                            return res;
                        }
                        return -1;
                    }
                    if (Integer.class.isInstance(otherItem)) {
                        return 1;
                    }
                    res = thisItem.toString().compareTo(otherItem.toString());
                    if (res == 0) continue;
                    return res;
                }
                return 1;
            }
            if (otherIterator.hasNext()) {
                return -1;
            }
        }
        if (this.buildIdentifier != null || v.buildIdentifier != null) {
            if (this.buildIdentifier != null && v.buildIdentifier == null) {
                return -1;
            }
            if (this.buildIdentifier == null && v.buildIdentifier != null) {
                return 1;
            }
        }
        if (this.buildIdentifier != null && v.buildIdentifier != null && this.buildIdentifier.children.size() != v.buildIdentifier.children.size()) {
            return v.buildIdentifier.children.size() - this.buildIdentifier.children.size();
        }
        if (this.buildIdentifier != null && this.buildIdentifier.toString().compareTo(v.buildIdentifier.toString()) != 0) {
            return this.buildIdentifier.toString().compareTo(v.buildIdentifier.toString());
        }
        return this.toString().compareTo(v.toString());
    }

    @Override
    public final Scheme getScheme() {
        return Scheme.SEMVER;
    }

    public static boolean isLegal(String s) {
        return SemanticVersion.isLegal(s, false);
    }

    public static boolean isLegal(String s, boolean lenient) {
        Objects.requireNonNull(s, "Can't parse a null string");
        Matcher m = Pattern.compile(lenient ? SEMANTIC_VERSION_PATTERN_RELAXED : SEMANTIC_VERSION_PATTERN).matcher(s);
        return m.find();
    }

    @Override
    public String toString() {
        if (this.renderedString == null) {
            StringBuilder sb = new StringBuilder(this.coreIdentifier.toString());
            if (this.prereleaseIdentifier != null) {
                sb.append('-');
                sb.append(this.prereleaseIdentifier.toString());
            }
            if (this.buildIdentifier != null) {
                sb.append('+');
                sb.append(this.buildIdentifier.toString());
            }
            this.renderedString = sb.toString();
        }
        return this.renderedString;
    }

    public static SemanticVersion valueOf(String s) {
        Objects.requireNonNull(s, "Can't parse a null string");
        if (s.isBlank()) {
            throw new IllegalArgumentException("Can't parse an empty string");
        }
        Matcher m = Pattern.compile(SEMANTIC_VERSION_PATTERN).matcher(s);
        if (m.find()) {
            SemanticVersionCoreIdentifier coreIdentifier = SemanticVersionCoreIdentifier.valueOf(m.group(1), m.group(2), m.group(3));
            SemanticVersionPreReleaseIdentifier preReleaseIdentifier = null;
            if (m.group(4) != null && !m.group(4).isBlank()) {
                preReleaseIdentifier = SemanticVersionPreReleaseIdentifier.valueOf(true, m.group(4));
            }
            SemanticVersionBuildIdentifier buildIdentifier = null;
            if (m.group(5) != null && !m.group(5).isBlank()) {
                buildIdentifier = SemanticVersionBuildIdentifier.valueOf(true, m.group(5));
            }
            return new SemanticVersion(coreIdentifier, preReleaseIdentifier, buildIdentifier);
        }
        throw new IllegalArgumentException(String.format("The string '%s' does not contain a valid semantic number", s));
    }

    public static SemanticVersion valueOf(String s, boolean sanitize) {
        return SemanticVersion.valueOf(sanitize ? SemanticVersion.sanitize(s) : s);
    }

    public static String sanitize(String s) {
        return SemanticVersion.sanitizeNumbers(SemanticVersion.sanitizePrefix(s));
    }

    public static String sanitizeNumbers(String s) {
        Matcher m;
        Objects.requireNonNull(s, "Can't parse a null string");
        if (s.isBlank()) {
            throw new IllegalArgumentException("Can't parse an empty string");
        }
        StringBuilder result = new StringBuilder();
        String prefix = SemanticVersion.getPrefix(s);
        if (prefix != null) {
            result.append(prefix);
        }
        if ((m = Pattern.compile(SEMANTIC_VERSION_PATTERN_RELAXED).matcher(s)).find()) {
            try {
                Integer integer = Integer.valueOf(m.group(1));
                if (integer < 0) {
                    throw new IllegalArgumentException(String.format("Can't sanitize negative number '%d' in '%s'", integer, s));
                }
                result.append(integer.toString());
                result.append('.');
                integer = Integer.valueOf(m.group(2));
                if (integer < 0) {
                    throw new IllegalArgumentException(String.format("Can't sanitize negative number '%d' in '%s'", integer, s));
                }
                result.append(integer.toString());
                result.append('.');
                integer = Integer.valueOf(m.group(3));
                if (integer < 0) {
                    throw new IllegalArgumentException(String.format("Can't sanitize negative number '%d' in '%s'", integer, s));
                }
                result.append(integer.toString());
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException(String.format("Numeric identifiers in string '%s' can't be converted to valid Integers", s), nfe);
            }
            if (m.group(4) != null && !m.group(4).isBlank()) {
                result.append('-');
                List<String> identifiers = Arrays.asList(m.group(4).split("[.]"));
                Iterator<String> idIterator = identifiers.iterator();
                while (idIterator.hasNext()) {
                    String identifier = idIterator.next();
                    try {
                        result.append(Integer.valueOf(identifier).toString());
                    }
                    catch (NumberFormatException nfe) {
                        result.append(identifier);
                    }
                    if (!idIterator.hasNext()) continue;
                    result.append('.');
                }
            }
            if (m.group(5) != null && !m.group(5).isBlank()) {
                result.append('+');
                result.append(m.group(5));
            }
        } else {
            throw new IllegalArgumentException(String.format("The string '%s' does not contain a valid semantic number", s));
        }
        return result.toString();
    }

    public static String sanitizePrefix(String s) {
        Objects.requireNonNull(s, "Can't sanitize a null string");
        if (s.isBlank()) {
            throw new IllegalArgumentException("Can't sanitize an empty string");
        }
        Matcher m = Pattern.compile(SEMANTIC_VERSION_PATTERN_RELAXED).matcher(s);
        if (m.find()) {
            return m.group(0);
        }
        throw new IllegalArgumentException(String.format("The string '%s' does not contain a valid semantic number", s));
    }

    public static String getPrefix(String s) {
        Objects.requireNonNull(s, "Can't parse a null string");
        if (s.isBlank()) {
            return null;
        }
        Matcher m = Pattern.compile(SEMANTIC_VERSION_PATTERN_RELAXED).matcher(s);
        if (m.find()) {
            if (s.equals(m.group(0))) {
                return null;
            }
            return s.substring(0, s.length() - m.group(0).length());
        }
        throw new IllegalArgumentException(String.format("The string '%s' does not contain a valid semantic number", s));
    }

    public int getMajor() {
        return this.coreIdentifier.getMajor();
    }

    public int getMinor() {
        return this.coreIdentifier.getMinor();
    }

    public int getPatch() {
        return this.coreIdentifier.getPatch();
    }

    public String getCore() {
        return this.coreIdentifier.toString();
    }

    public Integer[] getCoreIdentifiers() {
        Integer[] res = new Integer[this.coreIdentifier.children.size()];
        for (int i = 0; i < this.coreIdentifier.children.size(); ++i) {
            res[i] = this.coreIdentifier.get(i);
        }
        return res;
    }

    public String getPrerelease() {
        return this.prereleaseIdentifier == null ? null : this.prereleaseIdentifier.toString();
    }

    public Object[] getPrereleaseIdentifiers() {
        if (this.prereleaseIdentifier == null) {
            return null;
        }
        Object[] res = new Object[this.prereleaseIdentifier.children.size()];
        for (int i = 0; i < this.prereleaseIdentifier.children.size(); ++i) {
            res[i] = ((Identifier)this.prereleaseIdentifier.children.get(i)).getValue();
        }
        return res;
    }

    public String getBuild() {
        return this.buildIdentifier == null ? null : this.buildIdentifier.toString();
    }

    public String[] getBuildIdentifiers() {
        if (this.buildIdentifier == null) {
            return null;
        }
        String[] res = new String[this.buildIdentifier.children.size()];
        for (int i = 0; i < this.buildIdentifier.children.size(); ++i) {
            res[i] = this.buildIdentifier.get(i);
        }
        return res;
    }

    public SemanticVersion setCore(int major, int minor, int patch) {
        return new SemanticVersion(SemanticVersionCoreIdentifier.valueOf(major, minor, patch), this.prereleaseIdentifier, this.buildIdentifier);
    }

    public SemanticVersion setMajor(int major) {
        return new SemanticVersion(SemanticVersionCoreIdentifier.valueOf(major, this.coreIdentifier.getMinor(), this.coreIdentifier.getPatch()), this.prereleaseIdentifier, this.buildIdentifier);
    }

    public SemanticVersion setMinor(int minor) {
        return new SemanticVersion(SemanticVersionCoreIdentifier.valueOf(this.coreIdentifier.getMajor(), minor, this.coreIdentifier.getPatch()), this.prereleaseIdentifier, this.buildIdentifier);
    }

    public SemanticVersion setPatch(int patch) {
        return new SemanticVersion(SemanticVersionCoreIdentifier.valueOf(this.coreIdentifier.getMajor(), this.coreIdentifier.getMinor(), patch), this.prereleaseIdentifier, this.buildIdentifier);
    }

    public SemanticVersion setPrerelease(Object ... identifiers) {
        SemanticVersionPreReleaseIdentifier svpri = null;
        if (Parser.hasValues(identifiers)) {
            svpri = SemanticVersionPreReleaseIdentifier.valueOf(true, identifiers);
        }
        return new SemanticVersion(this.coreIdentifier, svpri, this.buildIdentifier);
    }

    public SemanticVersion setBuild(String ... identifiers) {
        SemanticVersionBuildIdentifier svbi = null;
        if (Parser.hasValues(identifiers)) {
            svbi = SemanticVersionBuildIdentifier.valueOf(true, identifiers);
        }
        return new SemanticVersion(this.coreIdentifier, this.prereleaseIdentifier, svbi);
    }

    public boolean hasPrereleaseAttribute(String name) {
        return this.prereleaseIdentifier == null ? false : this.prereleaseIdentifier.hasAttribute(name);
    }

    public boolean hasBuildAttribute(String name) {
        return this.buildIdentifier == null ? false : this.buildIdentifier.hasAttribute(name);
    }

    public Integer getPrereleaseAttributeValue(String name) {
        return this.prereleaseIdentifier == null ? null : this.prereleaseIdentifier.getAttributeValue(name);
    }

    public String getBuildAttributeValue(String name) {
        return this.buildIdentifier == null ? null : this.buildIdentifier.getAttributeValue(name);
    }

    public SemanticVersion setPrereleaseAttribute(String name, Integer value) {
        Objects.requireNonNull(name, "Can't set a null attribute name");
        if (this.prereleaseIdentifier == null) {
            return new SemanticVersion(this.coreIdentifier, value == null ? SemanticVersionPreReleaseIdentifier.valueOf(false, name) : SemanticVersionPreReleaseIdentifier.valueOf(false, name, value), this.buildIdentifier);
        }
        return new SemanticVersion(this.coreIdentifier, this.prereleaseIdentifier.setAttribute(name, value), this.buildIdentifier);
    }

    public SemanticVersion setPrereleaseAttribute(String name) {
        return this.setPrereleaseAttribute(name, null);
    }

    public SemanticVersion setBuildAttribute(String name, String value) {
        Objects.requireNonNull(name, "Can't set a null attribute name");
        if (this.buildIdentifier == null) {
            return new SemanticVersion(this.coreIdentifier, this.prereleaseIdentifier, value == null ? SemanticVersionBuildIdentifier.valueOf(false, name) : SemanticVersionBuildIdentifier.valueOf(false, name, value));
        }
        return new SemanticVersion(this.coreIdentifier, this.prereleaseIdentifier, this.buildIdentifier.setAttribute(name, value));
    }

    public SemanticVersion setBuildAttribute(String name) {
        return this.setBuildAttribute(name, null);
    }

    public SemanticVersion removePrereleaseAttribute(String name, boolean removeValue) {
        return this.prereleaseIdentifier == null ? this : new SemanticVersion(this.coreIdentifier, this.prereleaseIdentifier.removeAttribute(name, removeValue), this.buildIdentifier);
    }

    public SemanticVersion removeBuildAttribute(String name, boolean removeValue) {
        return this.buildIdentifier == null ? this : new SemanticVersion(this.coreIdentifier, this.prereleaseIdentifier, this.buildIdentifier.removeAttribute(name, removeValue));
    }

    public SemanticVersion bumpMajor() {
        return new SemanticVersion(this.coreIdentifier.bumpMajor(), this.prereleaseIdentifier, this.buildIdentifier);
    }

    public SemanticVersion bumpMinor() {
        return new SemanticVersion(this.coreIdentifier.bumpMinor(), this.prereleaseIdentifier, this.buildIdentifier);
    }

    public SemanticVersion bumpPatch() {
        return new SemanticVersion(this.coreIdentifier.bumpPatch(), this.prereleaseIdentifier, this.buildIdentifier);
    }

    public SemanticVersion bump(CoreIdentifiers id) {
        Objects.requireNonNull(id);
        switch (id) {
            case MAJOR: {
                return this.bumpMajor();
            }
            case MINOR: {
                return this.bumpMinor();
            }
            case PATCH: {
                return this.bumpPatch();
            }
        }
        throw new IllegalArgumentException(id.toString());
    }

    public SemanticVersion bumpPrerelease(String id) {
        Objects.requireNonNull(id, "Can't bump a null identifier");
        if (id.isBlank()) {
            throw new IllegalArgumentException("Can't bump an empty identifier");
        }
        try {
            Integer.valueOf(id);
            throw new IllegalArgumentException(String.format("The value '%s' is numeric ant can't be used as a string identifier in the prerelease", id));
        }
        catch (NumberFormatException numberFormatException) {
            return new SemanticVersion(this.coreIdentifier, this.prereleaseIdentifier == null ? SemanticVersionPreReleaseIdentifier.valueOf(false, id, 1) : this.prereleaseIdentifier.bump(id, 1), this.buildIdentifier);
        }
    }

    @Override
    public SemanticVersion bump(String id) {
        Objects.requireNonNull(id, "Can't bump a null identifier");
        if (id.isBlank()) {
            throw new IllegalArgumentException("Can't bump an empty identifier");
        }
        if (CoreIdentifiers.hasName(id)) {
            return this.bump(CoreIdentifiers.byName(id));
        }
        return this.bumpPrerelease(id);
    }
}

