/*
 * Decompiled with CFR 0.152.
 */
package com.mooltiverse.oss.nyx.version;

import com.mooltiverse.oss.nyx.version.CompositeStringIdentifier;
import com.mooltiverse.oss.nyx.version.Parser;
import com.mooltiverse.oss.nyx.version.StringIdentifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

class SemanticVersionBuildIdentifier
extends CompositeStringIdentifier {
    private static final long serialVersionUID = 1L;

    private SemanticVersionBuildIdentifier(List<StringIdentifier> children) {
        super('.', children);
    }

    static SemanticVersionBuildIdentifier valueOf(boolean multipleIdentifiers, String s) {
        if (multipleIdentifiers) {
            return new SemanticVersionBuildIdentifier(Parser.toStringIdentifiers(s, '.'));
        }
        return new SemanticVersionBuildIdentifier(List.of(StringIdentifier.valueOf(s)));
    }

    static SemanticVersionBuildIdentifier valueOf(boolean multipleIdentifiers, String ... items) {
        Objects.requireNonNull(items, "Can't build the list of identifiers from a null list");
        if (items.length == 0) {
            throw new IllegalArgumentException("Can't build the list of identifiers from an empty list");
        }
        ArrayList<StringIdentifier> allIdentifiers = new ArrayList<StringIdentifier>();
        for (String s : items) {
            if (multipleIdentifiers) {
                allIdentifiers.addAll(Parser.toStringIdentifiers(s, '.'));
                continue;
            }
            allIdentifiers.add(StringIdentifier.valueOf(s));
        }
        return new SemanticVersionBuildIdentifier((List<StringIdentifier>)allIdentifiers);
    }

    boolean hasAttribute(String name) {
        if (name == null || name.isBlank()) {
            return false;
        }
        return this.getValues().contains(name);
    }

    String getAttributeValue(String name) {
        if (name == null || name.isBlank()) {
            return null;
        }
        Iterator<Object> valuesIterator = this.getValues().iterator();
        while (valuesIterator.hasNext()) {
            Object value = valuesIterator.next();
            if (!name.equals(value) || !valuesIterator.hasNext()) continue;
            return valuesIterator.next().toString();
        }
        return null;
    }

    SemanticVersionBuildIdentifier setAttribute(String name, String value) {
        Objects.requireNonNull(name, "Can't set the attribute name to a null identifier");
        if (name.isBlank()) {
            throw new IllegalArgumentException("Can't set the attribute name to an empty identifier");
        }
        ArrayList<String> newValues = new ArrayList<String>();
        boolean found = false;
        Iterator<Object> previousValuesIterator = this.getValues().iterator();
        while (previousValuesIterator.hasNext()) {
            Object previousValue = previousValuesIterator.next();
            newValues.add(previousValue.toString());
            if (!name.equals(previousValue.toString())) continue;
            found = true;
            if (value == null) continue;
            if (previousValuesIterator.hasNext()) {
                previousValuesIterator.next();
            }
            newValues.add(value);
        }
        if (!found) {
            newValues.add(name);
            if (value != null) {
                newValues.add(value);
            }
        }
        return SemanticVersionBuildIdentifier.valueOf(false, newValues.toArray(new String[0]));
    }

    SemanticVersionBuildIdentifier removeAttribute(String name, boolean removeValue) {
        if (!this.hasAttribute(name)) {
            return this;
        }
        ArrayList<String> newValues = new ArrayList<String>();
        Iterator<Object> previousValuesIterator = this.getValues().iterator();
        while (previousValuesIterator.hasNext()) {
            Object previousValue = previousValuesIterator.next();
            if (name.equals(previousValue.toString())) {
                if (!removeValue || !previousValuesIterator.hasNext()) continue;
                previousValuesIterator.next();
                continue;
            }
            newValues.add(previousValue.toString());
        }
        return newValues.isEmpty() ? null : SemanticVersionBuildIdentifier.valueOf(false, newValues.toArray(new String[0]));
    }
}

