/*
 * Decompiled with CFR 0.152.
 */
package com.mooltiverse.oss.nyx.version;

import com.mooltiverse.oss.nyx.version.CompositeObjectIdentifier;
import com.mooltiverse.oss.nyx.version.Parser;
import com.mooltiverse.oss.nyx.version.SimpleIdentifier;
import com.mooltiverse.oss.nyx.version.UseIntegerIdentifiers;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

class SemanticVersionPreReleaseIdentifier
extends CompositeObjectIdentifier {
    private static final long serialVersionUID = 1L;

    private SemanticVersionPreReleaseIdentifier(List<SimpleIdentifier> children) {
        super('.', children);
    }

    static SemanticVersionPreReleaseIdentifier valueOf(boolean multipleIdentifiers, String s) {
        if (multipleIdentifiers) {
            return new SemanticVersionPreReleaseIdentifier(Parser.toIdentifiers(s, '.', UseIntegerIdentifiers.WHEN_POSSIBLE));
        }
        return new SemanticVersionPreReleaseIdentifier(List.of(Parser.toIdentifier(s, UseIntegerIdentifiers.WHEN_POSSIBLE)));
    }

    static SemanticVersionPreReleaseIdentifier valueOf(boolean multipleIdentifiers, Object ... items) {
        Objects.requireNonNull(items, "Can't build the list of identifiers from a null list");
        if (items.length == 0) {
            throw new IllegalArgumentException("Can't build the list of identifiers from an empty list");
        }
        ArrayList<SimpleIdentifier> identifiers = new ArrayList<SimpleIdentifier>();
        for (Object item : items) {
            Objects.requireNonNull(item, "Can't build the list of identifiers from a list with null values");
            if (multipleIdentifiers) {
                identifiers.addAll(Parser.toIdentifiers(item.toString(), '.', UseIntegerIdentifiers.WHEN_POSSIBLE));
                continue;
            }
            identifiers.add(Parser.toIdentifier(item.toString(), UseIntegerIdentifiers.WHEN_POSSIBLE));
        }
        return new SemanticVersionPreReleaseIdentifier((List<SimpleIdentifier>)identifiers);
    }

    SemanticVersionPreReleaseIdentifier bump(String id, int defaultNumber) {
        Objects.requireNonNull(id, "Can't bump a null identifier");
        if (id.isBlank()) {
            throw new IllegalArgumentException("Can't bump an empty identifier");
        }
        if (defaultNumber < 0) {
            throw new IllegalArgumentException(String.format("Can't use a negative number for the default number to bump. '%d' was passed", defaultNumber));
        }
        ArrayList<Object> newValues = new ArrayList<Object>();
        boolean bumped = false;
        Iterator<Object> previousValuesIterator = this.getValues().iterator();
        while (previousValuesIterator.hasNext()) {
            Object value = previousValuesIterator.next();
            newValues.add(value);
            if (!id.equals(value)) continue;
            bumped = true;
            if (previousValuesIterator.hasNext()) {
                value = previousValuesIterator.next();
                if (Integer.class.isInstance(value)) {
                    newValues.add((Integer)Integer.class.cast(value) + 1);
                    continue;
                }
                newValues.add(defaultNumber);
                newValues.add(value);
                continue;
            }
            newValues.add(defaultNumber);
        }
        if (!bumped) {
            newValues.add(id);
            newValues.add(defaultNumber);
        }
        return SemanticVersionPreReleaseIdentifier.valueOf(false, newValues.toArray());
    }

    boolean hasAttribute(String name) {
        if (name == null || name.isBlank()) {
            return false;
        }
        return this.getValues().contains(name);
    }

    Integer getAttributeValue(String name) {
        if (name == null || name.isBlank()) {
            return null;
        }
        Iterator<Object> valuesIterator = this.getValues().iterator();
        while (valuesIterator.hasNext()) {
            Object value = valuesIterator.next();
            if (!name.equals(value) || !valuesIterator.hasNext()) continue;
            Object maybeTheValue = valuesIterator.next();
            return Integer.class.isInstance(maybeTheValue) ? (Integer)Integer.class.cast(maybeTheValue) : null;
        }
        return null;
    }

    SemanticVersionPreReleaseIdentifier setAttribute(String name, Integer value) {
        Objects.requireNonNull(name, "Can't set the attribute name to a null identifier");
        if (name.isBlank()) {
            throw new IllegalArgumentException("Can't set the attribute name to an empty identifier");
        }
        ArrayList<Object> newValues = new ArrayList<Object>();
        boolean found = false;
        Iterator<Object> previousValuesIterator = this.getValues().iterator();
        while (previousValuesIterator.hasNext()) {
            Object maybeTheValueToReplace;
            Object previousValue = previousValuesIterator.next();
            newValues.add(previousValue.toString());
            if (!name.equals(previousValue.toString())) continue;
            found = true;
            if (value == null) continue;
            newValues.add(value);
            if (!previousValuesIterator.hasNext() || Integer.class.isInstance(maybeTheValueToReplace = previousValuesIterator.next())) continue;
            newValues.add(maybeTheValueToReplace);
        }
        if (!found) {
            newValues.add(name);
            if (value != null) {
                newValues.add(value);
            }
        }
        return SemanticVersionPreReleaseIdentifier.valueOf(false, newValues.toArray());
    }

    SemanticVersionPreReleaseIdentifier removeAttribute(String name, boolean removeValue) {
        if (!this.hasAttribute(name)) {
            return this;
        }
        ArrayList<Object> newValues = new ArrayList<Object>();
        Iterator<Object> previousValuesIterator = this.getValues().iterator();
        while (previousValuesIterator.hasNext()) {
            Object previousValue = previousValuesIterator.next();
            if (name.equals(previousValue.toString())) {
                Object maybeTheValueToRemove;
                if (!removeValue || !previousValuesIterator.hasNext() || Integer.class.isInstance(maybeTheValueToRemove = previousValuesIterator.next())) continue;
                newValues.add(maybeTheValueToRemove);
                continue;
            }
            newValues.add(previousValue.toString());
        }
        return newValues.isEmpty() ? null : SemanticVersionPreReleaseIdentifier.valueOf(false, newValues.toArray());
    }
}

