/*
 * Decompiled with CFR 0.152.
 */
package com.mooltiverse.oss.nyx.version;

import com.mooltiverse.oss.nyx.version.Scheme;
import com.mooltiverse.oss.nyx.version.SemanticVersion;
import com.mooltiverse.oss.nyx.version.Version;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;

public class Versions {
    private Versions() {
    }

    public static final Version defaultInitial(Scheme scheme) {
        Objects.requireNonNull(scheme, "Scheme is required");
        switch (scheme) {
            case SEMVER: {
                return SemanticVersion.valueOf("0.1.0");
            }
        }
        throw new IllegalArgumentException(String.format("Illegal or unsupported scheme '%s'", new Object[]{scheme}));
    }

    public static boolean isCore(Scheme scheme, String s) {
        return Versions.isCore(scheme, s, false);
    }

    public static boolean isCore(Scheme scheme, String s, boolean lenient) {
        Objects.requireNonNull(s, "Can't parse a null string");
        switch (scheme) {
            case SEMVER: {
                if (!SemanticVersion.isLegal(s, lenient)) {
                    return false;
                }
                SemanticVersion v = SemanticVersion.valueOf(s, lenient);
                return Objects.isNull(v.getPrerelease()) && Objects.isNull(v.getBuild());
            }
        }
        throw new IllegalArgumentException(String.format("Illegal or unsupported scheme '%s'", new Object[]{scheme}));
    }

    public static boolean isCore(Scheme scheme, String s, String prefix) {
        Objects.requireNonNull(s, "Can't parse a null string");
        if (!Objects.isNull(prefix) && s.startsWith(prefix)) {
            s = s.replaceFirst(prefix, "");
        }
        return Versions.isCore(scheme, s);
    }

    public static boolean isLegal(Scheme scheme, String s) {
        return Versions.isLegal(scheme, s, false);
    }

    public static boolean isLegal(Scheme scheme, String s, boolean lenient) {
        Objects.requireNonNull(s, "Can't parse a null string");
        switch (scheme) {
            case SEMVER: {
                return SemanticVersion.isLegal(s, lenient);
            }
        }
        throw new IllegalArgumentException(String.format("Illegal or unsupported scheme '%s'", new Object[]{scheme}));
    }

    public static boolean isLegal(Scheme scheme, String s, String prefix) {
        Objects.requireNonNull(s, "Can't parse a null string");
        if (!Objects.isNull(prefix) && s.startsWith(prefix)) {
            s = s.replaceFirst(prefix, "");
        }
        return Versions.isLegal(scheme, s);
    }

    public static String mostRelevantIdentifier(Scheme scheme, Collection<String> identifiers) {
        if (identifiers.isEmpty()) {
            return null;
        }
        Comparator<String> comparator = null;
        switch (scheme) {
            case SEMVER: {
                comparator = SemanticVersion.getIdentifierComparator();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Illegal or unsupported scheme '%s'", new Object[]{scheme}));
            }
        }
        Iterator<String> iterator = identifiers.iterator();
        String candidate = iterator.next();
        while (iterator.hasNext()) {
            String next = iterator.next();
            if (comparator.compare(next, candidate) >= 0) continue;
            candidate = next;
        }
        return candidate;
    }

    public static String mostRelevantIdentifier(Scheme scheme, String identifier1, String identifier2) {
        if (Objects.isNull(identifier1)) {
            return identifier2;
        }
        if (Objects.isNull(identifier2)) {
            return identifier1;
        }
        Comparator<String> comparator = null;
        switch (scheme) {
            case SEMVER: {
                comparator = SemanticVersion.getIdentifierComparator();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Illegal or unsupported scheme '%s'", new Object[]{scheme}));
            }
        }
        return comparator.compare(identifier1, identifier2) < 0 ? identifier1 : identifier2;
    }

    public static final Version valueOf(Scheme scheme, String s) {
        return Versions.valueOf(scheme, s, false);
    }

    public static final Version valueOf(Scheme scheme, String s, boolean sanitize) {
        Objects.requireNonNull(scheme, "Scheme is required");
        Objects.requireNonNull(s, "Can't parse a null string");
        switch (scheme) {
            case SEMVER: {
                return SemanticVersion.valueOf(s, sanitize);
            }
        }
        throw new IllegalArgumentException(String.format("Illegal or unsupported scheme '%s'", new Object[]{scheme}));
    }

    public static final Version valueOf(Scheme scheme, String s, String prefix) {
        Objects.requireNonNull(s, "Can't parse a null string");
        if (!Objects.isNull(prefix) && s.startsWith(prefix)) {
            s = s.replaceFirst(prefix, "");
        }
        return Versions.valueOf(scheme, s);
    }

    public static int compare(Scheme scheme, String v1, String v2) {
        return Versions.compare(scheme, v1, v2, false);
    }

    public static int compare(Scheme scheme, String v1, String v2, String prefix) {
        String v1b;
        if (Objects.isNull(v1) && Objects.isNull(v2)) {
            return 0;
        }
        String string = Objects.isNull(v1) || Objects.isNull(prefix) ? v1 : (v1b = v1.startsWith(prefix) ? v1.replaceFirst(prefix, "") : v1);
        String v2b = Objects.isNull(v2) || Objects.isNull(prefix) ? v2 : (v2.startsWith(prefix) ? v2.replaceFirst(prefix, "") : v2);
        return Versions.compare(scheme, v1b, v2b, false);
    }

    public static int compare(Scheme scheme, String v1, String v2, boolean sanitize) {
        switch (scheme) {
            case SEMVER: {
                SemanticVersion sv2;
                SemanticVersion sv1 = Objects.isNull(v1) ? null : SemanticVersion.valueOf(v1, sanitize);
                SemanticVersion semanticVersion = sv2 = Objects.isNull(v2) ? null : SemanticVersion.valueOf(v2, sanitize);
                if (Objects.isNull(sv1) && Objects.isNull(sv2)) {
                    return 0;
                }
                if (Objects.isNull(sv1)) {
                    return -1;
                }
                if (Objects.isNull(sv2)) {
                    return 1;
                }
                return sv1.compareTo(sv2);
            }
        }
        throw new IllegalArgumentException(String.format("Illegal or unsupported scheme '%s'", new Object[]{scheme}));
    }
}

