/*
 * Decompiled with CFR 0.152.
 */
package com.github.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

@Configuration
public class RestTemplateConfig {
    @Bean
    public ClientHttpRequestFactory clientHttpRequestFactory() {
        SimpleClientHttpRequestFactory clientHttpRequestFactory = new SimpleClientHttpRequestFactory(){

            protected void prepareConnection(HttpURLConnection connection, String httpMethod) throws IOException {
                if (connection instanceof HttpsURLConnection) {
                    HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
                    TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

                        @Override
                        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        }

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return null;
                        }
                    }};
                    try {
                        SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
                        sslContext.init(null, trustManagers, new SecureRandom());
                        httpsConnection.setSSLSocketFactory(sslContext.getSocketFactory());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    super.prepareConnection(connection, httpMethod);
                }
            }
        };
        ((SimpleClientHttpRequestFactory)clientHttpRequestFactory).setConnectTimeout(6000);
        ((SimpleClientHttpRequestFactory)clientHttpRequestFactory).setReadTimeout(60000);
        return clientHttpRequestFactory;
    }

    @Bean
    public RestTemplate restTemplate(RestTemplateBuilder builder, StringHttpMessageConverter stringHttpMessageConverter) {
        RestTemplate restTemplate = builder.requestFactory(this.clientHttpRequestFactory()).build();
        restTemplate.getMessageConverters().set(1, stringHttpMessageConverter);
        return restTemplate;
    }
}

