/*
 * Decompiled with CFR 0.152.
 */
package com.mopano.hibernate.org.json;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class JsonSqlPGObjectHandler
implements SqlTypeDescriptor {
    public static final JsonSqlPGObjectHandler INSTANCE = new JsonSqlPGObjectHandler();
    private static final long serialVersionUID = -7366336604892811986L;

    public int getSqlType() {
        return 1111;
    }

    public boolean canBeRemapped() {
        return false;
    }

    public <X> ValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                String printed = (String)javaTypeDescriptor.unwrap(value, String.class, options);
                st.setObject(index, (Object)printed, 1111);
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                String printed = (String)javaTypeDescriptor.unwrap(value, String.class, options);
                st.setObject(name, (Object)printed, 1111);
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            protected X doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)JsonSqlPGObjectHandler.this.extractFromObject(rs.getObject(name)), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)JsonSqlPGObjectHandler.this.extractFromObject(statement.getObject(index)), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)JsonSqlPGObjectHandler.this.extractFromObject(statement.getObject(name)), options);
            }
        };
    }

    private String extractFromObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        Class<?> c = o.getClass();
        try {
            if (!"org.postgresql.util.PGobject".equals(c.getName())) {
                throw new RuntimeException("Don't know how to convert result from database. Incoming type: " + c.getName());
            }
            Method m = c.getMethod("getValue", new Class[0]);
            return (String)m.invoke(o, new Object[0]);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

