/*
 * Decompiled with CFR 0.152.
 */
package com.mopano.hibernate.org.json;

import com.mopano.hibernate.org.json.Handling;
import com.mopano.hibernate.org.json.JsonArrayJavaTypeDescriptor;
import com.mopano.hibernate.org.json.JsonArrayType;
import com.mopano.hibernate.org.json.JsonObjectJavaTypeDescriptor;
import com.mopano.hibernate.org.json.JsonObjectType;
import com.mopano.hibernate.org.json.spi.JsonSettings;
import java.util.Collection;
import java.util.TreeSet;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptorRegistry;
import org.jboss.logging.Logger;

public class JsonTypeContributor
implements TypeContributor {
    private static final Logger LOGGER = Logger.getLogger(BasicType.class);

    public void contribute(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        ClassLoaderService cls = (ClassLoaderService)serviceRegistry.getService(ClassLoaderService.class);
        ConfigurationService config = (ConfigurationService)serviceRegistry.getService(ConfigurationService.class);
        Dialect dialect = ((JdbcServices)serviceRegistry.getService(JdbcServices.class)).getDialect();
        String dialectStr = dialect.toString().toLowerCase();
        boolean useMysql = dialectStr.contains("mysql") || dialectStr.contains("mariadb");
        try {
            Collection settingsList = cls.loadJavaServices(JsonSettings.class);
            if (settingsList.isEmpty()) {
                if (useMysql) {
                    AbstractTypeDescriptor jdesc = JsonArrayJavaTypeDescriptor.INSTANCE;
                    AbstractSingleColumnStandardBasicType jtype = new JsonArrayType(Handling.STRING, null, null);
                    JavaTypeDescriptorRegistry.INSTANCE.addDescriptor((JavaTypeDescriptor)jdesc);
                    typeContributions.contributeType((BasicType)jtype, jtype.getRegistrationKeys());
                    jdesc = JsonObjectJavaTypeDescriptor.INSTANCE;
                    jtype = new JsonObjectType(Handling.STRING, null, null);
                    JavaTypeDescriptorRegistry.INSTANCE.addDescriptor((JavaTypeDescriptor)jdesc);
                    typeContributions.contributeType((BasicType)jtype, jtype.getRegistrationKeys());
                } else {
                    AbstractSingleColumnStandardBasicType jtype = JsonArrayType.INSTANCE;
                    AbstractTypeDescriptor jdesc = JsonArrayJavaTypeDescriptor.INSTANCE;
                    JavaTypeDescriptorRegistry.INSTANCE.addDescriptor((JavaTypeDescriptor)jdesc);
                    typeContributions.contributeType((BasicType)jtype, jtype.getRegistrationKeys());
                    jtype = JsonObjectType.INSTANCE;
                    jdesc = JsonObjectJavaTypeDescriptor.INSTANCE;
                    JavaTypeDescriptorRegistry.INSTANCE.addDescriptor((JavaTypeDescriptor)jdesc);
                    typeContributions.contributeType((BasicType)jtype, jtype.getRegistrationKeys());
                }
            } else {
                TreeSet<String> regKeys = new TreeSet<String>();
                String lastTypeName = null;
                Handling handler = Handling.PGOBJECT;
                for (JsonSettings jset : settingsList) {
                    String[] rk = jset.getRegistrationKeys();
                    lastTypeName = jset.getTypeName();
                    handler = jset.getSqlHandlerType();
                    if (rk == null || rk.length <= 0) continue;
                    for (String key : rk) {
                        regKeys.add(key);
                    }
                }
                if (handler == null) {
                    throw new NullPointerException("Why did you override the getSqlHandlerType to return null?");
                }
                AbstractTypeDescriptor jdesc = JsonArrayJavaTypeDescriptor.INSTANCE;
                AbstractSingleColumnStandardBasicType jtype = new JsonArrayType(handler, regKeys.toArray(new String[0]), lastTypeName);
                JavaTypeDescriptorRegistry.INSTANCE.addDescriptor((JavaTypeDescriptor)jdesc);
                typeContributions.contributeType((BasicType)jtype, jtype.getRegistrationKeys());
                jdesc = JsonObjectJavaTypeDescriptor.INSTANCE;
                jtype = new JsonObjectType(handler, regKeys.toArray(new String[0]), lastTypeName);
                JavaTypeDescriptorRegistry.INSTANCE.addDescriptor((JavaTypeDescriptor)jdesc);
                typeContributions.contributeType((BasicType)jtype, jtype.getRegistrationKeys());
            }
        }
        catch (Throwable t) {
            LOGGER.error((Object)"JSON type contribution failed!", t);
        }
    }
}

