/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.content.Context;
import android.graphics.Point;
import android.location.Location;
import android.text.TextUtils;
import android.view.WindowInsets;
import androidx.annotation.Nullable;
import com.mopub.common.BaseUrlGenerator;
import com.mopub.common.ClientMetadata;
import com.mopub.common.LocationService;
import com.mopub.common.MoPub;
import com.mopub.common.Preconditions;
import com.mopub.common.ViewabilityManager;
import com.mopub.common.privacy.ConsentData;
import com.mopub.common.privacy.PersonalInfoManager;
import com.mopub.common.util.DateAndTime;
import com.mopub.network.RequestRateTracker;

public abstract class AdUrlGenerator
extends BaseUrlGenerator {
    private static final String KEYWORDS_KEY = "q";
    private static final String USER_DATA_KEYWORDS_KEY = "user_data_q";
    private static final String LAT_LONG_KEY = "ll";
    private static final String LAT_LONG_ACCURACY_KEY = "lla";
    private static final String LAT_LONG_FRESHNESS_KEY = "llf";
    private static final String LAT_LONG_FROM_SDK_KEY = "llsdk";
    private static final String TIMEZONE_OFFSET_KEY = "z";
    private static final String ORIENTATION_KEY = "o";
    private static final String SCREEN_SCALE_KEY = "sc";
    private static final String IS_MRAID_KEY = "mr";
    private static final String MOBILE_COUNTRY_CODE_KEY = "mcc";
    private static final String MOBILE_NETWORK_CODE_KEY = "mnc";
    private static final String COUNTRY_CODE_KEY = "iso";
    private static final String CARRIER_NAME_KEY = "cn";
    private static final String CARRIER_TYPE_KEY = "ct";
    private static final String VIEWABILITY_KEY = "vv";
    private static final String OMSDK_VERSION_KEY = "vver";
    private static final String ADVANCED_BIDDING_TOKENS_KEY = "abt";
    private static final String BACKOFF_TIME_MS_KEY = "backoff_ms";
    private static final String BACKOFF_REASON_KEY = "backoff_reason";
    protected Context mContext;
    protected String mAdUnitId;
    protected String mKeywords;
    protected String mUserDataKeywords;
    protected Point mRequestedAdSize;
    protected WindowInsets mWindowInsets;
    @Nullable
    private final PersonalInfoManager mPersonalInfoManager;
    @Nullable
    private final ConsentData mConsentData;

    public AdUrlGenerator(Context context) {
        this.mContext = context;
        this.mPersonalInfoManager = MoPub.getPersonalInformationManager();
        this.mConsentData = this.mPersonalInfoManager == null ? null : this.mPersonalInfoManager.getConsentData();
    }

    public AdUrlGenerator withAdUnitId(String adUnitId) {
        this.mAdUnitId = adUnitId;
        return this;
    }

    public AdUrlGenerator withKeywords(String keywords) {
        this.mKeywords = keywords;
        return this;
    }

    public AdUrlGenerator withUserDataKeywords(String userDataKeywords) {
        this.mUserDataKeywords = userDataKeywords;
        return this;
    }

    public AdUrlGenerator withRequestedAdSize(Point adSize) {
        this.mRequestedAdSize = adSize;
        return this;
    }

    public AdUrlGenerator withWindowInsets(WindowInsets windowInsets) {
        this.mWindowInsets = windowInsets;
        return this;
    }

    protected void setAdUnitId(String adUnitId) {
        this.addParam("id", adUnitId);
    }

    protected void setSdkVersion(String sdkVersion) {
        this.addParam("nv", sdkVersion);
    }

    protected void setKeywords(String keywords) {
        this.addParam(KEYWORDS_KEY, keywords);
    }

    protected void setUserDataKeywords(String userDataKeywords) {
        if (!MoPub.canCollectPersonalInformation()) {
            return;
        }
        this.addParam(USER_DATA_KEYWORDS_KEY, userDataKeywords);
    }

    protected void setLocation() {
        if (!MoPub.canCollectPersonalInformation()) {
            return;
        }
        Location location = LocationService.getLastKnownLocation(this.mContext);
        if (location != null) {
            this.addParam(LAT_LONG_KEY, location.getLatitude() + "," + location.getLongitude());
            this.addParam(LAT_LONG_ACCURACY_KEY, String.valueOf((int)location.getAccuracy()));
            this.addParam(LAT_LONG_FRESHNESS_KEY, String.valueOf(AdUrlGenerator.calculateLocationStalenessInMilliseconds(location)));
            this.addParam(LAT_LONG_FROM_SDK_KEY, "1");
        }
    }

    protected void setTimezone(String timeZoneOffsetString) {
        this.addParam(TIMEZONE_OFFSET_KEY, timeZoneOffsetString);
    }

    protected void setOrientation(String orientation) {
        this.addParam(ORIENTATION_KEY, orientation);
    }

    protected void setDensity(float density) {
        this.addParam(SCREEN_SCALE_KEY, "" + density);
    }

    protected void setMraidFlag(boolean mraid) {
        if (mraid) {
            this.addParam(IS_MRAID_KEY, "1");
        }
    }

    protected void setMccCode(String networkOperator) {
        String mcc = networkOperator == null ? "" : networkOperator.substring(0, this.mncPortionLength(networkOperator));
        this.addParam(MOBILE_COUNTRY_CODE_KEY, mcc);
    }

    protected void setMncCode(String networkOperator) {
        String mnc = networkOperator == null ? "" : networkOperator.substring(this.mncPortionLength(networkOperator));
        this.addParam(MOBILE_NETWORK_CODE_KEY, mnc);
    }

    protected void setIsoCountryCode(String networkCountryIso) {
        this.addParam(COUNTRY_CODE_KEY, networkCountryIso);
    }

    protected void setCarrierName(String networkOperatorName) {
        this.addParam(CARRIER_NAME_KEY, networkOperatorName);
    }

    protected void setNetworkType(ClientMetadata.MoPubNetworkType networkType) {
        this.addParam(CARRIER_TYPE_KEY, networkType);
    }

    protected void setBundleId(String bundleId) {
        if (!TextUtils.isEmpty((CharSequence)bundleId)) {
            this.addParam("bundle", bundleId);
        }
    }

    protected void setViewability() {
        int omsdk = ViewabilityManager.isViewabilityEnabled() ? 4 : 0;
        this.addParam(VIEWABILITY_KEY, String.valueOf(omsdk));
        this.addParam(OMSDK_VERSION_KEY, ViewabilityManager.getOmidVersion());
    }

    protected void setAdvancedBiddingTokens() {
        String adTokens = MoPub.getAdvancedBiddingTokensJson(this.mContext);
        this.addParam(ADVANCED_BIDDING_TOKENS_KEY, adTokens);
    }

    protected void setGdprApplies() {
        if (this.mPersonalInfoManager != null) {
            this.addParam("gdpr_applies", this.mPersonalInfoManager.gdprApplies());
        }
    }

    protected void setForceGdprApplies() {
        if (this.mConsentData != null) {
            this.addParam("force_gdpr_applies", this.mConsentData.isForceGdprApplies());
        }
    }

    protected void setCurrentConsentStatus() {
        if (this.mPersonalInfoManager != null) {
            this.addParam("current_consent_status", this.mPersonalInfoManager.getPersonalInfoConsentStatus().getValue());
        }
    }

    protected void setConsentedPrivacyPolicyVersion() {
        if (this.mConsentData != null) {
            this.addParam("consented_privacy_policy_version", this.mConsentData.getConsentedPrivacyPolicyVersion());
        }
    }

    protected void setConsentedVendorListVersion() {
        if (this.mConsentData != null) {
            this.addParam("consented_vendor_list_version", this.mConsentData.getConsentedVendorListVersion());
        }
    }

    protected void addBaseParams(ClientMetadata clientMetadata) {
        this.setAdUnitId(this.mAdUnitId);
        this.setSdkVersion(clientMetadata.getSdkVersion());
        this.appendAppEngineInfo();
        this.appendWrapperVersion();
        this.setDeviceInfo(clientMetadata.getDeviceManufacturer(), clientMetadata.getDeviceModel(), clientMetadata.getDeviceProduct());
        this.setBundleId(clientMetadata.getAppPackageName());
        this.setKeywords(this.mKeywords);
        if (MoPub.canCollectPersonalInformation()) {
            this.setUserDataKeywords(this.mUserDataKeywords);
            this.setLocation();
        }
        this.setTimezone(DateAndTime.getTimeZoneOffsetString());
        this.setOrientation(clientMetadata.getOrientationString());
        this.setDeviceDimensions(clientMetadata.getDeviceDimensions(), this.mRequestedAdSize, this.mWindowInsets);
        this.setDensity(clientMetadata.getDensity());
        String networkOperator = clientMetadata.getNetworkOperatorForUrl();
        this.setMccCode(networkOperator);
        this.setMncCode(networkOperator);
        this.setIsoCountryCode(clientMetadata.getIsoCountryCode());
        this.setCarrierName(clientMetadata.getNetworkOperatorName());
        this.setNetworkType(clientMetadata.getActiveNetworkType());
        this.setAppVersion(clientMetadata.getAppVersion());
        this.setAdvancedBiddingTokens();
        this.appendAdvertisingInfoTemplates();
        this.setGdprApplies();
        this.setForceGdprApplies();
        this.setCurrentConsentStatus();
        this.setConsentedPrivacyPolicyVersion();
        this.setConsentedVendorListVersion();
        this.addRequestRateParameters();
        this.setViewability();
    }

    private void addParam(String key, ClientMetadata.MoPubNetworkType value) {
        this.addParam(key, value.toString());
    }

    private int mncPortionLength(String networkOperator) {
        return Math.min(3, networkOperator.length());
    }

    private static int calculateLocationStalenessInMilliseconds(Location location) {
        Preconditions.checkNotNull(location);
        long locationLastUpdatedInMillis = location.getTime();
        long nowInMillis = System.currentTimeMillis();
        return (int)(nowInMillis - locationLastUpdatedInMillis);
    }

    private void addRequestRateParameters() {
        RequestRateTracker rateTracker = RequestRateTracker.getInstance();
        RequestRateTracker.TimeRecord record = rateTracker.getRecordForAdUnit(this.mAdUnitId);
        if (record == null || record.mBlockIntervalMs < 1) {
            return;
        }
        this.addParam(BACKOFF_TIME_MS_KEY, String.valueOf(record.mBlockIntervalMs));
        this.addParam(BACKOFF_REASON_KEY, record.mReason);
    }

    @Deprecated
    public AdUrlGenerator withFacebookSupported(boolean enabled) {
        return this;
    }
}

