/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.AdapterConfiguration;
import com.mopub.common.AdapterConfigurationsInitializationListener;
import com.mopub.common.Preconditions;
import com.mopub.common.SdkInitializationListener;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.AsyncTasks;
import com.mopub.common.util.Reflection;
import com.mopub.mobileads.MoPubErrorCode;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class AdapterConfigurationManager
implements AdapterConfigurationsInitializationListener {
    private static final String TOKEN_KEY = "token";
    @Nullable
    private volatile Map<String, AdapterConfiguration> mAdapterConfigurations;
    @Nullable
    private SdkInitializationListener mSdkInitializationListener;

    AdapterConfigurationManager(@Nullable SdkInitializationListener sdkInitializationListener) {
        this.mSdkInitializationListener = sdkInitializationListener;
    }

    public void initialize(@NonNull Context context, @NonNull Set<String> adapterConfigurationClasses, @NonNull Map<String, Map<String, String>> networkMediationConfigurations, @NonNull Map<String, Map<String, String>> moPubRequestOptions) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(adapterConfigurationClasses);
        Preconditions.checkNotNull(networkMediationConfigurations);
        Preconditions.checkNotNull(moPubRequestOptions);
        AsyncTasks.safeExecuteOnExecutor(new AdapterConfigurationsInitializationAsyncTask(context.getApplicationContext(), adapterConfigurationClasses, networkMediationConfigurations, moPubRequestOptions, this), new Void[0]);
    }

    @Nullable
    public List<String> getAdvancedBidderNames() {
        Map<String, AdapterConfiguration> adapterConfigurations = this.mAdapterConfigurations;
        if (adapterConfigurations == null || adapterConfigurations.isEmpty()) {
            return null;
        }
        ArrayList<String> abNames = new ArrayList<String>();
        for (AdapterConfiguration adapterConfiguration : adapterConfigurations.values()) {
            abNames.add(adapterConfiguration.getMoPubNetworkName());
        }
        return abNames;
    }

    @Nullable
    public List<String> getAdapterConfigurationInfo() {
        Map<String, AdapterConfiguration> adapterConfigurations = this.mAdapterConfigurations;
        if (adapterConfigurations == null || adapterConfigurations.isEmpty()) {
            return null;
        }
        ArrayList<String> abNames = new ArrayList<String>();
        for (Map.Entry<String, AdapterConfiguration> entry : adapterConfigurations.entrySet()) {
            StringBuilder configDetails = new StringBuilder();
            String adapterName = entry.getKey();
            int lastDotIndex = adapterName.lastIndexOf(".");
            configDetails.append(adapterName.substring(lastDotIndex + 1));
            configDetails.append(": Adapter version ");
            configDetails.append(entry.getValue().getAdapterVersion());
            configDetails.append(", SDK version ");
            configDetails.append(entry.getValue().getNetworkSdkVersion());
            abNames.add(configDetails.toString());
        }
        return abNames;
    }

    @Nullable
    String getTokensAsJsonString(@NonNull Context context) {
        Preconditions.checkNotNull(context);
        JSONObject tokens = this.getTokensAsJsonObject(context);
        if (tokens == null) {
            return null;
        }
        return tokens.toString();
    }

    @Nullable
    private JSONObject getTokensAsJsonObject(@NonNull Context context) {
        Preconditions.checkNotNull(context);
        Map<String, AdapterConfiguration> adapterConfigurations = this.mAdapterConfigurations;
        if (adapterConfigurations == null || adapterConfigurations.isEmpty()) {
            return null;
        }
        JSONObject jsonObject = null;
        for (AdapterConfiguration adapterConfiguration : adapterConfigurations.values()) {
            try {
                String token = adapterConfiguration.getBiddingToken(context);
                if (TextUtils.isEmpty((CharSequence)token)) continue;
                JSONObject bidderJsonObject = new JSONObject();
                bidderJsonObject.put(TOKEN_KEY, (Object)token);
                if (jsonObject == null) {
                    jsonObject = new JSONObject();
                }
                jsonObject.put(adapterConfiguration.getMoPubNetworkName(), (Object)bidderJsonObject);
            }
            catch (JSONException e) {
                MoPubLog.log(MoPubLog.SdkLogEvent.ERROR, "JSON parsing failed for MoPub network name: " + adapterConfiguration.getMoPubNetworkName());
            }
        }
        return jsonObject;
    }

    @VisibleForTesting
    AdapterConfiguration getAdapterConfiguration(@NonNull Class<? extends AdapterConfiguration> clazz) {
        Preconditions.checkNotNull(clazz);
        Map<String, AdapterConfiguration> adapterConfigurations = this.mAdapterConfigurations;
        if (adapterConfigurations == null) {
            return null;
        }
        return adapterConfigurations.get(clazz.getName());
    }

    @Override
    public void onAdapterConfigurationsInitialized(@NonNull Map<String, AdapterConfiguration> adapterConfigurations) {
        Preconditions.checkNotNull(adapterConfigurations);
        this.mAdapterConfigurations = adapterConfigurations;
        SdkInitializationListener sdkInitializationListener = this.mSdkInitializationListener;
        if (sdkInitializationListener != null) {
            sdkInitializationListener.onInitializationFinished();
            this.mSdkInitializationListener = null;
        }
    }

    @Override
    public void onNetworkInitializationFinished(@NonNull Class<? extends AdapterConfiguration> adapterConfigurationClass, @NonNull MoPubErrorCode moPubErrorCode) {
        Preconditions.checkNotNull(adapterConfigurationClass);
        Preconditions.checkNotNull(moPubErrorCode);
        MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, adapterConfigurationClass + " initialized with error code " + moPubErrorCode);
    }

    private static class AdapterConfigurationsInitializationAsyncTask
    extends AsyncTask<Void, Void, Map<String, AdapterConfiguration>> {
        @NonNull
        private final WeakReference<Context> weakContext;
        @NonNull
        private final Set<String> adapterConfigurationClasses;
        @NonNull
        private final Map<String, Map<String, String>> networkMediationConfigurations;
        @NonNull
        private final Map<String, Map<String, String>> moPubRequestOptions;
        @NonNull
        private final AdapterConfigurationsInitializationListener adapterConfigurationsInitializationListener;

        AdapterConfigurationsInitializationAsyncTask(@NonNull Context context, @NonNull Set<String> adapterConfigurationClasses, @NonNull Map<String, Map<String, String>> networkMediationConfigurations, @NonNull Map<String, Map<String, String>> moPubRequestOptions, @NonNull AdapterConfigurationsInitializationListener adapterConfigurationsInitializationListener) {
            Preconditions.checkNotNull(context);
            Preconditions.checkNotNull(adapterConfigurationClasses);
            Preconditions.checkNotNull(networkMediationConfigurations);
            Preconditions.checkNotNull(moPubRequestOptions);
            Preconditions.checkNotNull(adapterConfigurationsInitializationListener);
            this.weakContext = new WeakReference<Context>(context);
            this.adapterConfigurationClasses = adapterConfigurationClasses;
            this.networkMediationConfigurations = networkMediationConfigurations;
            this.moPubRequestOptions = moPubRequestOptions;
            this.adapterConfigurationsInitializationListener = adapterConfigurationsInitializationListener;
        }

        protected Map<String, AdapterConfiguration> doInBackground(Void ... voids) {
            HashMap<String, AdapterConfiguration> adapterConfigurations = new HashMap<String, AdapterConfiguration>();
            for (String adapterConfigurationClass : this.adapterConfigurationClasses) {
                Map<String, String> moPubRequestOption;
                AdapterConfiguration adapterConfiguration;
                try {
                    adapterConfiguration = Reflection.instantiateClassWithEmptyConstructor(adapterConfigurationClass, AdapterConfiguration.class);
                }
                catch (Exception e) {
                    MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM_WITH_THROWABLE, "Unable to find class " + adapterConfigurationClass, e);
                    continue;
                }
                Context context = (Context)this.weakContext.get();
                if (context == null) {
                    MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Context null. Unable to initialize adapter configuration " + adapterConfigurationClass);
                    continue;
                }
                Map<String, String> networkMediationConfiguration = this.networkMediationConfigurations.get(adapterConfigurationClass);
                HashMap<String, String> mergedParameters = new HashMap<String, String>(adapterConfiguration.getCachedInitializationParameters(context));
                if (networkMediationConfiguration != null) {
                    mergedParameters.putAll(networkMediationConfiguration);
                    adapterConfiguration.setCachedInitializationParameters(context, mergedParameters);
                }
                if ((moPubRequestOption = this.moPubRequestOptions.get(adapterConfigurationClass)) != null) {
                    adapterConfiguration.setMoPubRequestOptions(moPubRequestOption);
                }
                MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, String.format(Locale.US, "Initializing %s version %s with network sdk version %s and with params %s", adapterConfigurationClass, adapterConfiguration.getAdapterVersion(), adapterConfiguration.getNetworkSdkVersion(), mergedParameters));
                adapterConfiguration.initializeNetwork(context, mergedParameters, this.adapterConfigurationsInitializationListener);
                adapterConfigurations.put(adapterConfigurationClass, adapterConfiguration);
            }
            return adapterConfigurations;
        }

        protected void onPostExecute(@NonNull Map<String, AdapterConfiguration> adapterConfigurations) {
            this.adapterConfigurationsInitializationListener.onAdapterConfigurationsInitialized(adapterConfigurations);
        }
    }
}

