/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.AdapterConfiguration;
import com.mopub.common.Preconditions;
import com.mopub.common.SharedPreferencesHelper;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Json;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseAdapterConfiguration
implements AdapterConfiguration {
    @VisibleForTesting
    static final String CUSTOM_EVENT_PREF_NAME = "mopubCustomEventSettings";
    @Nullable
    private Map<String, String> mMoPubRequestOptions;

    @Override
    public void setCachedInitializationParameters(@NonNull Context context, @Nullable Map<String, String> initializationParameters) {
        Preconditions.checkNotNull(context);
        if (initializationParameters == null || initializationParameters.isEmpty()) {
            return;
        }
        SharedPreferences sharedPreferences = SharedPreferencesHelper.getSharedPreferences(context, CUSTOM_EVENT_PREF_NAME);
        String serverExtrasJsonString = new JSONObject(initializationParameters).toString();
        String adapterConfigurationClassName = this.getClass().getName();
        MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, String.format(Locale.US, "Updating init settings for base ad %s with params %s", adapterConfigurationClassName, serverExtrasJsonString));
        sharedPreferences.edit().putString(adapterConfigurationClassName, serverExtrasJsonString).apply();
    }

    @Override
    @NonNull
    public Map<String, String> getCachedInitializationParameters(@NonNull Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesHelper.getSharedPreferences(context, CUSTOM_EVENT_PREF_NAME);
        Map networkInitSettings = sharedPreferences.getAll();
        String adapterConfigurationClassName = this.getClass().getName();
        String networkInitParamsJsonString = (String)networkInitSettings.get(adapterConfigurationClassName);
        HashMap<String, String> networkInitParamsMap = new HashMap();
        try {
            networkInitParamsMap = Json.jsonStringToMap(networkInitParamsJsonString);
        }
        catch (JSONException e) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Error fetching init settings for adapter configuration " + adapterConfigurationClassName);
        }
        return networkInitParamsMap;
    }

    @Override
    public void setMoPubRequestOptions(@Nullable Map<String, String> moPubRequestOptions) {
        this.mMoPubRequestOptions = moPubRequestOptions;
    }

    @Override
    @Nullable
    public Map<String, String> getMoPubRequestOptions() {
        return this.mMoPubRequestOptions;
    }
}

