/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.graphics.Point;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.view.DisplayCutout;
import android.view.WindowInsets;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.AppEngineInfo;
import com.mopub.common.Preconditions;
import com.mopub.network.Networking;

public abstract class BaseUrlGenerator {
    protected static final String AD_UNIT_ID_KEY = "id";
    protected static final String SDK_VERSION_KEY = "nv";
    protected static final String IFA_KEY = "ifa";
    protected static final String DNT_KEY = "dnt";
    protected static final String TAS_KEY = "tas";
    protected static final String MOPUB_ID_KEY = "mid";
    protected static final String BUNDLE_ID_KEY = "bundle";
    protected static final String PLATFORM_KEY = "os";
    protected static final String CURRENT_CONSENT_STATUS_KEY = "current_consent_status";
    protected static final String CONSENTED_VENDOR_LIST_VERSION_KEY = "consented_vendor_list_version";
    protected static final String CONSENTED_PRIVACY_POLICY_VERSION_KEY = "consented_privacy_policy_version";
    protected static final String GDPR_APPLIES = "gdpr_applies";
    protected static final String FORCE_GDPR_APPLIES = "force_gdpr_applies";
    private static final String WIDTH_KEY = "w";
    private static final String HEIGHT_KEY = "h";
    private static final String SAFE_WIDTH_KEY = "cw";
    private static final String SAFE_HEIGHT_KEY = "ch";
    private static final String APP_ENGINE_NAME = "e_name";
    private static final String APP_ENGINE_VERSION = "e_ver";
    private static final String WRAPPER_VERSION = "w_ver";
    private StringBuilder mStringBuilder;
    private boolean mFirstParam;
    private static AppEngineInfo mAppEngineInfo = null;
    private static String sWrapperVersion;

    public abstract String generateUrlString(String var1);

    protected void initUrlString(String serverHostname, String handlerType) {
        this.mStringBuilder = new StringBuilder(Networking.getScheme()).append("://").append(serverHostname).append(handlerType);
        this.mFirstParam = true;
    }

    protected String getFinalUrlString() {
        return this.mStringBuilder.toString();
    }

    protected void addParam(String key, String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return;
        }
        this.mStringBuilder.append(this.getParamDelimiter());
        this.mStringBuilder.append(key);
        this.mStringBuilder.append("=");
        this.mStringBuilder.append(Uri.encode((String)value));
    }

    protected void addParam(String key, Boolean value) {
        if (value == null) {
            return;
        }
        this.mStringBuilder.append(this.getParamDelimiter());
        this.mStringBuilder.append(key);
        this.mStringBuilder.append("=");
        this.mStringBuilder.append(value != false ? "1" : "0");
    }

    private String getParamDelimiter() {
        if (this.mFirstParam) {
            this.mFirstParam = false;
            return "?";
        }
        return "&";
    }

    protected void setApiVersion(String apiVersion) {
        this.addParam("v", apiVersion);
    }

    protected void setAppVersion(String appVersion) {
        this.addParam("av", appVersion);
    }

    protected void setDeviceInfo(String ... info) {
        StringBuilder result = new StringBuilder();
        if (info == null || info.length < 1) {
            return;
        }
        for (int i = 0; i < info.length - 1; ++i) {
            result.append(info[i]).append(",");
        }
        result.append(info[info.length - 1]);
        this.addParam("dn", result.toString());
    }

    protected void appendAdvertisingInfoTemplates() {
        this.addParam(IFA_KEY, "mp_tmpl_advertising_id");
        this.addParam(DNT_KEY, "mp_tmpl_do_not_track");
        this.addParam(TAS_KEY, "mp_tmpl_tas");
        this.addParam(MOPUB_ID_KEY, "mp_tmpl_mopub_id");
    }

    public static void setAppEngineInfo(@NonNull AppEngineInfo engineInfo) {
        mAppEngineInfo = engineInfo;
    }

    public static void setWrapperVersion(@NonNull String wrapperVersion) {
        Preconditions.checkNotNull(wrapperVersion);
        sWrapperVersion = wrapperVersion;
    }

    protected void appendAppEngineInfo() {
        AppEngineInfo info = mAppEngineInfo;
        if (info != null) {
            this.addParam(APP_ENGINE_NAME, info.mName);
            this.addParam(APP_ENGINE_VERSION, info.mVersion);
        }
    }

    protected void appendWrapperVersion() {
        this.addParam(WRAPPER_VERSION, sWrapperVersion);
    }

    protected void setDeviceDimensions(@NonNull Point dimensions, @Nullable Point requestedAdSize, @Nullable WindowInsets windowInsets) {
        int requestedHeight;
        int requestedWidth = requestedAdSize != null ? requestedAdSize.x : 0;
        int n = requestedHeight = requestedAdSize != null ? requestedAdSize.y : 0;
        if (Build.VERSION.SDK_INT >= 28 && windowInsets != null && windowInsets.getDisplayCutout() != null) {
            DisplayCutout displayCutout = windowInsets.getDisplayCutout();
            int safeWidth = dimensions.x - displayCutout.getSafeInsetLeft() - displayCutout.getSafeInsetRight();
            int safeHeight = dimensions.y - displayCutout.getSafeInsetTop() - displayCutout.getSafeInsetBottom();
            this.addParam(SAFE_WIDTH_KEY, "" + Math.min(safeWidth, requestedWidth));
            this.addParam(SAFE_HEIGHT_KEY, "" + Math.min(safeHeight, requestedHeight));
        } else {
            this.addParam(SAFE_WIDTH_KEY, "" + requestedWidth);
            this.addParam(SAFE_HEIGHT_KEY, "" + requestedHeight);
        }
        this.addParam(WIDTH_KEY, "" + dimensions.x);
        this.addParam(HEIGHT_KEY, "" + dimensions.y);
    }
}

