/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.content.Context;
import android.os.AsyncTask;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.DiskLruCache;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.DeviceUtils;
import com.mopub.common.util.Streams;
import com.mopub.common.util.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CacheService {
    static final String UNIQUE_CACHE_NAME = "mopub-cache";
    private static final int APP_VERSION = 1;
    private static final int VALUE_COUNT = 1;
    private static final int DISK_CACHE_INDEX = 0;
    private static DiskLruCache sDiskLruCache;

    public static boolean initializeDiskCache(Context context) {
        if (context == null) {
            return false;
        }
        if (sDiskLruCache == null) {
            File cacheDirectory = CacheService.getDiskCacheDirectory(context);
            if (cacheDirectory == null) {
                return false;
            }
            long diskCacheSizeBytes = DeviceUtils.diskCacheSizeBytes(cacheDirectory);
            try {
                sDiskLruCache = DiskLruCache.open(cacheDirectory, 1, 1, diskCacheSizeBytes);
            }
            catch (IOException e) {
                MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Unable to create DiskLruCache", e);
                return false;
            }
        }
        return true;
    }

    public static void initialize(Context context) {
        CacheService.initializeDiskCache(context);
    }

    public static String createValidDiskCacheKey(String key) {
        return Utils.sha1(key);
    }

    @Nullable
    public static File getDiskCacheDirectory(@NonNull Context context) {
        File cacheDir = context.getCacheDir();
        if (cacheDir == null) {
            return null;
        }
        String cachePath = cacheDir.getPath();
        return new File(cachePath + File.separator + UNIQUE_CACHE_NAME);
    }

    public static boolean containsKeyDiskCache(String key) {
        if (sDiskLruCache == null) {
            return false;
        }
        try {
            DiskLruCache.Snapshot snapshot = sDiskLruCache.get(CacheService.createValidDiskCacheKey(key));
            return snapshot != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getFilePathDiskCache(String key) {
        if (sDiskLruCache == null) {
            return null;
        }
        return sDiskLruCache.getDirectory() + File.separator + CacheService.createValidDiskCacheKey(key) + "." + 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFromDiskCache(String key) {
        byte[] bytes;
        block12: {
            if (sDiskLruCache == null) {
                return null;
            }
            bytes = null;
            try (DiskLruCache.Snapshot snapshot = null;){
                snapshot = sDiskLruCache.get(CacheService.createValidDiskCacheKey(key));
                if (snapshot == null) {
                    byte[] byArray = null;
                    return byArray;
                }
                InputStream in = snapshot.getInputStream(0);
                if (in == null) break block12;
                bytes = new byte[(int)snapshot.getLength(0)];
                BufferedInputStream buffIn = new BufferedInputStream(in);
                try {
                    Streams.readStream(buffIn, bytes);
                }
                finally {
                    Streams.closeStream(buffIn);
                }
            }
        }
        return bytes;
    }

    public static void getFromDiskCacheAsync(String key, DiskLruCacheGetListener diskLruCacheGetListener) {
        new DiskLruCacheGetTask(key, diskLruCacheGetListener).execute(new Void[0]);
    }

    public static boolean putToDiskCache(String key, byte[] content) {
        return CacheService.putToDiskCache(key, new ByteArrayInputStream(content));
    }

    public static boolean putToDiskCache(String key, InputStream content) {
        if (sDiskLruCache == null) {
            return false;
        }
        DiskLruCache.Editor editor = null;
        try {
            editor = sDiskLruCache.edit(CacheService.createValidDiskCacheKey(key));
            if (editor == null) {
                return false;
            }
            BufferedOutputStream outputStream = new BufferedOutputStream(editor.newOutputStream(0));
            Streams.copyContent(content, outputStream);
            ((OutputStream)outputStream).flush();
            ((OutputStream)outputStream).close();
            sDiskLruCache.flush();
            editor.commit();
        }
        catch (Exception e) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Unable to put to DiskLruCache", e);
            try {
                if (editor != null) {
                    editor.abort();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public static void putToDiskCacheAsync(String key, byte[] content) {
        new DiskLruCachePutTask(key, content).execute(new Void[0]);
    }

    @Deprecated
    @VisibleForTesting
    public static void clearAndNullCaches() {
        if (sDiskLruCache != null) {
            try {
                sDiskLruCache.delete();
                sDiskLruCache = null;
            }
            catch (IOException ignore) {
                sDiskLruCache = null;
            }
        }
    }

    @Deprecated
    @VisibleForTesting
    public static DiskLruCache getDiskLruCache() {
        return sDiskLruCache;
    }

    private static class DiskLruCachePutTask
    extends AsyncTask<Void, Void, Void> {
        private final String mKey;
        private final byte[] mContent;

        DiskLruCachePutTask(String key, byte[] content) {
            this.mKey = key;
            this.mContent = content;
        }

        protected Void doInBackground(Void ... voids) {
            CacheService.putToDiskCache(this.mKey, this.mContent);
            return null;
        }
    }

    private static class DiskLruCacheGetTask
    extends AsyncTask<Void, Void, byte[]> {
        private final DiskLruCacheGetListener mDiskLruCacheGetListener;
        private final String mKey;

        DiskLruCacheGetTask(String key, DiskLruCacheGetListener diskLruCacheGetListener) {
            this.mDiskLruCacheGetListener = diskLruCacheGetListener;
            this.mKey = key;
        }

        protected byte[] doInBackground(Void ... voids) {
            return CacheService.getFromDiskCache(this.mKey);
        }

        protected void onPostExecute(byte[] bytes) {
            if (this.isCancelled()) {
                this.onCancelled();
                return;
            }
            if (this.mDiskLruCacheGetListener != null) {
                this.mDiskLruCacheGetListener.onComplete(this.mKey, bytes);
            }
        }

        protected void onCancelled() {
            if (this.mDiskLruCacheGetListener != null) {
                this.mDiskLruCacheGetListener.onComplete(this.mKey, null);
            }
        }
    }

    public static interface DiskLruCacheGetListener {
        public void onComplete(String var1, byte[] var2);
    }
}

