/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.util.Dips;
import com.mopub.mobileads.base.R;

public class CloseableLayout
extends FrameLayout {
    @VisibleForTesting
    static final float CLOSE_BUTTON_SIZE_DP = 34.0f;
    static final float CLOSE_REGION_SIZE_DP = 50.0f;
    @VisibleForTesting
    static final float CLOSE_BUTTON_PADDING_DP = 8.0f;
    private final int mTouchSlop;
    @Nullable
    private OnCloseListener mOnCloseListener;
    @Nullable
    private final Drawable mCloseDrawable;
    @NonNull
    private ClosePosition mClosePosition;
    private final int mCloseRegionSize;
    private final int mCloseButtonSize;
    private final int mCloseButtonPadding;
    private boolean mCloseBoundChanged;
    private final Rect mClosableLayoutRect = new Rect();
    private final Rect mCloseRegionBounds = new Rect();
    private final Rect mCloseButtonBounds = new Rect();
    private final Rect mInsetCloseRegionBounds = new Rect();
    private boolean mCloseAlwaysInteractable;
    private boolean mClosePressed;
    @Nullable
    private UnsetPressedState mUnsetPressedState;

    public CloseableLayout(@NonNull Context context) {
        this(context, null, 0);
    }

    public CloseableLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CloseableLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mCloseDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_mopub_close_button);
        this.mClosePosition = ClosePosition.TOP_RIGHT;
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mCloseRegionSize = Dips.asIntPixels(50.0f, context);
        this.mCloseButtonSize = Dips.asIntPixels(34.0f, context);
        this.mCloseButtonPadding = Dips.asIntPixels(8.0f, context);
        this.setWillNotDraw(false);
        this.mCloseAlwaysInteractable = true;
    }

    public void setOnCloseListener(@Nullable OnCloseListener onCloseListener) {
        this.mOnCloseListener = onCloseListener;
    }

    public void setClosePosition(@NonNull ClosePosition closePosition) {
        Preconditions.checkNotNull((Object)closePosition);
        this.mClosePosition = closePosition;
        this.mCloseBoundChanged = true;
        this.invalidate();
    }

    public void setCloseVisible(boolean visible) {
        if (this.mCloseDrawable != null && this.mCloseDrawable.setVisible(visible, false)) {
            this.invalidate(this.mCloseRegionBounds);
        }
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        super.onSizeChanged(width, height, oldWidth, oldHeight);
        this.mCloseBoundChanged = true;
    }

    public void draw(@NonNull Canvas canvas) {
        super.draw(canvas);
        if (this.mCloseBoundChanged) {
            this.mCloseBoundChanged = false;
            this.mClosableLayoutRect.set(0, 0, this.getWidth(), this.getHeight());
            this.applyCloseRegionBounds(this.mClosePosition, this.mClosableLayoutRect, this.mCloseRegionBounds);
            this.mInsetCloseRegionBounds.set(this.mCloseRegionBounds);
            this.mInsetCloseRegionBounds.inset(this.mCloseButtonPadding, this.mCloseButtonPadding);
            this.applyCloseButtonBounds(this.mClosePosition, this.mInsetCloseRegionBounds, this.mCloseButtonBounds);
            if (this.mCloseDrawable != null) {
                this.mCloseDrawable.setBounds(this.mCloseButtonBounds);
            }
        }
        if (this.mCloseDrawable != null && this.mCloseDrawable.isVisible()) {
            this.mCloseDrawable.draw(canvas);
        }
    }

    public void applyCloseRegionBounds(ClosePosition closePosition, Rect bounds, Rect closeBounds) {
        this.applyCloseBoundsWithSize(closePosition, this.mCloseRegionSize, bounds, closeBounds);
    }

    private void applyCloseButtonBounds(ClosePosition closePosition, Rect bounds, Rect outBounds) {
        this.applyCloseBoundsWithSize(closePosition, this.mCloseButtonSize, bounds, outBounds);
    }

    private void applyCloseBoundsWithSize(ClosePosition closePosition, int size, Rect bounds, Rect outBounds) {
        Gravity.apply((int)closePosition.getGravity(), (int)size, (int)size, (Rect)bounds, (Rect)outBounds);
    }

    public boolean onInterceptTouchEvent(@NonNull MotionEvent event) {
        if (event.getAction() != 0) {
            return false;
        }
        int x = (int)event.getX();
        int y = (int)event.getY();
        return this.pointInCloseBounds(x, y, 0);
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        int y;
        int x = (int)event.getX();
        if (!this.pointInCloseBounds(x, y = (int)event.getY(), this.mTouchSlop) || !this.shouldAllowPress()) {
            this.setClosePressed(false);
            super.onTouchEvent(event);
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.setClosePressed(true);
                break;
            }
            case 3: {
                this.setClosePressed(false);
                break;
            }
            case 1: {
                if (!this.isClosePressed()) break;
                if (this.mUnsetPressedState == null) {
                    this.mUnsetPressedState = new UnsetPressedState();
                }
                this.postDelayed(this.mUnsetPressedState, ViewConfiguration.getPressedStateDuration());
                this.performClose();
            }
        }
        return true;
    }

    public void setCloseAlwaysInteractable(boolean closeAlwaysInteractable) {
        this.mCloseAlwaysInteractable = closeAlwaysInteractable;
    }

    @VisibleForTesting
    boolean shouldAllowPress() {
        return this.mCloseAlwaysInteractable || this.mCloseDrawable == null || this.mCloseDrawable.isVisible();
    }

    private void setClosePressed(boolean pressed) {
        if (pressed == this.isClosePressed()) {
            return;
        }
        this.mClosePressed = pressed;
        this.invalidate(this.mCloseRegionBounds);
    }

    @VisibleForTesting
    boolean isClosePressed() {
        return this.mClosePressed;
    }

    @VisibleForTesting
    boolean pointInCloseBounds(int x, int y, int slop) {
        return x >= this.mCloseRegionBounds.left - slop && y >= this.mCloseRegionBounds.top - slop && x < this.mCloseRegionBounds.right + slop && y < this.mCloseRegionBounds.bottom + slop;
    }

    private void performClose() {
        this.playSoundEffect(0);
        if (this.mOnCloseListener != null) {
            this.mOnCloseListener.onClose();
        }
    }

    @VisibleForTesting
    void setCloseBounds(Rect closeBounds) {
        this.mCloseRegionBounds.set(closeBounds);
    }

    @VisibleForTesting
    Rect getCloseBounds() {
        return this.mCloseRegionBounds;
    }

    @VisibleForTesting
    void setCloseBoundChanged(boolean changed) {
        this.mCloseBoundChanged = changed;
    }

    @VisibleForTesting
    public boolean isCloseVisible() {
        return this.mCloseDrawable != null && this.mCloseDrawable.isVisible();
    }

    private final class UnsetPressedState
    implements Runnable {
        private UnsetPressedState() {
        }

        @Override
        public void run() {
            CloseableLayout.this.setClosePressed(false);
        }
    }

    public static enum ClosePosition {
        TOP_LEFT(51),
        TOP_CENTER(49),
        TOP_RIGHT(53),
        CENTER(17),
        BOTTOM_LEFT(83),
        BOTTOM_CENTER(81),
        BOTTOM_RIGHT(85);

        private final int mGravity;

        private ClosePosition(int mGravity) {
            this.mGravity = mGravity;
        }

        int getGravity() {
            return this.mGravity;
        }
    }

    public static interface OnCloseListener {
        public void onClose();
    }
}

