/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import com.mopub.common.DiskLruCacheUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

class DiskLruCacheStrictLineReader
implements Closeable {
    private static final byte CR = 13;
    private static final byte LF = 10;
    private final InputStream in;
    private final Charset charset;
    private byte[] buf;
    private int pos;
    private int end;

    public DiskLruCacheStrictLineReader(InputStream in, Charset charset) {
        this(in, 8192, charset);
    }

    public DiskLruCacheStrictLineReader(InputStream in, int capacity, Charset charset) {
        if (in == null || charset == null) {
            throw new NullPointerException();
        }
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity <= 0");
        }
        if (!charset.equals(DiskLruCacheUtil.US_ASCII)) {
            throw new IllegalArgumentException("Unsupported encoding");
        }
        this.in = in;
        this.charset = charset;
        this.buf = new byte[capacity];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            if (this.buf != null) {
                this.buf = null;
                this.in.close();
            }
        }
    }

    public String readLine() throws IOException {
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            if (this.buf == null) {
                throw new IOException("LineReader is closed");
            }
            if (this.pos >= this.end) {
                this.fillBuf();
            }
            for (int i = this.pos; i != this.end; ++i) {
                if (this.buf[i] != 10) continue;
                int lineEnd = i != this.pos && this.buf[i - 1] == 13 ? i - 1 : i;
                String res = new String(this.buf, this.pos, lineEnd - this.pos, this.charset.name());
                this.pos = i + 1;
                return res;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(this.end - this.pos + 80){

                @Override
                public String toString() {
                    int length = this.count > 0 && this.buf[this.count - 1] == 13 ? this.count - 1 : this.count;
                    try {
                        return new String(this.buf, 0, length, DiskLruCacheStrictLineReader.this.charset.name());
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new AssertionError((Object)e);
                    }
                }
            };
            block4: while (true) {
                out.write(this.buf, this.pos, this.end - this.pos);
                this.end = -1;
                this.fillBuf();
                int i = this.pos;
                while (true) {
                    if (i == this.end) continue block4;
                    if (this.buf[i] == 10) {
                        if (i != this.pos) {
                            out.write(this.buf, this.pos, i - this.pos);
                        }
                        this.pos = i + 1;
                        return out.toString();
                    }
                    ++i;
                }
                break;
            }
        }
    }

    private void fillBuf() throws IOException {
        int result = this.in.read(this.buf, 0, this.buf.length);
        if (result == -1) {
            throw new EOFException();
        }
        this.pos = 0;
        this.end = result;
    }
}

