/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.util.Pair;
import android.view.View;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.mopub.common.Preconditions;
import com.mopub.common.VideoEvent;
import com.mopub.common.ViewabilityObstruction;
import com.mopub.common.ViewabilityTracker;
import com.mopub.common.ViewabilityTrackerVideo;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import java.util.HashSet;
import java.util.Set;

public class ExternalViewabilitySessionManager {
    @Nullable
    private ViewabilityTracker mViewabilityTracker = null;
    @NonNull
    final Set<Pair<View, ViewabilityObstruction>> mObstructions = new HashSet<Pair<View, ViewabilityObstruction>>();
    @Nullable
    private static ExternalViewabilityManagerFactory sCreator;

    private ExternalViewabilitySessionManager() {
    }

    @NonNull
    public static ExternalViewabilitySessionManager create() {
        if (sCreator == null) {
            return new ExternalViewabilitySessionManager();
        }
        return sCreator.create();
    }

    @UiThread
    public void createWebViewSession(@NonNull WebView webView) {
        Preconditions.checkUiThread();
        Preconditions.checkNotNull(webView);
        if (this.mViewabilityTracker != null) {
            return;
        }
        try {
            this.mViewabilityTracker = ViewabilityTracker.createWebViewTracker(webView);
        }
        catch (Exception ex) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM_WITH_THROWABLE, "createWebViewTracker failed", ex);
        }
    }

    @UiThread
    public void createNativeSession(@NonNull View adView, @NonNull Set<com.mopub.common.ViewabilityVendor> viewabilityVendors) {
        Preconditions.checkUiThread();
        Preconditions.checkNotNull(adView);
        Preconditions.checkNotNull(viewabilityVendors);
        if (this.mViewabilityTracker != null) {
            return;
        }
        try {
            this.mViewabilityTracker = ViewabilityTracker.createNativeTracker(adView, viewabilityVendors);
        }
        catch (Exception ex) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM_WITH_THROWABLE, "createNativeTracker failed", ex);
        }
    }

    @UiThread
    public void createVideoSession(@NonNull View videoView, @NonNull Set<com.mopub.common.ViewabilityVendor> viewabilityVendors) {
        Preconditions.checkUiThread();
        Preconditions.checkNotNull(videoView);
        Preconditions.checkNotNull(viewabilityVendors);
        if (this.mViewabilityTracker != null) {
            return;
        }
        try {
            this.mViewabilityTracker = ViewabilityTrackerVideo.createVastVideoTracker(videoView, viewabilityVendors);
        }
        catch (Exception ex) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM_WITH_THROWABLE, "createVastVideoTracker failed", ex);
        }
    }

    @UiThread
    public void startSession() {
        Preconditions.checkUiThread();
        try {
            if (this.mViewabilityTracker != null) {
                this.registerFriendlyObstruction(null, null);
                this.mViewabilityTracker.startTracking();
            }
        }
        catch (Exception ex) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM_WITH_THROWABLE, "startSession()", ex);
        }
    }

    @UiThread
    public boolean isTracking() {
        Preconditions.checkUiThread();
        if (this.mViewabilityTracker == null) {
            return false;
        }
        return this.mViewabilityTracker.isTracking();
    }

    @UiThread
    public void trackImpression() {
        Preconditions.checkUiThread();
        try {
            if (this.mViewabilityTracker != null) {
                this.mViewabilityTracker.trackImpression();
            }
        }
        catch (Exception ex) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM_WITH_THROWABLE, "trackImpression()", ex);
        }
    }

    public boolean hasImpressionOccurred() {
        if (this.mViewabilityTracker != null) {
            return this.mViewabilityTracker.hasImpressionOccurred();
        }
        return false;
    }

    public void registerTrackedView(@NonNull View adView) {
        if (this.mViewabilityTracker != null) {
            this.mViewabilityTracker.registerTrackedView(adView);
        }
    }

    @UiThread
    public void endSession() {
        Preconditions.checkUiThread();
        try {
            if (this.mViewabilityTracker != null) {
                this.mViewabilityTracker.stopTracking();
            }
        }
        catch (Exception ex) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM_WITH_THROWABLE, "stopTracking failed", ex);
        }
    }

    @UiThread
    public void registerFriendlyObstruction(@Nullable View view, @Nullable ViewabilityObstruction purpose) {
        Preconditions.checkUiThread();
        ViewabilityTracker tracker = this.mViewabilityTracker;
        try {
            if (tracker == null) {
                if (view != null && purpose != null) {
                    this.mObstructions.add((Pair<View, ViewabilityObstruction>)new Pair((Object)view, (Object)purpose));
                }
            } else {
                if (view != null && purpose != null) {
                    tracker.registerFriendlyObstruction(view, purpose);
                }
                if (this.mObstructions.size() > 0) {
                    tracker.registerFriendlyObstructions(this.mObstructions);
                    this.mObstructions.clear();
                }
            }
        }
        catch (Exception ex) {
            MoPubLog.log(MoPubLog.AdLogEvent.CUSTOM, ex.getLocalizedMessage());
        }
    }

    public void registerVideoObstruction(@Nullable View view, @Nullable ViewabilityObstruction purpose) {
        this.registerFriendlyObstruction(view, purpose);
    }

    @UiThread
    public void onVideoPrepared(long durationMills) {
        Preconditions.checkUiThread();
        try {
            if (this.mViewabilityTracker != null) {
                this.mViewabilityTracker.videoPrepared((float)durationMills / 1000.0f);
            }
        }
        catch (Exception ex) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM_WITH_THROWABLE, "videoPrepared failed", ex);
        }
    }

    @UiThread
    public void recordVideoEvent(@NonNull VideoEvent event, int playheadMillis) {
        Preconditions.checkUiThread();
        Preconditions.checkNotNull((Object)event);
        try {
            if (this.mViewabilityTracker != null) {
                this.mViewabilityTracker.trackVideo(event);
            }
        }
        catch (Exception ex) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM_WITH_THROWABLE, "trackVideo failed", ex);
        }
    }

    @VisibleForTesting
    void setMockViewabilityTracker(@Nullable ViewabilityTracker tracker) {
        this.mViewabilityTracker = tracker;
    }

    @VisibleForTesting
    public static void setCreator(@Nullable ExternalViewabilityManagerFactory factory) {
        sCreator = factory;
    }

    @VisibleForTesting
    public static interface ExternalViewabilityManagerFactory {
        @NonNull
        public ExternalViewabilitySessionManager create();
    }

    @Deprecated
    public static enum ViewabilityVendor {
        AVID,
        MOAT,
        ALL;

    }
}

