/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.content.Context;
import android.location.Location;
import android.location.LocationManager;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.MoPub;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.DeviceUtils;
import java.math.BigDecimal;

public class LocationService {
    private static final int DEFAULT_LOCATION_PRECISION = 6;
    private static final long DEFAULT_LOCATION_REFRESH_TIME_MILLIS = 600000L;
    private static volatile LocationService sInstance;
    @VisibleForTesting
    @Nullable
    Location mLastKnownLocation;
    @VisibleForTesting
    long mLocationLastUpdatedMillis;
    @NonNull
    private volatile MoPub.LocationAwareness mLocationAwareness = MoPub.LocationAwareness.NORMAL;
    private volatile int mLocationPrecision = 6;
    private volatile long mMinimumLocationRefreshTimeMillis = 600000L;

    private LocationService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    @NonNull
    static LocationService getInstance() {
        LocationService locationService = sInstance;
        if (locationService != null) return locationService;
        Class<LocationService> clazz = LocationService.class;
        synchronized (LocationService.class) {
            locationService = sInstance;
            if (locationService != null) return locationService;
            sInstance = locationService = new LocationService();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return locationService;
        }
    }

    @NonNull
    MoPub.LocationAwareness getLocationAwareness() {
        return this.mLocationAwareness;
    }

    void setLocationAwareness(@NonNull MoPub.LocationAwareness locationAwareness) {
        Preconditions.checkNotNull((Object)locationAwareness);
        this.mLocationAwareness = locationAwareness;
    }

    int getLocationPrecision() {
        return this.mLocationPrecision;
    }

    void setLocationPrecision(int precision) {
        this.mLocationPrecision = Math.min(Math.max(0, precision), 6);
    }

    void setMinimumLocationRefreshTimeMillis(long minimumLocationRefreshTimeMillis) {
        this.mMinimumLocationRefreshTimeMillis = minimumLocationRefreshTimeMillis;
    }

    long getMinimumLocationRefreshTimeMillis() {
        return this.mMinimumLocationRefreshTimeMillis;
    }

    @Nullable
    public static Location getLastKnownLocation(@Nullable Context context) {
        if (!MoPub.canCollectPersonalInformation()) {
            return null;
        }
        LocationService locationService = LocationService.getInstance();
        MoPub.LocationAwareness locationAwareness = locationService.mLocationAwareness;
        int locationPrecision = locationService.mLocationPrecision;
        if (locationAwareness == MoPub.LocationAwareness.DISABLED) {
            return null;
        }
        if (LocationService.isLocationFreshEnough()) {
            return locationService.mLastKnownLocation;
        }
        if (context == null) {
            return null;
        }
        Location location = LocationService.getLocationFromProvider(context, ValidLocationProvider.GPS);
        if (location == null) {
            location = LocationService.getLocationFromProvider(context, ValidLocationProvider.NETWORK);
        }
        if (locationAwareness == MoPub.LocationAwareness.TRUNCATED) {
            LocationService.truncateLocationLatLon(location, locationPrecision);
        }
        if (location != null) {
            locationService.setLastLocation(location);
        }
        return locationService.mLastKnownLocation;
    }

    @VisibleForTesting
    @Nullable
    static Location getLocationFromProvider(@NonNull Context context, @NonNull ValidLocationProvider provider) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull((Object)provider);
        if (!MoPub.canCollectPersonalInformation()) {
            return null;
        }
        if (!provider.hasRequiredPermissions(context)) {
            return null;
        }
        LocationManager locationManager = (LocationManager)context.getSystemService("location");
        try {
            return locationManager.getLastKnownLocation(provider.toString());
        }
        catch (SecurityException e) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Failed to retrieve location from " + provider.toString() + " provider: access appears to be disabled.");
        }
        catch (IllegalArgumentException e) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Failed to retrieve location: device has no " + provider.toString() + " location provider.");
        }
        catch (NullPointerException e) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Failed to retrieve location: device has no " + provider.toString() + " location provider.");
        }
        return null;
    }

    @VisibleForTesting
    @Nullable
    static Location getMostRecentValidLocation(@Nullable Location a, @Nullable Location b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.getTime() > b.getTime() ? a : b;
    }

    @VisibleForTesting
    static void truncateLocationLatLon(@Nullable Location location, int precision) {
        if (location == null || precision < 0) {
            return;
        }
        double lat = location.getLatitude();
        double truncatedLat = BigDecimal.valueOf(lat).setScale(precision, 5).doubleValue();
        location.setLatitude(truncatedLat);
        double lon = location.getLongitude();
        double truncatedLon = BigDecimal.valueOf(lon).setScale(precision, 5).doubleValue();
        location.setLongitude(truncatedLon);
    }

    private static boolean isLocationFreshEnough() {
        LocationService locationService = LocationService.getInstance();
        if (locationService.mLastKnownLocation == null) {
            return false;
        }
        return SystemClock.elapsedRealtime() - locationService.mLocationLastUpdatedMillis <= locationService.getMinimumLocationRefreshTimeMillis();
    }

    @Deprecated
    @VisibleForTesting
    public static void clearLastKnownLocation() {
        LocationService.getInstance().mLastKnownLocation = null;
    }

    void setLastLocation(@Nullable Location location) {
        if (location == null) {
            return;
        }
        LocationService locationService = LocationService.getInstance();
        locationService.mLastKnownLocation = location;
        locationService.mLocationLastUpdatedMillis = SystemClock.elapsedRealtime();
    }

    public static enum ValidLocationProvider {
        NETWORK("network"),
        GPS("gps");

        @NonNull
        final String name;

        private ValidLocationProvider(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        private boolean hasRequiredPermissions(@NonNull Context context) {
            switch (this) {
                case NETWORK: {
                    return DeviceUtils.isPermissionGranted(context, "android.permission.ACCESS_FINE_LOCATION") || DeviceUtils.isPermissionGranted(context, "android.permission.ACCESS_COARSE_LOCATION");
                }
                case GPS: {
                    return DeviceUtils.isPermissionGranted(context, "android.permission.ACCESS_FINE_LOCATION");
                }
            }
            return false;
        }
    }

    public static enum LocationAwareness {
        NORMAL,
        TRUNCATED,
        DISABLED;


        @Deprecated
        public MoPub.LocationAwareness getNewLocationAwareness() {
            if (this == TRUNCATED) {
                return MoPub.LocationAwareness.TRUNCATED;
            }
            if (this == DISABLED) {
                return MoPub.LocationAwareness.DISABLED;
            }
            return MoPub.LocationAwareness.NORMAL;
        }

        @Deprecated
        public static LocationAwareness fromMoPubLocationAwareness(MoPub.LocationAwareness awareness) {
            if (awareness == MoPub.LocationAwareness.DISABLED) {
                return DISABLED;
            }
            if (awareness == MoPub.LocationAwareness.TRUNCATED) {
                return TRUNCATED;
            }
            return NORMAL;
        }
    }
}

