/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.mopub.common.AdapterConfigurationManager;
import com.mopub.common.AppEngineInfo;
import com.mopub.common.BaseUrlGenerator;
import com.mopub.common.ClientMetadata;
import com.mopub.common.CompositeSdkInitializationListener;
import com.mopub.common.ExternalViewabilitySessionManager;
import com.mopub.common.LocationService;
import com.mopub.common.MoPubLifecycleManager;
import com.mopub.common.Preconditions;
import com.mopub.common.SdkConfiguration;
import com.mopub.common.SdkInitializationListener;
import com.mopub.common.ViewabilityManager;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.privacy.PersonalInfoManager;
import com.mopub.common.util.Reflection;
import com.mopub.network.Networking;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class MoPub {
    public static final String SDK_VERSION = "5.14.0";
    private static final String MOPUB_REWARDED_VIDEOS = "com.mopub.mobileads.MoPubRewardedVideos";
    private static final String MOPUB_REWARDED_VIDEO_MANAGER = "com.mopub.mobileads.MoPubRewardedVideoManager";
    @NonNull
    private static volatile BrowserAgent sBrowserAgent = BrowserAgent.IN_APP;
    private static volatile boolean sIsBrowserAgentOverriddenByClient = false;
    private static boolean sSearchedForUpdateActivityMethod = false;
    @Nullable
    private static Method sUpdateActivityMethod;
    private static boolean sSdkInitialized;
    private static boolean sSdkInitializing;
    private static AdapterConfigurationManager sAdapterConfigurationManager;
    private static PersonalInfoManager sPersonalInfoManager;

    @NonNull
    public static LocationAwareness getLocationAwareness() {
        return LocationService.getInstance().getLocationAwareness();
    }

    public static void setLocationAwareness(@NonNull LocationAwareness locationAwareness) {
        Preconditions.checkNotNull((Object)locationAwareness);
        LocationService.getInstance().setLocationAwareness(locationAwareness);
    }

    public static int getLocationPrecision() {
        return LocationService.getInstance().getLocationPrecision();
    }

    public static void setLocationPrecision(int precision) {
        LocationService.getInstance().setLocationPrecision(precision);
    }

    public static void setMinimumLocationRefreshTimeMillis(long minimumLocationRefreshTimeMillis) {
        LocationService.getInstance().setMinimumLocationRefreshTimeMillis(minimumLocationRefreshTimeMillis);
    }

    public static long getMinimumLocationRefreshTimeMillis() {
        return LocationService.getInstance().getMinimumLocationRefreshTimeMillis();
    }

    public static void setBrowserAgent(@NonNull BrowserAgent browserAgent) {
        Preconditions.checkNotNull((Object)browserAgent);
        sBrowserAgent = browserAgent;
        sIsBrowserAgentOverriddenByClient = true;
    }

    public static void setBrowserAgentFromAdServer(@NonNull BrowserAgent adServerBrowserAgent) {
        Preconditions.checkNotNull((Object)adServerBrowserAgent);
        if (sIsBrowserAgentOverriddenByClient) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Browser agent already overridden by client with value " + (Object)((Object)sBrowserAgent));
        } else {
            sBrowserAgent = adServerBrowserAgent;
        }
    }

    @NonNull
    public static BrowserAgent getBrowserAgent() {
        Preconditions.checkNotNull((Object)sBrowserAgent);
        return sBrowserAgent;
    }

    public static void setEngineInformation(@NonNull AppEngineInfo engineInfo) {
        Preconditions.checkNotNull(engineInfo);
        if (!TextUtils.isEmpty((CharSequence)engineInfo.mName) && !TextUtils.isEmpty((CharSequence)engineInfo.mVersion)) {
            BaseUrlGenerator.setAppEngineInfo(engineInfo);
        }
    }

    public static void setWrapperVersion(@NonNull String wrapperVersion) {
        Preconditions.checkNotNull(wrapperVersion);
        BaseUrlGenerator.setWrapperVersion(wrapperVersion);
    }

    public static void initializeSdk(@NonNull Context context, @NonNull SdkConfiguration sdkConfiguration, @Nullable SdkInitializationListener sdkInitializationListener) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(sdkConfiguration);
        MoPubLog.setLogLevel(sdkConfiguration.getLogLevel());
        MoPubLog.log(MoPubLog.SdkLogEvent.INIT_STARTED, new Object[0]);
        MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "SDK initialize has been called with ad unit: " + sdkConfiguration.getAdUnitId());
        ApplicationInfo appInfo = context.getApplicationInfo();
        if (appInfo != null) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, context.getPackageName() + " was built with target SDK version of " + appInfo.targetSdkVersion);
        }
        ViewabilityManager.activate(context.getApplicationContext());
        if (context instanceof Activity) {
            Activity activity = (Activity)context;
            MoPub.initializeRewardedVideo(activity, sdkConfiguration);
        }
        if (sSdkInitialized) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "MoPub SDK is already initialized");
            MoPub.initializationFinished(sdkInitializationListener);
            return;
        }
        if (sSdkInitializing) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "MoPub SDK is currently initializing.");
            return;
        }
        if (Looper.getMainLooper() != Looper.myLooper()) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "MoPub can only be initialized on the main thread.");
            return;
        }
        sSdkInitializing = true;
        Networking.getRequestQueue(context);
        InternalSdkInitializationListener internalSdkInitializationListener = new InternalSdkInitializationListener(sdkInitializationListener);
        CompositeSdkInitializationListener compositeSdkInitializationListener = new CompositeSdkInitializationListener(internalSdkInitializationListener, 2);
        sPersonalInfoManager = new PersonalInfoManager(context, sdkConfiguration.getAdUnitId(), compositeSdkInitializationListener);
        sPersonalInfoManager.setAllowLegitimateInterest(sdkConfiguration.getLegitimateInterestAllowed());
        ClientMetadata.getInstance(context);
        sAdapterConfigurationManager = new AdapterConfigurationManager(compositeSdkInitializationListener);
        sAdapterConfigurationManager.initialize(context, sdkConfiguration.getAdapterConfigurationClasses(), sdkConfiguration.getMediatedNetworkConfigurations(), sdkConfiguration.getMoPubRequestOptions());
    }

    public static boolean isSdkInitialized() {
        return sSdkInitialized;
    }

    public static boolean canCollectPersonalInformation() {
        return sPersonalInfoManager != null && sPersonalInfoManager.canCollectPersonalInformation();
    }

    public static void setAllowLegitimateInterest(boolean allowed) {
        if (sPersonalInfoManager != null) {
            sPersonalInfoManager.setAllowLegitimateInterest(allowed);
        }
    }

    public static boolean shouldAllowLegitimateInterest() {
        return sPersonalInfoManager != null && sPersonalInfoManager.shouldAllowLegitimateInterest();
    }

    @Nullable
    static String getAdvancedBiddingTokensJson(@NonNull Context context) {
        Preconditions.checkNotNull(context);
        if (sAdapterConfigurationManager == null) {
            return null;
        }
        return sAdapterConfigurationManager.getTokensAsJsonString(context);
    }

    @Nullable
    public static PersonalInfoManager getPersonalInformationManager() {
        return sPersonalInfoManager;
    }

    @VisibleForTesting
    static boolean isBrowserAgentOverriddenByClient() {
        return sIsBrowserAgentOverriddenByClient;
    }

    @Deprecated
    @VisibleForTesting
    public static void resetBrowserAgent() {
        sBrowserAgent = BrowserAgent.IN_APP;
        sIsBrowserAgentOverriddenByClient = false;
    }

    public static void onCreate(@NonNull Activity activity) {
        MoPubLifecycleManager.getInstance(activity).onCreate(activity);
        MoPub.updateActivity(activity);
    }

    public static void onStart(@NonNull Activity activity) {
        MoPubLifecycleManager.getInstance(activity).onStart(activity);
        MoPub.updateActivity(activity);
    }

    public static void onPause(@NonNull Activity activity) {
        MoPubLifecycleManager.getInstance(activity).onPause(activity);
    }

    public static void onResume(@NonNull Activity activity) {
        MoPubLifecycleManager.getInstance(activity).onResume(activity);
        MoPub.updateActivity(activity);
    }

    public static void onRestart(@NonNull Activity activity) {
        MoPubLifecycleManager.getInstance(activity).onRestart(activity);
        MoPub.updateActivity(activity);
    }

    public static void onStop(@NonNull Activity activity) {
        MoPubLifecycleManager.getInstance(activity).onStop(activity);
    }

    public static void onDestroy(@NonNull Activity activity) {
        MoPubLifecycleManager.getInstance(activity).onDestroy(activity);
    }

    public static void onBackPressed(@NonNull Activity activity) {
        MoPubLifecycleManager.getInstance(activity).onBackPressed(activity);
    }

    @UiThread
    public static void disableViewability() {
        ViewabilityManager.disableViewability();
    }

    @Deprecated
    public static void disableViewability(@NonNull ExternalViewabilitySessionManager.ViewabilityVendor vendor) {
        ViewabilityManager.disableViewability();
    }

    @Nullable
    public static List<String> getAdapterConfigurationInfo() {
        AdapterConfigurationManager configurationManager = sAdapterConfigurationManager;
        if (configurationManager != null) {
            return configurationManager.getAdapterConfigurationInfo();
        }
        return null;
    }

    private static void initializeRewardedVideo(@NonNull Activity activity, @NonNull SdkConfiguration sdkConfiguration) {
        Preconditions.checkNotNull(activity);
        Preconditions.checkNotNull(sdkConfiguration);
        try {
            new Reflection.MethodBuilder(null, "initializeRewardedVideo").setStatic(Class.forName(MOPUB_REWARDED_VIDEOS)).setAccessible().addParam(Activity.class, activity).addParam(SdkConfiguration.class, sdkConfiguration).execute();
        }
        catch (ClassNotFoundException e) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "initializeRewardedVideo was called without the rewarded video module");
        }
        catch (NoSuchMethodException e) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "initializeRewardedVideo was called without the rewarded video module");
        }
        catch (Exception e) {
            MoPubLog.log(MoPubLog.SdkLogEvent.ERROR_WITH_THROWABLE, "Error while initializing rewarded video", e);
        }
    }

    private static void initializationFinished(final @Nullable SdkInitializationListener sdkInitializationListener) {
        sSdkInitializing = false;
        sSdkInitialized = true;
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                if (sdkInitializationListener != null) {
                    sdkInitializationListener.onInitializationFinished();
                }
            }
        });
    }

    @VisibleForTesting
    static void updateActivity(@NonNull Activity activity) {
        if (!sSearchedForUpdateActivityMethod) {
            sSearchedForUpdateActivityMethod = true;
            try {
                Class<?> moPubRewardedVideoManagerClass = Class.forName(MOPUB_REWARDED_VIDEO_MANAGER);
                sUpdateActivityMethod = Reflection.getDeclaredMethodWithTraversal(moPubRewardedVideoManagerClass, "updateActivity", Activity.class);
            }
            catch (ClassNotFoundException moPubRewardedVideoManagerClass) {
            }
            catch (NoSuchMethodException moPubRewardedVideoManagerClass) {
                // empty catch block
            }
        }
        if (sUpdateActivityMethod != null) {
            try {
                sUpdateActivityMethod.invoke(null, activity);
            }
            catch (IllegalAccessException e) {
                MoPubLog.log(MoPubLog.SdkLogEvent.ERROR_WITH_THROWABLE, "Error while attempting to access the update activity method - this should not have happened", e);
            }
            catch (InvocationTargetException e) {
                MoPubLog.log(MoPubLog.SdkLogEvent.ERROR_WITH_THROWABLE, "Error while attempting to access the update activity method - this should not have happened", e);
            }
        }
    }

    @Deprecated
    @VisibleForTesting
    static void resetMoPub() {
        sAdapterConfigurationManager = null;
        sPersonalInfoManager = null;
        sSdkInitialized = false;
        sSdkInitializing = false;
    }

    @Deprecated
    @VisibleForTesting
    static void setPersonalInfoManager(@Nullable PersonalInfoManager personalInfoManager) {
        sPersonalInfoManager = personalInfoManager;
    }

    static {
        sSdkInitialized = false;
        sSdkInitializing = false;
    }

    private static class InternalSdkInitializationListener
    implements SdkInitializationListener {
        @Nullable
        private SdkInitializationListener mSdkInitializationListener;

        InternalSdkInitializationListener(@Nullable SdkInitializationListener sdkInitializationListener) {
            this.mSdkInitializationListener = sdkInitializationListener;
        }

        @Override
        public void onInitializationFinished() {
            AdapterConfigurationManager adapterConfigurationManager = sAdapterConfigurationManager;
            if (adapterConfigurationManager != null) {
                MoPubLog.log(MoPubLog.SdkLogEvent.INIT_FINISHED, adapterConfigurationManager.getAdapterConfigurationInfo());
            }
            MoPub.initializationFinished(this.mSdkInitializationListener);
            this.mSdkInitializationListener = null;
        }
    }

    public static enum BrowserAgent {
        IN_APP,
        NATIVE;


        @NonNull
        public static BrowserAgent fromHeader(@Nullable Integer browserAgent) {
            if (browserAgent == null) {
                return IN_APP;
            }
            return browserAgent == 1 ? NATIVE : IN_APP;
        }
    }

    public static enum LocationAwareness {
        NORMAL,
        TRUNCATED,
        DISABLED;

    }
}

