/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import androidx.annotation.NonNull;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import org.json.JSONException;
import org.json.JSONObject;

public class MoPubAdvancedBidderData {
    private static final String TOKEN_KEY = "token";
    @NonNull
    final String mToken;
    @NonNull
    final String mCreativeNetworkName;

    public MoPubAdvancedBidderData(@NonNull String token, @NonNull String creativeNetworkName) {
        Preconditions.checkNotNull(token);
        Preconditions.checkNotNull(creativeNetworkName);
        this.mToken = token;
        this.mCreativeNetworkName = creativeNetworkName;
    }

    @NonNull
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(TOKEN_KEY, (Object)this.mToken);
        }
        catch (JSONException e) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Invalid token format: " + this.mToken);
        }
        return jsonObject;
    }
}

