/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import androidx.annotation.NonNull;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.network.Networking;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;

public abstract class MoPubHttpUrlConnection
extends HttpURLConnection {
    private static final int CONNECT_TIMEOUT = 10000;
    private static final int READ_TIMEOUT = 10000;

    private MoPubHttpUrlConnection(URL url) {
        super(url);
    }

    public static HttpURLConnection getHttpUrlConnection(@NonNull String url) throws IOException {
        String getUrl;
        Preconditions.checkNotNull(url);
        if (MoPubHttpUrlConnection.isUrlImproperlyEncoded(url)) {
            throw new IllegalArgumentException("URL is improperly encoded: " + url);
        }
        try {
            getUrl = MoPubHttpUrlConnection.urlEncode(url);
        }
        catch (Exception e) {
            getUrl = url;
        }
        HttpURLConnection urlConnection = (HttpURLConnection)new URL(getUrl).openConnection();
        urlConnection.setRequestProperty("user-agent", Networking.getCachedUserAgent());
        urlConnection.setConnectTimeout(10000);
        urlConnection.setReadTimeout(10000);
        return urlConnection;
    }

    @NonNull
    public static String urlEncode(@NonNull String url) throws Exception {
        Preconditions.checkNotNull(url);
        if (MoPubHttpUrlConnection.isUrlImproperlyEncoded(url)) {
            throw new UnsupportedEncodingException("URL is improperly encoded: " + url);
        }
        URI uri = MoPubHttpUrlConnection.isUrlUnencoded(url) ? MoPubHttpUrlConnection.encodeUrl(url) : new URI(url);
        return uri.toURL().toString();
    }

    static boolean isUrlImproperlyEncoded(@NonNull String url) {
        try {
            URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Url is improperly encoded: " + url);
            return true;
        }
        return false;
    }

    static boolean isUrlUnencoded(@NonNull String url) {
        try {
            new URI(url);
        }
        catch (URISyntaxException e) {
            return true;
        }
        return false;
    }

    @NonNull
    static URI encodeUrl(@NonNull String urlString) throws Exception {
        URI uri;
        try {
            URL url = new URL(urlString);
            uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
        }
        catch (Exception e) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Failed to encode url: " + urlString);
            throw e;
        }
        return uri;
    }
}

