/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.mopub.common.DefaultAdapterClasses;
import com.mopub.common.MediationSettings;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SdkConfiguration {
    @NonNull
    private final String mAdUnitId;
    @NonNull
    private final Set<String> mAdapterConfigurationClasses;
    @NonNull
    private final MediationSettings[] mMediationSettings;
    @NonNull
    private final Map<String, Map<String, String>> mMediatedNetworkConfigurations;
    @NonNull
    private final Map<String, Map<String, String>> mMoPubRequestOptions;
    @NonNull
    private final MoPubLog.LogLevel mLogLevel;
    private final boolean mLegitimateInterestAllowed;

    private SdkConfiguration(@NonNull String adUnitId, @NonNull Set<String> adapterConfigurationClasses, @NonNull MediationSettings[] mediationSettings, @NonNull MoPubLog.LogLevel logLevel, @NonNull Map<String, Map<String, String>> mediatedNetworkConfigurations, @NonNull Map<String, Map<String, String>> moPubRequestOptions, boolean legitimateInterestAllowed) {
        Preconditions.checkNotNull(adUnitId);
        Preconditions.checkNotNull(adapterConfigurationClasses);
        Preconditions.checkNotNull(mediatedNetworkConfigurations);
        Preconditions.checkNotNull(moPubRequestOptions);
        this.mAdUnitId = adUnitId;
        this.mAdapterConfigurationClasses = adapterConfigurationClasses;
        this.mMediationSettings = mediationSettings;
        this.mLogLevel = logLevel;
        this.mMediatedNetworkConfigurations = mediatedNetworkConfigurations;
        this.mMoPubRequestOptions = moPubRequestOptions;
        this.mLegitimateInterestAllowed = legitimateInterestAllowed;
    }

    @NonNull
    public String getAdUnitId() {
        return this.mAdUnitId;
    }

    @NonNull
    public Set<String> getAdapterConfigurationClasses() {
        return Collections.unmodifiableSet(this.mAdapterConfigurationClasses);
    }

    @NonNull
    public MediationSettings[] getMediationSettings() {
        return Arrays.copyOf(this.mMediationSettings, this.mMediationSettings.length);
    }

    @NonNull
    MoPubLog.LogLevel getLogLevel() {
        return this.mLogLevel;
    }

    public Map<String, Map<String, String>> getMediatedNetworkConfigurations() {
        return Collections.unmodifiableMap(this.mMediatedNetworkConfigurations);
    }

    @NonNull
    public Map<String, Map<String, String>> getMoPubRequestOptions() {
        return Collections.unmodifiableMap(this.mMoPubRequestOptions);
    }

    public boolean getLegitimateInterestAllowed() {
        return this.mLegitimateInterestAllowed;
    }

    public static class Builder {
        @NonNull
        private String adUnitId;
        @NonNull
        private final Set<String> adapterConfigurations;
        @NonNull
        private MediationSettings[] mediationSettings;
        @NonNull
        private MoPubLog.LogLevel logLevel = MoPubLog.LogLevel.NONE;
        @NonNull
        private final Map<String, Map<String, String>> mediatedNetworkConfigurations;
        @NonNull
        private final Map<String, Map<String, String>> moPubRequestOptions;
        private boolean legitimateInterestAllowed;

        public Builder(@NonNull String adUnitId) {
            if (TextUtils.isEmpty((CharSequence)adUnitId)) {
                IllegalArgumentException iae = new IllegalArgumentException("Ad unit cannot be empty at initialization");
                MoPubLog.setLogLevel(MoPubLog.getLogLevel());
                MoPubLog.log(MoPubLog.SdkLogEvent.INIT_FAILED, "Pass in an ad unit used by this app", iae);
            }
            this.adUnitId = adUnitId;
            this.adapterConfigurations = DefaultAdapterClasses.getClassNamesSet();
            this.mediationSettings = new MediationSettings[0];
            this.mediatedNetworkConfigurations = new HashMap<String, Map<String, String>>();
            this.moPubRequestOptions = new HashMap<String, Map<String, String>>();
            this.legitimateInterestAllowed = false;
        }

        public Builder withAdditionalNetwork(@NonNull String adapterConfigurationClass) {
            Preconditions.checkNotNull(adapterConfigurationClass);
            this.adapterConfigurations.add(adapterConfigurationClass);
            return this;
        }

        public Builder withMediationSettings(MediationSettings ... mediationSettings) {
            Preconditions.checkNotNull(mediationSettings);
            this.mediationSettings = mediationSettings;
            return this;
        }

        public Builder withLogLevel(@NonNull MoPubLog.LogLevel logLevel) {
            Preconditions.checkNotNull(logLevel);
            this.logLevel = logLevel;
            return this;
        }

        public Builder withMediatedNetworkConfiguration(@NonNull String adapterConfigurationClass, @NonNull Map<String, String> mediatedNetworkConfiguration) {
            Preconditions.checkNotNull(adapterConfigurationClass);
            Preconditions.checkNotNull(mediatedNetworkConfiguration);
            this.mediatedNetworkConfigurations.put(adapterConfigurationClass, mediatedNetworkConfiguration);
            return this;
        }

        public Builder withMoPubRequestOptions(@NonNull String adapterConfigurationClass, @NonNull Map<String, String> mopubRequestOptions) {
            Preconditions.checkNotNull(adapterConfigurationClass);
            Preconditions.checkNotNull(mopubRequestOptions);
            this.moPubRequestOptions.put(adapterConfigurationClass, mopubRequestOptions);
            return this;
        }

        public Builder withLegitimateInterestAllowed(boolean legitimateInterestAllowed) {
            this.legitimateInterestAllowed = legitimateInterestAllowed;
            return this;
        }

        public SdkConfiguration build() {
            return new SdkConfiguration(this.adUnitId, this.adapterConfigurations, this.mediationSettings, this.logLevel, this.mediatedNetworkConfigurations, this.moPubRequestOptions, this.legitimateInterestAllowed);
        }
    }
}

