/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.Preconditions;
import com.mopub.common.UrlAction;
import com.mopub.common.UrlResolutionTask;
import com.mopub.common.logging.MoPubLog;
import com.mopub.exceptions.IntentNotResolvableException;
import com.mopub.network.TrackingRequest;
import java.util.EnumSet;

public class UrlHandler {
    private static final ResultActions EMPTY_CLICK_LISTENER = new ResultActions(){

        @Override
        public void urlHandlingSucceeded(@NonNull String url, @NonNull UrlAction urlAction) {
        }

        @Override
        public void urlHandlingFailed(@NonNull String url, @NonNull UrlAction lastFailedUrlAction) {
        }
    };
    private static final MoPubSchemeListener EMPTY_MOPUB_SCHEME_LISTENER = new MoPubSchemeListener(){

        @Override
        public void onFinishLoad() {
        }

        @Override
        public void onClose() {
        }

        @Override
        public void onFailLoad() {
        }

        @Override
        public void onCrash() {
        }
    };
    @NonNull
    private EnumSet<UrlAction> mSupportedUrlActions;
    @NonNull
    private ResultActions mResultActions;
    @NonNull
    private MoPubSchemeListener mMoPubSchemeListener;
    @Nullable
    private String mDspCreativeId;
    private boolean mSkipShowMoPubBrowser;
    private boolean mAlreadySucceeded;
    private boolean mTaskPending;

    private UrlHandler(@NonNull EnumSet<UrlAction> supportedUrlActions, @NonNull ResultActions resultActions, @NonNull MoPubSchemeListener moPubSchemeListener, boolean skipShowMoPubBrowser, @Nullable String dspCreativeId) {
        this.mSupportedUrlActions = EnumSet.copyOf(supportedUrlActions);
        this.mResultActions = resultActions;
        this.mMoPubSchemeListener = moPubSchemeListener;
        this.mSkipShowMoPubBrowser = skipShowMoPubBrowser;
        this.mDspCreativeId = dspCreativeId;
        this.mAlreadySucceeded = false;
        this.mTaskPending = false;
    }

    @NonNull
    EnumSet<UrlAction> getSupportedUrlActions() {
        return EnumSet.copyOf(this.mSupportedUrlActions);
    }

    @NonNull
    ResultActions getResultActions() {
        return this.mResultActions;
    }

    @NonNull
    MoPubSchemeListener getMoPubSchemeListener() {
        return this.mMoPubSchemeListener;
    }

    boolean shouldSkipShowMoPubBrowser() {
        return this.mSkipShowMoPubBrowser;
    }

    public void handleUrl(@NonNull Context context, @NonNull String destinationUrl) {
        Preconditions.checkNotNull(context);
        this.handleUrl(context, destinationUrl, true);
    }

    public void handleUrl(@NonNull Context context, @NonNull String destinationUrl, boolean fromUserInteraction) {
        Preconditions.checkNotNull(context);
        this.handleUrl(context, destinationUrl, fromUserInteraction, null);
    }

    public void handleUrl(final @NonNull Context context, final @NonNull String destinationUrl, final boolean fromUserInteraction, final @Nullable Iterable<String> trackingUrls) {
        Preconditions.checkNotNull(context);
        if (TextUtils.isEmpty((CharSequence)destinationUrl)) {
            this.failUrlHandling(destinationUrl, null, "Attempted to handle empty url.", null);
            return;
        }
        UrlResolutionTask.UrlResolutionListener urlResolutionListener = new UrlResolutionTask.UrlResolutionListener(){

            @Override
            public void onSuccess(@NonNull String resolvedUrl) {
                UrlHandler.this.mTaskPending = false;
                UrlHandler.this.handleResolvedUrl(context, resolvedUrl, fromUserInteraction, trackingUrls);
            }

            @Override
            public void onFailure(@NonNull String message, @Nullable Throwable throwable) {
                UrlHandler.this.mTaskPending = false;
                UrlHandler.this.failUrlHandling(destinationUrl, null, message, throwable);
            }
        };
        UrlResolutionTask.getResolvedUrl(destinationUrl, urlResolutionListener);
        this.mTaskPending = true;
    }

    public boolean handleResolvedUrl(@NonNull Context context, @NonNull String url, boolean fromUserInteraction, @Nullable Iterable<String> trackingUrls) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            this.failUrlHandling(url, null, "Attempted to handle empty url.", null);
            return false;
        }
        UrlAction lastFailedUrlAction = UrlAction.NOOP;
        Uri destinationUri = Uri.parse((String)url);
        for (UrlAction urlAction : this.mSupportedUrlActions) {
            if (!urlAction.shouldTryHandlingUrl(destinationUri)) continue;
            try {
                urlAction.handleUrl(this, context, destinationUri, fromUserInteraction, this.mDspCreativeId);
                if (!(this.mAlreadySucceeded || this.mTaskPending || UrlAction.IGNORE_ABOUT_SCHEME.equals((Object)urlAction) || UrlAction.HANDLE_MOPUB_SCHEME.equals((Object)urlAction))) {
                    TrackingRequest.makeTrackingHttpRequest(trackingUrls, context);
                    this.mResultActions.urlHandlingSucceeded(destinationUri.toString(), urlAction);
                    this.mAlreadySucceeded = true;
                }
                return true;
            }
            catch (IntentNotResolvableException e) {
                MoPubLog.log(MoPubLog.SdkLogEvent.ERROR_WITH_THROWABLE, e.getMessage(), e);
                lastFailedUrlAction = urlAction;
            }
        }
        this.failUrlHandling(url, lastFailedUrlAction, "Link ignored. Unable to handle url: " + url, null);
        return false;
    }

    private void failUrlHandling(@Nullable String url, @Nullable UrlAction urlAction, @NonNull String message, @Nullable Throwable throwable) {
        Preconditions.checkNotNull(message);
        if (urlAction == null) {
            urlAction = UrlAction.NOOP;
        }
        MoPubLog.log(MoPubLog.SdkLogEvent.ERROR_WITH_THROWABLE, message, throwable);
        this.mResultActions.urlHandlingFailed(url, urlAction);
    }

    static /* synthetic */ ResultActions access$000() {
        return EMPTY_CLICK_LISTENER;
    }

    static /* synthetic */ MoPubSchemeListener access$100() {
        return EMPTY_MOPUB_SCHEME_LISTENER;
    }

    public static class Builder {
        @NonNull
        private EnumSet<UrlAction> supportedUrlActions = EnumSet.of(UrlAction.NOOP);
        @NonNull
        private ResultActions resultActions = UrlHandler.access$000();
        @NonNull
        private MoPubSchemeListener moPubSchemeListener = UrlHandler.access$100();
        private boolean skipShowMoPubBrowser = false;
        @Nullable
        private String creativeId;

        public Builder withSupportedUrlActions(@NonNull UrlAction first, UrlAction ... others) {
            this.supportedUrlActions = EnumSet.of(first, others);
            return this;
        }

        public Builder withSupportedUrlActions(@NonNull EnumSet<UrlAction> supportedUrlActions) {
            this.supportedUrlActions = EnumSet.copyOf(supportedUrlActions);
            return this;
        }

        public Builder withResultActions(@NonNull ResultActions resultActions) {
            this.resultActions = resultActions;
            return this;
        }

        public Builder withMoPubSchemeListener(@NonNull MoPubSchemeListener moPubSchemeListener) {
            this.moPubSchemeListener = moPubSchemeListener;
            return this;
        }

        public Builder withoutMoPubBrowser() {
            this.skipShowMoPubBrowser = true;
            return this;
        }

        public Builder withDspCreativeId(@Nullable String creativeId) {
            this.creativeId = creativeId;
            return this;
        }

        public UrlHandler build() {
            return new UrlHandler(this.supportedUrlActions, this.resultActions, this.moPubSchemeListener, this.skipShowMoPubBrowser, this.creativeId);
        }
    }

    public static interface MoPubSchemeListener {
        public void onFinishLoad();

        public void onClose();

        public void onFailLoad();

        public void onCrash();
    }

    public static interface ResultActions {
        public void urlHandlingSucceeded(@NonNull String var1, @NonNull UrlAction var2);

        public void urlHandlingFailed(@NonNull String var1, @NonNull UrlAction var2);
    }
}

