/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import com.iab.omid.library.mopub.Omid;
import com.iab.omid.library.mopub.ScriptInjector;
import com.iab.omid.library.mopub.adsession.Partner;
import com.mopub.common.Preconditions;
import com.mopub.common.ViewabilityScriptLoader;
import com.mopub.common.ViewabilityVendor;
import com.mopub.common.logging.MoPubLog;
import java.util.Set;

public class ViewabilityManager {
    private static final String PARTNER_NAME = "mopub";
    @NonNull
    private static final ViewabilityScriptLoader sScriptLoader = new ViewabilityScriptLoader();
    private static boolean sViewabilityEnabled = true;
    @Nullable
    private Partner mPartner;

    private ViewabilityManager() {
    }

    @NonNull
    private static ViewabilityManager getInstance() {
        return Helper.sInstance;
    }

    @UiThread
    public static void activate(@NonNull Context applicationContext) {
        Preconditions.checkUiThread("activate() must be called on the UI thread.");
        Preconditions.checkNotNull(applicationContext);
        ViewabilityManager.getInstance().init(applicationContext);
    }

    @UiThread
    static boolean isActive() {
        Preconditions.checkUiThread("isActive() must be called on the UI thread.");
        return ViewabilityManager.getInstance().isActiveImpl();
    }

    @UiThread
    @NonNull
    static String getOmidVersion() {
        Preconditions.checkUiThread("getOmidVersion() must be called on the UI thread.");
        return Omid.getVersion();
    }

    static void disableViewability() {
        sViewabilityEnabled = false;
        MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Viewability has been disabled");
    }

    public static boolean isViewabilityEnabled() {
        return sViewabilityEnabled;
    }

    @NonNull
    static String getOmidJsServiceContent() {
        return sScriptLoader.getOmidJsServiceContent();
    }

    @Nullable
    static Partner getPartner() {
        return ViewabilityManager.getInstance().mPartner;
    }

    @UiThread
    @NonNull
    public static String injectScriptContentIntoHtml(@NonNull String adResponseHtml) {
        Preconditions.checkUiThread();
        Preconditions.checkNotNull(adResponseHtml);
        if (!ViewabilityManager.isViewabilityEnabled()) {
            return adResponseHtml;
        }
        try {
            return ScriptInjector.injectScriptContentIntoHtml((String)ViewabilityManager.getOmidJsServiceContent(), (String)adResponseHtml);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM_WITH_THROWABLE, "Failed to inject OM script into HTML. ", e);
            return adResponseHtml;
        }
    }

    @NonNull
    static String injectScriptUrlIntoHtml(@NonNull String adResponseHtml, @NonNull String scriptUrl) {
        Preconditions.checkNotNull(adResponseHtml);
        Preconditions.checkNotNull(scriptUrl);
        if (!ViewabilityManager.isViewabilityEnabled()) {
            return adResponseHtml;
        }
        String hack_value = "cfc10ccaf0724c4cbc6122cf51421f03";
        String placeholder_tag = "<script type=\"text/javascript\">cfc10ccaf0724c4cbc6122cf51421f03</script>";
        String valid_tag = "<script src=\"" + scriptUrl + "\"></script>";
        try {
            String intermediate = ScriptInjector.injectScriptContentIntoHtml((String)"cfc10ccaf0724c4cbc6122cf51421f03", (String)adResponseHtml);
            String modifiedHtml = intermediate.replace("<script type=\"text/javascript\">cfc10ccaf0724c4cbc6122cf51421f03</script>", valid_tag);
            if (!modifiedHtml.equals(intermediate)) {
                return modifiedHtml;
            }
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM_WITH_THROWABLE, "Failed to inject script URL into HTML. ", e);
        }
        return adResponseHtml;
    }

    @NonNull
    public static String injectVerificationUrlsIntoHtml(@NonNull String adResponseHtml, @Nullable Set<ViewabilityVendor> vendors) {
        Preconditions.checkNotNull(adResponseHtml);
        if (vendors == null || TextUtils.isEmpty((CharSequence)adResponseHtml)) {
            return adResponseHtml;
        }
        String responseHtml = adResponseHtml;
        for (ViewabilityVendor vendor : vendors) {
            if (vendor == null) continue;
            responseHtml = ViewabilityManager.injectScriptUrlIntoHtml(responseHtml, vendor.getJavascriptResourceUrl().toString());
        }
        return responseHtml;
    }

    @UiThread
    private void init(@NonNull Context applicationContext) {
        if (this.mPartner != null) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "ViewabilityManager already initialized.");
            return;
        }
        try {
            Omid.activate((Context)applicationContext.getApplicationContext());
            this.mPartner = Partner.createPartner((String)PARTNER_NAME, (String)"5.14.0");
        }
        catch (IllegalArgumentException e) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM_WITH_THROWABLE, "createPartner() ", e);
        }
    }

    @UiThread
    private boolean isActiveImpl() {
        try {
            return sViewabilityEnabled && Omid.isActive() && this.mPartner != null;
        }
        catch (Exception ex) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM_WITH_THROWABLE, "isActive() ", ex);
            return false;
        }
    }

    @VisibleForTesting
    public static void setViewabilityEnabled(boolean enabled) {
        sViewabilityEnabled = enabled;
    }

    private static class Helper {
        @NonNull
        private static ViewabilityManager sInstance = new ViewabilityManager();

        private Helper() {
        }
    }
}

