/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.text.TextUtils;
import android.util.Pair;
import android.view.View;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import com.iab.omid.library.mopub.adsession.AdEvents;
import com.iab.omid.library.mopub.adsession.AdSession;
import com.iab.omid.library.mopub.adsession.AdSessionConfiguration;
import com.iab.omid.library.mopub.adsession.AdSessionContext;
import com.iab.omid.library.mopub.adsession.CreativeType;
import com.iab.omid.library.mopub.adsession.ImpressionType;
import com.iab.omid.library.mopub.adsession.Owner;
import com.iab.omid.library.mopub.adsession.Partner;
import com.iab.omid.library.mopub.adsession.VerificationScriptResource;
import com.iab.omid.library.mopub.adsession.media.Position;
import com.iab.omid.library.mopub.adsession.media.VastProperties;
import com.mopub.common.Preconditions;
import com.mopub.common.VideoEvent;
import com.mopub.common.ViewabilityManager;
import com.mopub.common.ViewabilityObstruction;
import com.mopub.common.ViewabilityVendor;
import com.mopub.common.logging.MoPubLog;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

class ViewabilityTracker {
    private static final String CUSTOM_REFERENCE_DATA = "";
    private static final String CONTENT_URL = "";
    @NonNull
    private AdSession adSession;
    @NonNull
    private AdEvents adEvents;
    private boolean impressionOccurred = false;
    protected boolean tracking = false;
    protected STATE state;
    private static AtomicInteger sessionCounter = new AtomicInteger(0);
    int sessionID;

    @NonNull
    static ViewabilityTracker createWebViewTracker(@NonNull WebView webView) throws IllegalArgumentException {
        Partner partner = ViewabilityManager.getPartner();
        if (partner == null) {
            throw new IllegalArgumentException("Parameter 'partner' may not be null.");
        }
        AdSessionContext adSessionContext = AdSessionContext.createHtmlAdSessionContext((Partner)partner, (WebView)webView, (String)"", (String)"");
        AdSessionConfiguration adSessionConfiguration = AdSessionConfiguration.createAdSessionConfiguration((CreativeType)CreativeType.HTML_DISPLAY, (ImpressionType)ImpressionType.BEGIN_TO_RENDER, (Owner)Owner.NATIVE, (Owner)Owner.NONE, (boolean)false);
        AdSession adSession = AdSession.createAdSession((AdSessionConfiguration)adSessionConfiguration, (AdSessionContext)adSessionContext);
        AdEvents adEvents = AdEvents.createAdEvents((AdSession)adSession);
        return new ViewabilityTracker(adSession, adEvents, (View)webView);
    }

    @NonNull
    static ViewabilityTracker createNativeTracker(@NonNull View adView, @NonNull Set<ViewabilityVendor> viewabilityVendors) throws IllegalArgumentException {
        if (viewabilityVendors.size() == 0) {
            throw new IllegalArgumentException("Empty viewability vendors list.");
        }
        AdSession adSession = ViewabilityTracker.createAdSession(CreativeType.NATIVE_DISPLAY, viewabilityVendors, Owner.NONE);
        AdEvents adEvents = AdEvents.createAdEvents((AdSession)adSession);
        return new ViewabilityTracker(adSession, adEvents, adView);
    }

    static AdSession createAdSession(@NonNull CreativeType creativeType, @NonNull Set<ViewabilityVendor> viewabilityVendors, @NonNull Owner mediaEventsOwner) {
        Preconditions.checkNotNull(creativeType);
        Preconditions.checkNotNull(viewabilityVendors);
        Preconditions.checkNotNull(mediaEventsOwner);
        List<VerificationScriptResource> verificationScriptResources = ViewabilityTracker.createVerificationResources(viewabilityVendors);
        if (verificationScriptResources.isEmpty()) {
            throw new IllegalArgumentException("verificationScriptResources is empty");
        }
        Partner partner = ViewabilityManager.getPartner();
        if (partner == null) {
            throw new IllegalArgumentException("Parameter 'partner' may not be null.");
        }
        AdSessionContext adSessionContext = AdSessionContext.createNativeAdSessionContext((Partner)partner, (String)ViewabilityManager.getOmidJsServiceContent(), verificationScriptResources, (String)"", (String)"");
        AdSessionConfiguration adSessionConfiguration = AdSessionConfiguration.createAdSessionConfiguration((CreativeType)creativeType, (ImpressionType)ImpressionType.BEGIN_TO_RENDER, (Owner)Owner.NATIVE, (Owner)mediaEventsOwner, (boolean)false);
        return AdSession.createAdSession((AdSessionConfiguration)adSessionConfiguration, (AdSessionContext)adSessionContext);
    }

    ViewabilityTracker(@NonNull AdSession adSession, @NonNull AdEvents adEvents, @NonNull View adView) {
        Preconditions.checkNotNull(adSession);
        Preconditions.checkNotNull(adEvents);
        Preconditions.checkNotNull(adView);
        this.state = STATE.INIT;
        this.adSession = adSession;
        this.adEvents = adEvents;
        this.sessionID = sessionCounter.incrementAndGet();
        this.registerTrackedView(adView);
    }

    boolean isTracking() {
        return this.tracking;
    }

    void changeState(@NonNull STATE newState) {
        boolean modified = false;
        if (ViewabilityManager.isActive()) {
            switch (newState) {
                case STARTED: {
                    if (this.state != STATE.INIT) break;
                    this.adSession.start();
                    this.adEvents.loaded();
                    this.tracking = true;
                    modified = true;
                    break;
                }
                case STARTED_VIDEO: {
                    if (this.state != STATE.INIT) break;
                    this.adSession.start();
                    VastProperties vProps = VastProperties.createVastPropertiesForNonSkippableMedia((boolean)true, (Position)Position.STANDALONE);
                    this.adEvents.loaded(vProps);
                    this.tracking = true;
                    modified = true;
                    break;
                }
                case IMPRESSED: {
                    if (this.impressionOccurred || this.state != STATE.STARTED && this.state != STATE.STARTED_VIDEO) break;
                    this.adEvents.impressionOccurred();
                    this.impressionOccurred = true;
                    modified = true;
                    break;
                }
                case STOPPED: {
                    if (this.state == STATE.INIT || this.state == STATE.STOPPED) break;
                    this.adSession.finish();
                    this.tracking = false;
                    modified = true;
                }
            }
        }
        if (modified) {
            this.state = newState;
            this.log("new state: " + this.state.name() + " " + this.sessionID);
        } else {
            this.log("skip transition from: " + (Object)((Object)this.state) + " to " + (Object)((Object)newState));
        }
    }

    void startTracking() {
        this.log("startTracking(): " + this.sessionID);
        this.changeState(STATE.STARTED);
    }

    void stopTracking() {
        this.log("stopTracking(): " + this.sessionID);
        this.changeState(STATE.STOPPED);
    }

    public void trackImpression() {
        this.log("trackImpression(): " + this.sessionID);
        this.changeState(STATE.IMPRESSED);
    }

    boolean hasImpressionOccurred() {
        return this.impressionOccurred;
    }

    void registerTrackedView(@NonNull View adView) {
        this.adSession.registerAdView(adView);
    }

    void registerFriendlyObstructions(@NonNull Iterable<Pair<View, ViewabilityObstruction>> obstructions) {
        for (Pair<View, ViewabilityObstruction> pair : obstructions) {
            try {
                this.registerFriendlyObstruction((View)pair.first, (ViewabilityObstruction)((Object)pair.second));
            }
            catch (IllegalArgumentException ex) {
                MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "registerFriendlyObstructions() " + ex.getLocalizedMessage());
            }
        }
    }

    void registerFriendlyObstruction(@NonNull View view, @NonNull ViewabilityObstruction purpose) {
        this.log("registerFriendlyObstruction(): " + this.sessionID);
        this.adSession.addFriendlyObstruction(view, purpose.value, " ");
    }

    void removeFriendlyObstruction(@NonNull View view) {
        Preconditions.checkNotNull(view);
        this.log("removeFriendlyObstruction(): " + this.sessionID);
        this.adSession.removeFriendlyObstruction(view);
    }

    @NonNull
    private static List<VerificationScriptResource> createVerificationResources(@NonNull Set<ViewabilityVendor> viewabilityVendors) {
        ArrayList<VerificationScriptResource> list = new ArrayList<VerificationScriptResource>();
        for (ViewabilityVendor vendor : viewabilityVendors) {
            try {
                if (TextUtils.isEmpty((CharSequence)vendor.getVendorKey()) || TextUtils.isEmpty((CharSequence)vendor.getVerificationParameters())) {
                    list.add(VerificationScriptResource.createVerificationScriptResourceWithoutParameters((URL)vendor.getJavascriptResourceUrl()));
                    continue;
                }
                list.add(VerificationScriptResource.createVerificationScriptResourceWithParameters((String)vendor.getVendorKey(), (URL)vendor.getJavascriptResourceUrl(), (String)vendor.getVerificationParameters()));
            }
            catch (Exception exception) {}
        }
        return list;
    }

    void videoPrepared(float duration) {
    }

    void trackVideo(@NonNull VideoEvent videoEvent) {
    }

    void log(@NonNull String message) {
        if (ViewabilityManager.isViewabilityEnabled()) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "OMSDK " + message);
        }
    }

    protected static enum STATE {
        INIT,
        STARTED,
        STARTED_VIDEO,
        IMPRESSED,
        STOPPED;

    }
}

