/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.view.View;
import androidx.annotation.NonNull;
import com.iab.omid.library.mopub.adsession.AdEvents;
import com.iab.omid.library.mopub.adsession.AdSession;
import com.iab.omid.library.mopub.adsession.CreativeType;
import com.iab.omid.library.mopub.adsession.Owner;
import com.iab.omid.library.mopub.adsession.media.InteractionType;
import com.iab.omid.library.mopub.adsession.media.MediaEvents;
import com.iab.omid.library.mopub.adsession.media.PlayerState;
import com.mopub.common.VideoEvent;
import com.mopub.common.ViewabilityTracker;
import com.mopub.common.ViewabilityVendor;
import com.mopub.common.VisibleForTesting;
import java.util.Set;

class ViewabilityTrackerVideo
extends ViewabilityTracker {
    @NonNull
    private MediaEvents mediaEvents;

    @NonNull
    static ViewabilityTracker createVastVideoTracker(@NonNull View videoView, @NonNull Set<ViewabilityVendor> viewabilityVendors) throws IllegalArgumentException {
        AdSession adSession = ViewabilityTrackerVideo.createAdSession(CreativeType.VIDEO, viewabilityVendors, Owner.NATIVE);
        AdEvents adEvents = AdEvents.createAdEvents((AdSession)adSession);
        return new ViewabilityTrackerVideo(adSession, adEvents, videoView);
    }

    private ViewabilityTrackerVideo(@NonNull AdSession adSession, @NonNull AdEvents adEvents, @NonNull View videoView) throws IllegalArgumentException, IllegalStateException {
        this(adSession, adEvents, videoView, MediaEvents.createMediaEvents((AdSession)adSession));
    }

    @VisibleForTesting
    ViewabilityTrackerVideo(@NonNull AdSession adSession, @NonNull AdEvents adEvents, @NonNull View videoView, @NonNull MediaEvents mediaEvents) throws IllegalArgumentException, IllegalStateException {
        super(adSession, adEvents, videoView);
        this.mediaEvents = mediaEvents;
        this.log("ViewabilityTrackerVideo() sesseionId:" + this.sessionID);
    }

    @Override
    public void startTracking() {
        this.log("ViewabilityTrackerVideo.startTracking() sesseionId: " + this.sessionID);
        this.changeState(ViewabilityTracker.STATE.STARTED_VIDEO);
    }

    @Override
    public void videoPrepared(float durationSeconds) {
        this.log("videoPrepared() duration= " + durationSeconds);
        if (!this.isTracking()) {
            this.log("videoPrepared() not tracking yet: " + this.sessionID);
            return;
        }
        this.mediaEvents.start(durationSeconds, 1.0f);
    }

    @Override
    public void trackVideo(@NonNull VideoEvent videoEvent) {
        if (!this.isTracking()) {
            this.log("trackVideo() skip event: " + videoEvent.name());
            return;
        }
        this.log("trackVideo() event: " + videoEvent.name() + " " + this.sessionID);
        switch (videoEvent) {
            case AD_IMPRESSED: {
                this.trackImpression();
                break;
            }
            case AD_PAUSED: {
                this.mediaEvents.pause();
                break;
            }
            case AD_RESUMED: {
                this.mediaEvents.resume();
                break;
            }
            case AD_SKIPPED: {
                this.mediaEvents.skipped();
                break;
            }
            case AD_CLICK_THRU: {
                this.mediaEvents.adUserInteraction(InteractionType.CLICK);
                break;
            }
            case RECORD_AD_ERROR: {
                this.mediaEvents.skipped();
                break;
            }
            case AD_BUFFER_START: {
                this.mediaEvents.bufferStart();
                break;
            }
            case AD_BUFFER_END: {
                this.mediaEvents.bufferFinish();
                break;
            }
            case AD_VIDEO_FIRST_QUARTILE: {
                this.mediaEvents.firstQuartile();
                break;
            }
            case AD_VIDEO_MIDPOINT: {
                this.mediaEvents.midpoint();
                break;
            }
            case AD_VIDEO_THIRD_QUARTILE: {
                this.mediaEvents.thirdQuartile();
                break;
            }
            case AD_COMPLETE: {
                this.mediaEvents.complete();
                break;
            }
            case AD_FULLSCREEN: {
                this.mediaEvents.playerStateChange(PlayerState.FULLSCREEN);
                break;
            }
            case AD_NORMAL: {
                this.mediaEvents.playerStateChange(PlayerState.NORMAL);
                break;
            }
            case AD_VOLUME_CHANGE: {
                this.mediaEvents.volumeChange(1.0f);
            }
        }
    }
}

