/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.logging.MoPubLog;
import java.io.Serializable;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class ViewabilityVendor
implements Serializable {
    private static final long serialVersionUID = 2566572076713868153L;
    private static final String OMID = "omid";
    private static final String JAVASCRIPT_RESOURCE_URL = "javascriptResourceUrl";
    private static final String VENDOR_KEY = "vendorKey";
    private static final String VERIFICATION_PARAMETERS = "verificationParameters";
    private static final String API_FRAMEWORK = "apiFramework";
    @Nullable
    private final String vendorKey;
    @NonNull
    private final URL javascriptResourceUrl;
    @Nullable
    private final String verificationParameters;
    @Nullable
    private String verificationNotExecuted;

    private ViewabilityVendor(@NonNull Builder builder) throws Exception {
        if (!OMID.equalsIgnoreCase(builder.apiFramework) || TextUtils.isEmpty((CharSequence)builder.javascriptResourceUrl)) {
            throw new InvalidParameterException("ViewabilityVendor cannot be created.");
        }
        this.vendorKey = builder.vendorKey;
        this.javascriptResourceUrl = new URL(builder.javascriptResourceUrl);
        this.verificationParameters = builder.verificationParameters;
        this.verificationNotExecuted = builder.verificationNotExecuted;
    }

    @Nullable
    public String getVendorKey() {
        return this.vendorKey;
    }

    @NonNull
    public URL getJavascriptResourceUrl() {
        return this.javascriptResourceUrl;
    }

    @Nullable
    public String getVerificationParameters() {
        return this.verificationParameters;
    }

    @Nullable
    public String getVerificationNotExecuted() {
        return this.verificationNotExecuted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ViewabilityVendor)) {
            return false;
        }
        ViewabilityVendor that = (ViewabilityVendor)o;
        if (!Objects.equals(this.vendorKey, that.vendorKey)) {
            return false;
        }
        if (!Objects.equals(this.javascriptResourceUrl, that.javascriptResourceUrl)) {
            return false;
        }
        if (!Objects.equals(this.verificationParameters, that.verificationParameters)) {
            return false;
        }
        return Objects.equals(this.verificationNotExecuted, that.verificationNotExecuted);
    }

    public int hashCode() {
        int result = this.vendorKey != null ? this.vendorKey.hashCode() : 0;
        result = 31 * result + this.javascriptResourceUrl.hashCode();
        result = 31 * result + (this.verificationParameters != null ? this.verificationParameters.hashCode() : 0);
        result = 31 * result + (this.verificationNotExecuted != null ? this.verificationNotExecuted.hashCode() : 0);
        return result;
    }

    @NonNull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.vendorKey).append("\n").append(this.javascriptResourceUrl).append("\n").append(this.verificationParameters).append("\n");
        return builder.toString();
    }

    @Nullable
    static ViewabilityVendor createFromJson(@NonNull JSONObject jsonObject) {
        Builder builder = new Builder(jsonObject.optString(JAVASCRIPT_RESOURCE_URL));
        builder.withApiFramework(jsonObject.optString(API_FRAMEWORK, "")).withVendorKey(jsonObject.optString(VENDOR_KEY, "")).withVerificationParameters(jsonObject.optString(VERIFICATION_PARAMETERS, ""));
        return builder.build();
    }

    @NonNull
    public static Set<ViewabilityVendor> createFromJsonArray(@Nullable JSONArray viewabilityVendors) {
        HashSet<ViewabilityVendor> list = new HashSet<ViewabilityVendor>();
        if (viewabilityVendors != null) {
            for (int i = 0; i < viewabilityVendors.length(); ++i) {
                JSONObject item = viewabilityVendors.optJSONObject(i);
                ViewabilityVendor vendor = ViewabilityVendor.createFromJson(item);
                if (vendor == null) continue;
                list.add(vendor);
            }
        }
        return list;
    }

    public static class Builder {
        @Nullable
        private String apiFramework = "omid";
        @Nullable
        private String vendorKey;
        @NonNull
        private String javascriptResourceUrl;
        @Nullable
        private String verificationParameters;
        @Nullable
        private String verificationNotExecuted;

        public Builder(@NonNull String javascriptResourceUrl) {
            this.javascriptResourceUrl = javascriptResourceUrl;
        }

        @NonNull
        public Builder withVendorKey(@Nullable String vendorKey) {
            this.vendorKey = vendorKey;
            return this;
        }

        @NonNull
        public Builder withVerificationParameters(@Nullable String verificationParameters) {
            this.verificationParameters = verificationParameters;
            return this;
        }

        @NonNull
        public Builder withApiFramework(@Nullable String apiFramework) {
            this.apiFramework = apiFramework;
            return this;
        }

        @NonNull
        public Builder withVerificationNotExecuted(@Nullable String verificationNotExecuted) {
            this.verificationNotExecuted = verificationNotExecuted;
            return this;
        }

        @Nullable
        public ViewabilityVendor build() {
            try {
                return new ViewabilityVendor(this);
            }
            catch (Exception e) {
                MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Warning: " + e.getLocalizedMessage());
                return null;
            }
        }
    }
}

