/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Views;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class VisibilityTracker {
    private static final int VISIBILITY_THROTTLE_MILLIS = 100;
    @VisibleForTesting
    static final int NUM_ACCESSES_BEFORE_TRIMMING = 50;
    @NonNull
    private final ArrayList<View> mTrimmedViews;
    private long mAccessCounter = 0L;
    @NonNull
    @VisibleForTesting
    final ViewTreeObserver.OnPreDrawListener mOnPreDrawListener;
    @NonNull
    @VisibleForTesting
    WeakReference<ViewTreeObserver> mWeakViewTreeObserver;
    @NonNull
    private final Map<View, TrackingInfo> mTrackedViews;
    @NonNull
    private final VisibilityChecker mVisibilityChecker;
    @Nullable
    private VisibilityTrackerListener mVisibilityTrackerListener;
    @NonNull
    private final VisibilityRunnable mVisibilityRunnable;
    @NonNull
    private final Handler mVisibilityHandler;
    private boolean mIsVisibilityScheduled;

    public VisibilityTracker(@NonNull Context context) {
        this(context, new WeakHashMap<View, TrackingInfo>(10), new VisibilityChecker(), new Handler());
    }

    @VisibleForTesting
    VisibilityTracker(@NonNull Context context, @NonNull Map<View, TrackingInfo> trackedViews, @NonNull VisibilityChecker visibilityChecker, @NonNull Handler visibilityHandler) {
        this.mTrackedViews = trackedViews;
        this.mVisibilityChecker = visibilityChecker;
        this.mVisibilityHandler = visibilityHandler;
        this.mVisibilityRunnable = new VisibilityRunnable();
        this.mTrimmedViews = new ArrayList(50);
        this.mOnPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                VisibilityTracker.this.scheduleVisibilityCheck();
                return true;
            }
        };
        this.mWeakViewTreeObserver = new WeakReference<Object>(null);
        this.setViewTreeObserver(context, null);
    }

    private void setViewTreeObserver(@Nullable Context context, @Nullable View view) {
        ViewTreeObserver originalViewTreeObserver = (ViewTreeObserver)this.mWeakViewTreeObserver.get();
        if (originalViewTreeObserver != null && originalViewTreeObserver.isAlive()) {
            return;
        }
        View rootView = Views.getTopmostView(context, view);
        if (rootView == null) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Unable to set Visibility Tracker due to no available root view.");
            return;
        }
        ViewTreeObserver viewTreeObserver = rootView.getViewTreeObserver();
        if (!viewTreeObserver.isAlive()) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Visibility Tracker was unable to track views because the root view tree observer was not alive");
            return;
        }
        this.mWeakViewTreeObserver = new WeakReference<ViewTreeObserver>(viewTreeObserver);
        viewTreeObserver.addOnPreDrawListener(this.mOnPreDrawListener);
    }

    public void setVisibilityTrackerListener(@Nullable VisibilityTrackerListener visibilityTrackerListener) {
        this.mVisibilityTrackerListener = visibilityTrackerListener;
    }

    public void addView(@NonNull View view, int minPercentageViewed, @Nullable Integer minVisiblePx) {
        this.addView(view, view, minPercentageViewed, minVisiblePx);
    }

    public void addView(@NonNull View rootView, @NonNull View view, int minPercentageViewed, @Nullable Integer minVisiblePx) {
        this.addView(rootView, view, minPercentageViewed, minPercentageViewed, minVisiblePx);
    }

    public void addView(@NonNull View rootView, @NonNull View view, int minVisiblePercentageViewed, int maxInvisiblePercentageViewed, @Nullable Integer minVisiblePx) {
        this.setViewTreeObserver(view.getContext(), view);
        TrackingInfo trackingInfo = this.mTrackedViews.get(view);
        if (trackingInfo == null) {
            trackingInfo = new TrackingInfo();
            this.mTrackedViews.put(view, trackingInfo);
            this.scheduleVisibilityCheck();
        }
        int maxInvisiblePercent = Math.min(maxInvisiblePercentageViewed, minVisiblePercentageViewed);
        trackingInfo.mRootView = rootView;
        trackingInfo.mMinViewablePercent = minVisiblePercentageViewed;
        trackingInfo.mMaxInvisiblePercent = maxInvisiblePercent;
        trackingInfo.mAccessOrder = this.mAccessCounter++;
        trackingInfo.mMinVisiblePx = minVisiblePx;
        if (this.mAccessCounter % 50L == 0L) {
            this.trimTrackedViews(this.mAccessCounter - 50L);
        }
    }

    private void trimTrackedViews(long minAccessOrder) {
        for (Map.Entry<View, TrackingInfo> entry : this.mTrackedViews.entrySet()) {
            if (entry.getValue().mAccessOrder >= minAccessOrder) continue;
            this.mTrimmedViews.add(entry.getKey());
        }
        for (View view : this.mTrimmedViews) {
            this.removeView(view);
        }
        this.mTrimmedViews.clear();
    }

    public void removeView(@NonNull View view) {
        this.mTrackedViews.remove(view);
    }

    public void clear() {
        this.mTrackedViews.clear();
        this.mVisibilityHandler.removeMessages(0);
        this.mIsVisibilityScheduled = false;
    }

    public void destroy() {
        this.clear();
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.mWeakViewTreeObserver.get();
        if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
            viewTreeObserver.removeOnPreDrawListener(this.mOnPreDrawListener);
        }
        this.mWeakViewTreeObserver.clear();
        this.mVisibilityTrackerListener = null;
    }

    public void scheduleVisibilityCheck() {
        if (this.mIsVisibilityScheduled) {
            return;
        }
        this.mIsVisibilityScheduled = true;
        this.mVisibilityHandler.postDelayed((Runnable)this.mVisibilityRunnable, 100L);
    }

    public static class VisibilityChecker {
        private final Rect mClipRect = new Rect();

        public boolean hasRequiredTimeElapsed(long startTimeMillis, int minTimeViewed) {
            return SystemClock.uptimeMillis() - startTimeMillis >= (long)minTimeViewed;
        }

        public boolean isVisible(@Nullable View rootView, @Nullable View view, int minPercentageViewed, @Nullable Integer minVisiblePx) {
            if (view == null || view.getVisibility() != 0 || rootView.getParent() == null) {
                return false;
            }
            if (!view.getGlobalVisibleRect(this.mClipRect)) {
                return false;
            }
            long visibleViewArea = (long)this.mClipRect.height() * (long)this.mClipRect.width();
            long totalViewArea = (long)view.getHeight() * (long)view.getWidth();
            if (totalViewArea <= 0L) {
                return false;
            }
            if (minVisiblePx != null && minVisiblePx > 0) {
                return visibleViewArea >= (long)minVisiblePx.intValue();
            }
            return 100L * visibleViewArea >= (long)minPercentageViewed * totalViewArea;
        }
    }

    class VisibilityRunnable
    implements Runnable {
        @NonNull
        private final ArrayList<View> mVisibleViews;
        @NonNull
        private final ArrayList<View> mInvisibleViews = new ArrayList();

        VisibilityRunnable() {
            this.mVisibleViews = new ArrayList();
        }

        @Override
        public void run() {
            VisibilityTracker.this.mIsVisibilityScheduled = false;
            for (Map.Entry entry : VisibilityTracker.this.mTrackedViews.entrySet()) {
                View view = (View)entry.getKey();
                int minPercentageViewed = ((TrackingInfo)entry.getValue()).mMinViewablePercent;
                int maxInvisiblePercent = ((TrackingInfo)entry.getValue()).mMaxInvisiblePercent;
                Integer minVisiblePx = ((TrackingInfo)entry.getValue()).mMinVisiblePx;
                View rootView = ((TrackingInfo)entry.getValue()).mRootView;
                if (VisibilityTracker.this.mVisibilityChecker.isVisible(rootView, view, minPercentageViewed, minVisiblePx)) {
                    this.mVisibleViews.add(view);
                    continue;
                }
                if (VisibilityTracker.this.mVisibilityChecker.isVisible(rootView, view, maxInvisiblePercent, null)) continue;
                this.mInvisibleViews.add(view);
            }
            if (VisibilityTracker.this.mVisibilityTrackerListener != null) {
                VisibilityTracker.this.mVisibilityTrackerListener.onVisibilityChanged(this.mVisibleViews, this.mInvisibleViews);
            }
            this.mVisibleViews.clear();
            this.mInvisibleViews.clear();
        }
    }

    static class TrackingInfo {
        int mMinViewablePercent;
        int mMaxInvisiblePercent;
        long mAccessOrder;
        View mRootView;
        @Nullable
        Integer mMinVisiblePx;

        TrackingInfo() {
        }
    }

    public static interface VisibilityTrackerListener {
        public void onVisibilityChanged(List<View> var1, List<View> var2);
    }
}

