/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.logging;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Pair;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubDefaultLogger;
import com.mopub.common.logging.MoPubLogger;
import com.mopub.common.util.Strings;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class MoPubLog {
    public static final String LOGTAG = "MoPub";
    private static final int STACK_TRACE_LEVEL = 4;
    @NonNull
    private static final MoPubLog sInstance = new MoPubLog();
    @NonNull
    private LogLevel sLogLevel = LogLevel.INFO;
    @NonNull
    private Map<MoPubLogger, LogLevel> mLoggers = new HashMap<MoPubLogger, LogLevel>();
    @NonNull
    private MoPubLogger mDefaultLogger = new MoPubDefaultLogger();

    private MoPubLog() {
    }

    private static void logDeprecated(@Nullable String message, @Nullable Throwable throwable) {
        MoPubLog.log(SdkLogEvent.CUSTOM_WITH_THROWABLE, message, throwable != null ? throwable.getMessage() : "");
    }

    private static void removeLogger(@Nullable MoPubLogger logger) {
        MoPubLog.sInstance.mLoggers.remove(logger);
    }

    public static void addLogger(@Nullable MoPubLogger logger) {
        MoPubLog.addLogger(logger, MoPubLog.sInstance.sLogLevel);
    }

    public static void addLogger(@Nullable MoPubLogger logger, @Nullable LogLevel logLevel) {
        MoPubLog.sInstance.mLoggers.put(logger, logLevel);
    }

    public static void setLogLevel(@NonNull LogLevel logLevel) {
        Preconditions.checkNotNull(logLevel);
        MoPubLog.sInstance.sLogLevel = logLevel;
        MoPubLog.addLogger(MoPubLog.sInstance.mDefaultLogger, MoPubLog.sInstance.sLogLevel);
    }

    @NonNull
    public static LogLevel getLogLevel() {
        return MoPubLog.sInstance.sLogLevel;
    }

    public static void log(@Nullable MPLogEventType logEventType, Object ... args) {
        Pair<String, String> classAndMethodNames = MoPubLog.getClassAndMethod();
        MoPubLog.log(classAndMethodNames, null, logEventType, args);
    }

    public static void log(@Nullable String identifier, @Nullable MPLogEventType logEventType, Object ... args) {
        Pair<String, String> classAndMethodNames = MoPubLog.getClassAndMethod();
        MoPubLog.log(classAndMethodNames, identifier, logEventType, args);
    }

    private static void log(@NonNull Pair<String, String> classAndMethodNames, @Nullable String identifier, @Nullable MPLogEventType logEventType, Object ... args) {
        Preconditions.checkNotNull(classAndMethodNames);
        if (logEventType == null) {
            return;
        }
        for (MoPubLogger logger : MoPubLog.sInstance.mLoggers.keySet()) {
            if (MoPubLog.sInstance.mLoggers.get(logger) == null || MoPubLog.sInstance.mLoggers.get(logger).intValue() > logEventType.getLogLevel().intValue()) continue;
            logger.log((String)classAndMethodNames.first, (String)classAndMethodNames.second, identifier, logEventType.getMessage(args));
        }
    }

    private static Pair<String, String> getClassAndMethod() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        return new Pair((Object)stackTraceElements[4].getClassName(), (Object)stackTraceElements[4].getMethodName());
    }

    @Deprecated
    public static void c(String message) {
        MoPubLog.c(message, null);
    }

    @Deprecated
    public static void v(String message) {
        MoPubLog.v(message, null);
    }

    @Deprecated
    public static void d(String message) {
        MoPubLog.d(message, null);
    }

    @Deprecated
    public static void i(String message) {
        MoPubLog.i(message, null);
    }

    @Deprecated
    public static void w(String message) {
        MoPubLog.w(message, null);
    }

    @Deprecated
    public static void e(String message) {
        MoPubLog.e(message, null);
    }

    @Deprecated
    public static void c(String message, Throwable throwable) {
        MoPubLog.logDeprecated(message, throwable);
    }

    @Deprecated
    public static void v(String message, Throwable throwable) {
        MoPubLog.logDeprecated(message, throwable);
    }

    @Deprecated
    public static void d(String message, Throwable throwable) {
        MoPubLog.logDeprecated(message, throwable);
    }

    @Deprecated
    public static void i(String message, Throwable throwable) {
        MoPubLog.logDeprecated(message, throwable);
    }

    @Deprecated
    public static void w(String message, Throwable throwable) {
        MoPubLog.logDeprecated(message, throwable);
    }

    @Deprecated
    public static void e(String message, Throwable throwable) {
        MoPubLog.logDeprecated(message, throwable);
    }

    public static enum SdkLogEvent implements MPLogEventType
    {
        INIT_STARTED(LogLevel.DEBUG, "SDK initialization started"),
        INIT_FINISHED(LogLevel.INFO, "SDK initialized and ready to display ads.\nInitialized adapters:\n{0}"),
        INIT_FAILED(LogLevel.INFO, "SDK initialization failed - {0}\n{1}"),
        CUSTOM(LogLevel.DEBUG, "SDK Log - {0}"),
        CUSTOM_WITH_THROWABLE(LogLevel.DEBUG, "SDK Log With Throwable - {0}, {1}"),
        ERROR(LogLevel.DEBUG, "SDK Error Log - {0}"),
        ERROR_WITH_THROWABLE(LogLevel.DEBUG, "SDK Error Log - {0}, {1}");

        private LogLevel mLogLevel;
        private String mMessageFormat;

        private SdkLogEvent(LogLevel logLevel, String messageFormat) {
            Preconditions.checkNotNull(logLevel);
            Preconditions.checkNotNull(messageFormat);
            this.mLogLevel = logLevel;
            this.mMessageFormat = messageFormat;
        }

        @Override
        @NonNull
        public String getMessage(Object ... args) {
            if (this == INIT_FINISHED && args.length > 0) {
                String adapters = Strings.getDelimitedString(args[0], "\n");
                args[0] = TextUtils.isEmpty((CharSequence)adapters) ? "No adapters initialized." : adapters;
            }
            return MessageFormat.format(this.mMessageFormat, args);
        }

        @Override
        @NonNull
        public LogLevel getLogLevel() {
            return this.mLogLevel;
        }
    }

    public static enum ConsentLogEvent implements MPLogEventType
    {
        SYNC_ATTEMPTED(LogLevel.DEBUG, "Consent attempting to synchronize state"),
        SYNC_COMPLETED(LogLevel.DEBUG, "Consent synchronization completed: {0}"),
        SYNC_FAILED(LogLevel.DEBUG, "Consent synchronization failed: ({0}) {1}"),
        UPDATED(LogLevel.DEBUG, "Consent changed from {0} to {1}: PII {2} be collected. Reason: {3}"),
        SHOULD_SHOW_DIALOG(LogLevel.DEBUG, "Consent dialog should be shown"),
        LOAD_ATTEMPTED(LogLevel.DEBUG, "Consent attempting to load dialog"),
        LOAD_SUCCESS(LogLevel.DEBUG, "Consent dialog loaded"),
        LOAD_FAILED(LogLevel.DEBUG, "Consent dialog failed: ({0}) {1}"),
        SHOW_ATTEMPTED(LogLevel.DEBUG, "Consent dialog attempting to show"),
        SHOW_SUCCESS(LogLevel.DEBUG, "Consent successfully showed dialog"),
        SHOW_FAILED(LogLevel.DEBUG, "Consent dialog failed to show: ({0}) {1}"),
        CUSTOM(LogLevel.DEBUG, "Consent Log - {0}"),
        CUSTOM_WITH_THROWABLE(LogLevel.DEBUG, "Consent Log With Throwable - {0}, {1}");

        private LogLevel mLogLevel;
        private String mMessageFormat;

        private ConsentLogEvent(LogLevel logLevel, String messageFormat) {
            Preconditions.checkNotNull(logLevel);
            Preconditions.checkNotNull(messageFormat);
            this.mLogLevel = logLevel;
            this.mMessageFormat = messageFormat;
        }

        @Override
        @NonNull
        public String getMessage(Object ... args) {
            if (this == UPDATED && args != null && args.length > 2) {
                args[2] = args[2] instanceof Boolean && (Boolean)args[2] != false ? "can" : "cannot";
            }
            return MessageFormat.format(this.mMessageFormat, args);
        }

        @Override
        @NonNull
        public LogLevel getLogLevel() {
            return this.mLogLevel;
        }
    }

    public static enum AdapterLogEvent implements MPLogEventType
    {
        LOAD_ATTEMPTED(LogLevel.DEBUG, "Adapter {0} attempting to load ad{1}{2}"),
        LOAD_SUCCESS(LogLevel.DEBUG, "Adapter {0} successfully loaded ad"),
        LOAD_FAILED(LogLevel.DEBUG, "Adapter {0} failed to load ad: ({1}) {2}"),
        SHOW_ATTEMPTED(LogLevel.DEBUG, "Adapter {0} attempting to show ad"),
        SHOW_SUCCESS(LogLevel.DEBUG, "Adapter {0} successfully showed ad"),
        SHOW_FAILED(LogLevel.DEBUG, "Adapter {0} failed to show ad: ({1}) {2}"),
        EXPIRED(LogLevel.DEBUG, "Adapter {0} expired since it was not shown within {1} seconds of it being loaded"),
        CLICKED(LogLevel.DEBUG, "Adapter {0} clicked"),
        WILL_APPEAR(LogLevel.DEBUG, "Adapter {0} will appear"),
        DID_APPEAR(LogLevel.DEBUG, "Adapter {0} did appear"),
        WILL_DISAPPEAR(LogLevel.DEBUG, "Adapter {0} will disappear"),
        DID_DISAPPEAR(LogLevel.DEBUG, "Adapter {0} did disappear"),
        SHOULD_REWARD(LogLevel.DEBUG, "Adapter {0} should reward user with {1} {2}"),
        WILL_LEAVE_APPLICATION(LogLevel.DEBUG, "Adapter {0} will leave application"),
        CUSTOM(LogLevel.DEBUG, "Adapter {0} Log - {1}"),
        CUSTOM_WITH_THROWABLE(LogLevel.DEBUG, "Adapter {0} Log With Throwable - {1}, {2}");

        private LogLevel mLogLevel;
        private String mMessageFormat;

        private AdapterLogEvent(LogLevel logLevel, String messageFormat) {
            Preconditions.checkNotNull(logLevel);
            Preconditions.checkNotNull(messageFormat);
            this.mLogLevel = logLevel;
            this.mMessageFormat = messageFormat;
        }

        @Override
        @NonNull
        public String getMessage(Object ... args) {
            MessageFormat mf = new MessageFormat(this.mMessageFormat);
            Object[] params = Arrays.copyOf(args, mf.getFormats().length);
            if (this == LOAD_ATTEMPTED) {
                params[1] = args.length > 1 && args[1] != null && !TextUtils.isEmpty((CharSequence)args[1].toString()) ? MessageFormat.format(" with DSP creative ID {0}", args[1].toString()) : "";
                params[2] = args.length > 2 && args[2] != null && !TextUtils.isEmpty((CharSequence)args[2].toString()) ? MessageFormat.format(" with DSP name {0}", args[2].toString()) : "";
            }
            return mf.format(params);
        }

        @Override
        @NonNull
        public LogLevel getLogLevel() {
            return this.mLogLevel;
        }
    }

    public static enum AdLogEvent implements MPLogEventType
    {
        REQUESTED(LogLevel.DEBUG, "Ad requesting from AdServer: {0}\n{1}"),
        RESPONSE_RECEIVED(LogLevel.DEBUG, "Ad server responded with:\n{0}"),
        LOAD_ATTEMPTED(LogLevel.INFO, "Ad attempting to load"),
        LOAD_SUCCESS(LogLevel.INFO, "Ad loaded"),
        LOAD_FAILED(LogLevel.INFO, "Ad failed to load: ({0}) {1}"),
        SHOW_ATTEMPTED(LogLevel.INFO, "Attempting to show ad"),
        SHOW_SUCCESS(LogLevel.INFO, "Ad shown"),
        SHOW_FAILED(LogLevel.INFO, "Ad failed to show: ({0}) {1}"),
        EXPIRED(LogLevel.DEBUG, "Ad expired since it was not shown within {0} seconds of it being loaded"),
        CLICKED(LogLevel.DEBUG, "Ad clicked"),
        WILL_APPEAR(LogLevel.DEBUG, "Ad will appear"),
        DID_APPEAR(LogLevel.DEBUG, "Ad did appear"),
        WILL_DISAPPEAR(LogLevel.DEBUG, "Ad will disappear"),
        DID_DISAPPEAR(LogLevel.DEBUG, "Ad did disappear"),
        SHOULD_REWARD(LogLevel.DEBUG, "Ad should reward user with {0} {1}"),
        WILL_LEAVE_APPLICATION(LogLevel.DEBUG, "Ad will leave application"),
        CUSTOM(LogLevel.DEBUG, "Ad Log - {0}"),
        CUSTOM_WITH_THROWABLE(LogLevel.DEBUG, "Ad Log With Throwable - {0}, {1}");

        private LogLevel mLogLevel;
        private String mMessageFormat;

        private AdLogEvent(LogLevel logLevel, String messageFormat) {
            Preconditions.checkNotNull(logLevel);
            Preconditions.checkNotNull(messageFormat);
            this.mLogLevel = logLevel;
            this.mMessageFormat = messageFormat;
        }

        @Override
        @NonNull
        public String getMessage(Object ... args) {
            return MessageFormat.format(this.mMessageFormat, args);
        }

        @Override
        @NonNull
        public LogLevel getLogLevel() {
            return this.mLogLevel;
        }
    }

    protected static interface MPLogEventType {
        @NonNull
        public String getMessage(Object ... var1);

        @NonNull
        public LogLevel getLogLevel();
    }

    public static enum LogLevel implements LogLevelInt
    {
        DEBUG(20, "DEBUG"),
        INFO(30, "INFO"),
        NONE(70, "NONE");

        private int mLevel;
        private String mLevelString;

        private LogLevel(int level, String levelString) {
            this.mLevel = level;
            this.mLevelString = levelString;
        }

        @NonNull
        public String toString() {
            return this.mLevelString;
        }

        @NonNull
        public int intValue() {
            return this.mLevel;
        }

        @NonNull
        public static LogLevel valueOf(int level) {
            switch (level) {
                case 20: {
                    return DEBUG;
                }
                case 30: {
                    return INFO;
                }
            }
            return NONE;
        }
    }

    public static interface LogLevelInt {
        public static final int DEBUG_INT = 20;
        public static final int INFO_INT = 30;
        public static final int NONE_INT = 70;
    }
}

