/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.privacy;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.mopub.common.Preconditions;
import java.io.Serializable;
import java.util.UUID;

public class AdvertisingId
implements Serializable {
    private static final String PREFIX_IFA = "ifa:";
    private static final String PREFIX_MOPUB = "mopub:";
    @NonNull
    final String mAdvertisingId;
    @NonNull
    final String mMopubId;
    final boolean mDoNotTrack;

    AdvertisingId(@NonNull String ifaId, @NonNull String mopubId, boolean limitAdTrackingEnabled) {
        Preconditions.checkNotNull(ifaId);
        Preconditions.checkNotNull(mopubId);
        this.mAdvertisingId = ifaId;
        this.mMopubId = mopubId;
        this.mDoNotTrack = limitAdTrackingEnabled;
    }

    public String getIdentifier(boolean consent) {
        return this.mDoNotTrack || !consent ? this.mMopubId : this.mAdvertisingId;
    }

    @NonNull
    public String getIdWithPrefix(boolean consent) {
        if (this.mDoNotTrack || !consent || this.mAdvertisingId.isEmpty()) {
            return PREFIX_MOPUB + this.mMopubId;
        }
        return PREFIX_IFA + this.mAdvertisingId;
    }

    @NonNull
    String getIfaWithPrefix() {
        if (TextUtils.isEmpty((CharSequence)this.mAdvertisingId)) {
            return "";
        }
        return PREFIX_IFA + this.mAdvertisingId;
    }

    @NonNull
    String getIfa() {
        return this.mAdvertisingId;
    }

    public boolean isDoNotTrack() {
        return this.mDoNotTrack;
    }

    @NonNull
    static AdvertisingId generateFreshAdvertisingId() {
        String mopubId = AdvertisingId.generateIdString();
        return new AdvertisingId("", mopubId, false);
    }

    @NonNull
    static String generateIdString() {
        return UUID.randomUUID().toString();
    }

    @NonNull
    public String toString() {
        return "AdvertisingId{, mAdvertisingId='" + this.mAdvertisingId + '\'' + ", mMopubId='" + this.mMopubId + '\'' + ", mDoNotTrack=" + this.mDoNotTrack + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdvertisingId)) {
            return false;
        }
        AdvertisingId that = (AdvertisingId)o;
        if (this.mDoNotTrack != that.mDoNotTrack) {
            return false;
        }
        if (!this.mAdvertisingId.equals(that.mAdvertisingId)) {
            return false;
        }
        return this.mMopubId.equals(that.mMopubId);
    }

    public int hashCode() {
        int result = this.mAdvertisingId.hashCode();
        result = 31 * result + this.mMopubId.hashCode();
        result = 31 * result + (this.mDoNotTrack ? 1 : 0);
        return result;
    }
}

