/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.privacy;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.MoPub;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.privacy.ConsentDialogLayout;
import com.mopub.common.privacy.ConsentStatus;
import com.mopub.common.privacy.PersonalInfoManager;
import com.mopub.common.util.Intents;
import com.mopub.exceptions.IntentNotResolvableException;
import com.mopub.mobileads.MoPubErrorCode;

public class ConsentDialogActivity
extends Activity {
    private static final int CLOSE_BUTTON_DELAY_MS = 10000;
    private static final String KEY_HTML_PAGE = "html-page-content";
    @Nullable
    ConsentDialogLayout mView;
    @Nullable
    private Runnable mEnableCloseButtonRunnable;
    @Nullable
    Handler mCloseButtonHandler;
    @Nullable
    ConsentStatus mConsentStatus;

    static void start(@NonNull Context context, @NonNull String htmlData) {
        Preconditions.checkNotNull(context);
        if (TextUtils.isEmpty((CharSequence)htmlData)) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "ConsentDialogActivity htmlData can't be empty string.");
            MoPubLog.log(MoPubLog.ConsentLogEvent.SHOW_FAILED, MoPubErrorCode.INTERNAL_ERROR.getIntCode(), MoPubErrorCode.INTERNAL_ERROR);
            return;
        }
        Intent intent = ConsentDialogActivity.createIntent(context, htmlData);
        try {
            Intents.startActivity(context, intent);
        }
        catch (ActivityNotFoundException | IntentNotResolvableException e) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "ConsentDialogActivity not found - did you declare it in AndroidManifest.xml?");
            MoPubLog.log(MoPubLog.ConsentLogEvent.SHOW_FAILED, MoPubErrorCode.INTERNAL_ERROR.getIntCode(), MoPubErrorCode.INTERNAL_ERROR);
        }
    }

    @NonNull
    static Intent createIntent(@NonNull Context context, @NonNull String htmlPageContent) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(htmlPageContent);
        Bundle extra = new Bundle();
        extra.putString(KEY_HTML_PAGE, htmlPageContent);
        return Intents.getStartActivityIntent(context, ConsentDialogActivity.class, extra);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        String htmlBody = intent.getStringExtra(KEY_HTML_PAGE);
        if (TextUtils.isEmpty((CharSequence)htmlBody)) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Web page for ConsentDialogActivity is empty");
            MoPubLog.log(MoPubLog.ConsentLogEvent.SHOW_FAILED, MoPubErrorCode.INTERNAL_ERROR.getIntCode(), MoPubErrorCode.INTERNAL_ERROR);
            this.finish();
            return;
        }
        this.requestWindowFeature(1);
        this.getWindow().addFlags(1024);
        try {
            this.mView = new ConsentDialogLayout((Context)this);
        }
        catch (RuntimeException e) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM_WITH_THROWABLE, "Unable to create WebView", e);
            MoPubLog.log(MoPubLog.ConsentLogEvent.SHOW_FAILED, MoPubErrorCode.INTERNAL_ERROR.getIntCode(), MoPubErrorCode.INTERNAL_ERROR);
            this.finish();
            return;
        }
        this.mView.setConsentClickListener(new ConsentDialogLayout.ConsentListener(){

            @Override
            public void onConsentClick(ConsentStatus status) {
                ConsentDialogActivity.this.saveConsentStatus(status);
                ConsentDialogActivity.this.setCloseButtonVisibility(false);
            }

            @Override
            public void onCloseClick() {
                ConsentDialogActivity.this.finish();
            }
        });
        this.mEnableCloseButtonRunnable = new Runnable(){

            @Override
            public void run() {
                ConsentDialogActivity.this.setCloseButtonVisibility(true);
            }
        };
        this.setContentView((View)this.mView);
        this.mView.startLoading(htmlBody, new ConsentDialogLayout.PageLoadListener(){

            @Override
            public void onLoadProgress(int progress) {
                if (progress == ConsentDialogLayout.FINISHED_LOADING) {
                    // empty if block
                }
            }
        });
    }

    protected void onStart() {
        super.onStart();
        this.mCloseButtonHandler = new Handler();
        this.mCloseButtonHandler.postDelayed(this.mEnableCloseButtonRunnable, 10000L);
    }

    protected void onResume() {
        super.onResume();
        MoPubLog.log(MoPubLog.ConsentLogEvent.SHOW_SUCCESS, new Object[0]);
    }

    protected void onStop() {
        super.onStop();
        this.setCloseButtonVisibility(true);
    }

    protected void onDestroy() {
        PersonalInfoManager infoManager = MoPub.getPersonalInformationManager();
        if (infoManager != null && this.mConsentStatus != null) {
            infoManager.changeConsentStateFromDialog(this.mConsentStatus);
        }
        super.onDestroy();
    }

    void setCloseButtonVisibility(boolean visible) {
        if (this.mCloseButtonHandler != null) {
            this.mCloseButtonHandler.removeCallbacks(this.mEnableCloseButtonRunnable);
        }
        if (this.mView != null) {
            this.mView.setCloseVisible(visible);
        }
    }

    private void saveConsentStatus(@NonNull ConsentStatus status) {
        Preconditions.checkNotNull((Object)status);
        this.mConsentStatus = status;
    }
}

