/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.privacy;

import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.Constants;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.privacy.ConsentDialogActivity;
import com.mopub.common.privacy.ConsentDialogListener;
import com.mopub.common.privacy.ConsentDialogRequest;
import com.mopub.common.privacy.ConsentDialogResponse;
import com.mopub.common.privacy.ConsentDialogUrlGenerator;
import com.mopub.common.privacy.PersonalInfoData;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.network.MoPubNetworkError;
import com.mopub.network.Networking;
import com.mopub.volley.VolleyError;

public class ConsentDialogController
implements ConsentDialogRequest.Listener {
    @NonNull
    private final Context mAppContext;
    @Nullable
    private String mHtmlBody;
    @Nullable
    private ConsentDialogListener mExtListener;
    volatile boolean mReady;
    volatile boolean mRequestInFlight;
    private final Handler mHandler;

    ConsentDialogController(@NonNull Context appContext) {
        Preconditions.checkNotNull(appContext);
        this.mAppContext = appContext.getApplicationContext();
        this.mHandler = new Handler();
    }

    @Override
    public void onSuccess(ConsentDialogResponse response) {
        this.mRequestInFlight = false;
        this.mHtmlBody = response.getHtml();
        if (TextUtils.isEmpty((CharSequence)this.mHtmlBody)) {
            this.mReady = false;
            if (this.mExtListener != null) {
                MoPubLog.log(MoPubLog.ConsentLogEvent.LOAD_FAILED, MoPubErrorCode.INTERNAL_ERROR.getIntCode(), MoPubErrorCode.INTERNAL_ERROR);
                this.mExtListener.onConsentDialogLoadFailed(MoPubErrorCode.INTERNAL_ERROR);
            }
            return;
        }
        MoPubLog.log(MoPubLog.ConsentLogEvent.LOAD_SUCCESS, new Object[0]);
        this.mReady = true;
        if (this.mExtListener != null) {
            this.mExtListener.onConsentDialogLoaded();
        }
    }

    public void onErrorResponse(VolleyError volleyError) {
        ConsentDialogListener loadListener = this.mExtListener;
        this.resetState();
        if (loadListener == null) {
            return;
        }
        if (volleyError instanceof MoPubNetworkError) {
            switch (((MoPubNetworkError)volleyError).getReason()) {
                case BAD_BODY: {
                    MoPubLog.log(MoPubLog.ConsentLogEvent.LOAD_FAILED, MoPubErrorCode.INTERNAL_ERROR.getIntCode(), MoPubErrorCode.INTERNAL_ERROR);
                    loadListener.onConsentDialogLoadFailed(MoPubErrorCode.INTERNAL_ERROR);
                    return;
                }
            }
            MoPubLog.log(MoPubLog.ConsentLogEvent.LOAD_FAILED, MoPubErrorCode.UNSPECIFIED.getIntCode(), MoPubErrorCode.UNSPECIFIED);
        }
        loadListener.onConsentDialogLoadFailed(MoPubErrorCode.UNSPECIFIED);
    }

    synchronized void loadConsentDialog(final @Nullable ConsentDialogListener listener, @Nullable Boolean gdprApplies, @NonNull PersonalInfoData personalInfoData) {
        Preconditions.checkNotNull(personalInfoData);
        if (this.mReady) {
            if (listener != null) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        MoPubLog.log(MoPubLog.ConsentLogEvent.LOAD_SUCCESS, new Object[0]);
                        listener.onConsentDialogLoaded();
                    }
                });
            }
            return;
        }
        if (this.mRequestInFlight) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Already making a consent dialog load request.");
            return;
        }
        this.mExtListener = listener;
        this.mRequestInFlight = true;
        ConsentDialogRequest consentDialogRequest = new ConsentDialogRequest(this.mAppContext, new ConsentDialogUrlGenerator(this.mAppContext, personalInfoData.getAdUnitId(), personalInfoData.getConsentStatus().getValue()).withGdprApplies(gdprApplies).withConsentedPrivacyPolicyVersion(personalInfoData.getConsentedPrivacyPolicyVersion()).withConsentedVendorListVersion(personalInfoData.getConsentedVendorListVersion()).withForceGdprApplies(personalInfoData.isForceGdprApplies()).generateUrlString(Constants.HOST), this);
        Networking.getRequestQueue(this.mAppContext).add(consentDialogRequest);
    }

    boolean showConsentDialog() {
        MoPubLog.log(MoPubLog.ConsentLogEvent.SHOW_ATTEMPTED, new Object[0]);
        if (!this.mReady || TextUtils.isEmpty((CharSequence)this.mHtmlBody)) {
            MoPubLog.log(MoPubLog.ConsentLogEvent.SHOW_FAILED, MoPubErrorCode.INTERNAL_ERROR.getIntCode(), MoPubErrorCode.INTERNAL_ERROR);
            return false;
        }
        this.mReady = false;
        ConsentDialogActivity.start(this.mAppContext, this.mHtmlBody);
        this.resetState();
        return true;
    }

    boolean isReady() {
        return this.mReady;
    }

    private void resetState() {
        this.mRequestInFlight = false;
        this.mReady = false;
        this.mExtListener = null;
        this.mHtmlBody = null;
    }
}

