/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.privacy;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.mopub.common.CloseableLayout;
import com.mopub.common.Constants;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.privacy.ConsentStatus;
import com.mopub.common.util.Intents;
import com.mopub.exceptions.IntentNotResolvableException;
import com.mopub.mobileads.MoPubErrorCode;

class ConsentDialogLayout
extends CloseableLayout {
    static int FINISHED_LOADING = 101;
    static final String URL_CONSENT_YES = "mopub://consent?yes";
    static final String URL_CONSENT_NO = "mopub://consent?no";
    static final String URL_CLOSE = "mopub://close";
    @NonNull
    private final WebView mWebView;
    @Nullable
    private PageLoadListener mLoadListener;
    @Nullable
    private ConsentListener mConsentListener;
    private final WebViewClient webViewClient = new WebViewClient(){

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            if (ConsentDialogLayout.this.mLoadListener != null) {
                ConsentDialogLayout.this.mLoadListener.onLoadProgress(0);
            }
        }

        public void onPageFinished(WebView view, String url) {
            if (ConsentDialogLayout.this.mLoadListener != null) {
                ConsentDialogLayout.this.mLoadListener.onLoadProgress(FINISHED_LOADING);
            }
            super.onPageFinished(view, url);
        }

        @RequiresApi(value=26)
        public boolean onRenderProcessGone(@Nullable WebView view, @Nullable RenderProcessGoneDetail detail) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, detail != null && detail.didCrash() ? MoPubErrorCode.RENDER_PROCESS_GONE_WITH_CRASH : MoPubErrorCode.RENDER_PROCESS_GONE_UNSPECIFIED);
            return true;
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (ConsentDialogLayout.URL_CONSENT_YES.equals(url)) {
                if (ConsentDialogLayout.this.mConsentListener != null) {
                    ConsentDialogLayout.this.mConsentListener.onConsentClick(ConsentStatus.EXPLICIT_YES);
                }
                return true;
            }
            if (ConsentDialogLayout.URL_CONSENT_NO.equals(url)) {
                if (ConsentDialogLayout.this.mConsentListener != null) {
                    ConsentDialogLayout.this.mConsentListener.onConsentClick(ConsentStatus.EXPLICIT_NO);
                }
                return true;
            }
            if (ConsentDialogLayout.URL_CLOSE.equals(url)) {
                if (ConsentDialogLayout.this.mConsentListener != null) {
                    ConsentDialogLayout.this.mConsentListener.onCloseClick();
                }
                return true;
            }
            if (!TextUtils.isEmpty((CharSequence)url)) {
                try {
                    Intents.launchActionViewIntent(ConsentDialogLayout.this.getContext(), Uri.parse((String)url), "Cannot open native browser for " + url);
                    return true;
                }
                catch (IntentNotResolvableException e) {
                    MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, e.getMessage());
                }
            }
            return super.shouldOverrideUrlLoading(view, url);
        }
    };

    public ConsentDialogLayout(@NonNull Context context) {
        super(context);
        this.mWebView = this.initWebView();
    }

    public ConsentDialogLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.mWebView = this.initWebView();
    }

    public ConsentDialogLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mWebView = this.initWebView();
    }

    void startLoading(@NonNull String htmlData, @Nullable PageLoadListener listener) {
        Preconditions.checkNotNull(htmlData);
        this.mLoadListener = listener;
        this.setupEventsListeners(this.mWebView);
        this.mWebView.loadDataWithBaseURL("https://" + Constants.HOST + "/", htmlData, "text/html", "UTF-8", null);
    }

    void setConsentClickListener(@NonNull ConsentListener consentListener) {
        Preconditions.checkNotNull(consentListener);
        this.mConsentListener = consentListener;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private WebView initWebView() {
        WebView webView = new WebView(this.getContext());
        webView.setVerticalScrollBarEnabled(false);
        webView.setHorizontalScrollBarEnabled(false);
        WebSettings webSettings = webView.getSettings();
        webSettings.setSupportZoom(false);
        webSettings.setBuiltInZoomControls(false);
        webSettings.setLoadsImagesAutomatically(true);
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setDomStorageEnabled(true);
        webSettings.setAppCacheEnabled(true);
        webSettings.setAppCachePath(this.getContext().getCacheDir().getAbsolutePath());
        webSettings.setAllowFileAccess(false);
        webSettings.setAllowContentAccess(false);
        webSettings.setAllowUniversalAccessFromFileURLs(false);
        webView.setId(View.generateViewId());
        this.setCloseVisible(false);
        this.addView((View)webView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        return webView;
    }

    private void setupEventsListeners(@NonNull WebView webView) {
        webView.setWebViewClient(this.webViewClient);
        this.setOnCloseListener(new CloseableLayout.OnCloseListener(){

            @Override
            public void onClose() {
                if (ConsentDialogLayout.this.mConsentListener != null) {
                    ConsentDialogLayout.this.mConsentListener.onCloseClick();
                }
            }
        });
    }

    static interface PageLoadListener {
        public void onLoadProgress(int var1);
    }

    static interface ConsentListener {
        public void onConsentClick(ConsentStatus var1);

        public void onCloseClick();
    }
}

