/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.privacy;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.provider.Settings;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.GpsHelper;
import com.mopub.common.Preconditions;
import com.mopub.common.SdkInitializationListener;
import com.mopub.common.SharedPreferencesHelper;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.privacy.AdvertisingId;
import com.mopub.common.util.AsyncTasks;

public class MoPubIdentifier {
    private static final String PREF_AD_INFO_GROUP = "com.mopub.settings.identifier";
    private static final String PREF_IFA_IDENTIFIER = "privacy.identifier.ifa";
    private static final String PREF_MOPUB_IDENTIFIER = "privacy.identifier.mopub";
    private static final String PREF_IDENTIFIER_TIME = "privacy.identifier.time";
    private static final String PREF_LIMIT_AD_TRACKING = "privacy.limit.ad.tracking";
    private static final int MISSING_VALUE = -1;
    @NonNull
    private AdvertisingId mAdInfo;
    @NonNull
    private final Context mAppContext;
    @Nullable
    private AdvertisingIdChangeListener mIdChangeListener;
    private boolean mRefreshingAdvertisingInfo;
    private boolean initialized;
    @Nullable
    private volatile SdkInitializationListener mInitializationListener;

    public MoPubIdentifier(@NonNull Context appContext) {
        this(appContext, null);
    }

    @VisibleForTesting
    MoPubIdentifier(@NonNull Context appContext, @Nullable AdvertisingIdChangeListener idChangeListener) {
        Preconditions.checkNotNull(appContext);
        this.mAppContext = appContext;
        this.mIdChangeListener = idChangeListener;
        this.mAdInfo = MoPubIdentifier.readIdFromStorage(this.mAppContext);
        if (this.mAdInfo == null) {
            this.mAdInfo = AdvertisingId.generateFreshAdvertisingId();
        }
        this.refreshAdvertisingInfo();
    }

    @NonNull
    public AdvertisingId getAdvertisingInfo() {
        AdvertisingId adInfo = this.mAdInfo;
        this.refreshAdvertisingInfo();
        return adInfo;
    }

    private void refreshAdvertisingInfo() {
        if (this.mRefreshingAdvertisingInfo) {
            return;
        }
        this.mRefreshingAdvertisingInfo = true;
        AsyncTasks.safeExecuteOnExecutor(new RefreshAdvertisingInfoAsyncTask(), new Void[0]);
    }

    void refreshAdvertisingInfoBackgroundThread() {
        AdvertisingId oldInfo = this.mAdInfo;
        GpsHelper.AdvertisingInfo googleAdInfo = GpsHelper.fetchAdvertisingInfoSync(this.mAppContext);
        AdvertisingId newInfo = googleAdInfo != null && !TextUtils.isEmpty((CharSequence)googleAdInfo.advertisingId) ? new AdvertisingId(googleAdInfo.advertisingId, oldInfo.mMopubId, googleAdInfo.limitAdTracking) : this.getAmazonAdvertisingInfo(this.mAppContext);
        if (newInfo != null) {
            this.setAdvertisingInfo(newInfo.mAdvertisingId, oldInfo.mMopubId, newInfo.mDoNotTrack);
        } else {
            this.setAdvertisingInfo(this.mAdInfo);
        }
    }

    @Nullable
    static synchronized AdvertisingId readIdFromStorage(@NonNull Context appContext) {
        Preconditions.checkNotNull(appContext);
        try {
            SharedPreferences preferences = SharedPreferencesHelper.getSharedPreferences(appContext, PREF_AD_INFO_GROUP);
            String ifa_id = preferences.getString(PREF_IFA_IDENTIFIER, "");
            String mopub_id = preferences.getString(PREF_MOPUB_IDENTIFIER, "");
            boolean limitTracking = preferences.getBoolean(PREF_LIMIT_AD_TRACKING, false);
            if (!TextUtils.isEmpty((CharSequence)ifa_id) && !TextUtils.isEmpty((CharSequence)mopub_id)) {
                return new AdvertisingId(ifa_id, mopub_id, limitTracking);
            }
        }
        catch (ClassCastException ex) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Cannot read identifier from shared preferences");
        }
        return null;
    }

    private static synchronized void writeIdToStorage(@NonNull Context context, @NonNull AdvertisingId info) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(info);
        SharedPreferences preferences = SharedPreferencesHelper.getSharedPreferences(context, PREF_AD_INFO_GROUP);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean(PREF_LIMIT_AD_TRACKING, info.mDoNotTrack);
        editor.putString(PREF_IFA_IDENTIFIER, info.mAdvertisingId);
        editor.putString(PREF_MOPUB_IDENTIFIER, info.mMopubId);
        editor.apply();
    }

    @VisibleForTesting
    static synchronized void clearStorage(@NonNull Context context) {
        Preconditions.checkNotNull(context);
        SharedPreferences preferences = SharedPreferencesHelper.getSharedPreferences(context, PREF_AD_INFO_GROUP);
        SharedPreferences.Editor editor = preferences.edit();
        editor.remove(PREF_LIMIT_AD_TRACKING);
        editor.remove(PREF_IFA_IDENTIFIER);
        editor.remove(PREF_MOPUB_IDENTIFIER);
        editor.remove(PREF_IDENTIFIER_TIME);
        editor.apply();
    }

    private void setAdvertisingInfo(@NonNull String advertisingId, @NonNull String mopubId, boolean limitAdTracking) {
        Preconditions.checkNotNull(advertisingId);
        Preconditions.checkNotNull(mopubId);
        this.setAdvertisingInfo(new AdvertisingId(advertisingId, mopubId, limitAdTracking));
    }

    void setAdvertisingInfo(@NonNull AdvertisingId newId) {
        AdvertisingId oldId = this.mAdInfo;
        this.mAdInfo = newId;
        MoPubIdentifier.writeIdToStorage(this.mAppContext, this.mAdInfo);
        if (this.mAdInfo.mAdvertisingId.endsWith("10ca1ad1abe1")) {
            MoPubLog.setLogLevel(MoPubLog.LogLevel.DEBUG);
        }
        if (!this.mAdInfo.equals(oldId) || !this.initialized) {
            this.notifyIdChangeListener(oldId, this.mAdInfo);
        }
        this.initialized = true;
        this.reportInitializationComplete();
    }

    public void setIdChangeListener(@Nullable AdvertisingIdChangeListener idChangeListener) {
        this.mIdChangeListener = idChangeListener;
    }

    void setInitializationListener(@Nullable SdkInitializationListener initializationListener) {
        this.mInitializationListener = initializationListener;
        if (this.initialized) {
            this.reportInitializationComplete();
        }
    }

    private synchronized void reportInitializationComplete() {
        SdkInitializationListener listener = this.mInitializationListener;
        if (listener != null) {
            this.mInitializationListener = null;
            listener.onInitializationFinished();
        }
    }

    private void notifyIdChangeListener(@NonNull AdvertisingId oldId, @NonNull AdvertisingId newId) {
        Preconditions.checkNotNull(newId);
        if (this.mIdChangeListener != null) {
            this.mIdChangeListener.onIdChanged(oldId, newId);
        }
    }

    @Nullable
    private AdvertisingId getAmazonAdvertisingInfo(@NonNull Context context) {
        Preconditions.NoThrow.checkNotNull(context);
        ContentResolver resolver = context.getContentResolver();
        int limitAdTracking = Settings.Secure.getInt((ContentResolver)resolver, (String)"limit_ad_tracking", (int)-1);
        String advertisingId = Settings.Secure.getString((ContentResolver)resolver, (String)"advertising_id");
        if (limitAdTracking != -1 && !TextUtils.isEmpty((CharSequence)advertisingId)) {
            boolean doNotTrack = limitAdTracking != 0;
            AdvertisingId oldId = this.mAdInfo;
            return new AdvertisingId(advertisingId, oldId.mMopubId, doNotTrack);
        }
        return null;
    }

    private class RefreshAdvertisingInfoAsyncTask
    extends AsyncTask<Void, Void, Void> {
        private RefreshAdvertisingInfoAsyncTask() {
        }

        protected Void doInBackground(Void ... voids) {
            MoPubIdentifier.this.refreshAdvertisingInfoBackgroundThread();
            MoPubIdentifier.this.mRefreshingAdvertisingInfo = false;
            return null;
        }
    }

    public static interface AdvertisingIdChangeListener {
        public void onIdChanged(@NonNull AdvertisingId var1, @NonNull AdvertisingId var2);
    }
}

