/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.privacy;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.ClientMetadata;
import com.mopub.common.Preconditions;
import com.mopub.common.SharedPreferencesHelper;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.privacy.ConsentData;
import com.mopub.common.privacy.ConsentStatus;
import java.util.Locale;

class PersonalInfoData
implements ConsentData {
    private static final String PERSONAL_INFO_DATA_SHARED_PREFS = "com.mopub.privacy";
    private static final String PERSONAL_INFO_PREFIX = "info/";
    private static final String AD_UNIT_ID_SP_KEY = "info/adunit";
    private static final String CACHED_LAST_AD_UNIT_ID_USED_FOR_INIT_SP_KEY = "info/cached_last_ad_unit_id_used_for_init";
    private static final String CONSENT_STATUS_SP_KEY = "info/consent_status";
    private static final String LAST_SUCCESSFULLY_SYNCED_CONSENT_STATUS_SP_KEY = "info/last_successfully_synced_consent_status";
    private static final String IS_WHITELISTED_SP_KEY = "info/is_whitelisted";
    private static final String CURRENT_VENDOR_LIST_VERSION_SP_KEY = "info/current_vendor_list_version";
    private static final String CURRENT_VENDOR_LIST_LINK_SP_KEY = "info/current_vendor_list_link";
    private static final String CURRENT_PRIVACY_POLICY_VERSION_SP_KEY = "info/current_privacy_policy_version";
    private static final String CURRENT_PRIVACY_POLICY_LINK_SP_KEY = "info/current_privacy_policy_link";
    private static final String CURRENT_VENDOR_LIST_IAB_FORMAT_SP_KEY = "info/current_vendor_list_iab_format";
    private static final String CURRENT_VENDOR_LIST_IAB_HASH_SP_KEY = "info/current_vendor_list_iab_hash";
    private static final String CONSENTED_VENDOR_LIST_VERSION_SP_KEY = "info/consented_vendor_list_version";
    private static final String CONSENTED_PRIVACY_POLICY_VERSION_SP_KEY = "info/consented_privacy_policy_version";
    private static final String CONSENTED_VENDOR_LIST_IAB_FORMAT_SP_KEY = "info/consented_vendor_list_iab_format";
    private static final String EXTRAS_SP_KEY = "info/extras";
    private static final String CONSENT_CHANGE_REASON_SP_KEY = "info/consent_change_reason";
    private static final String REACQUIRE_CONSENT_SP_KEY = "info/reacquire_consent";
    private static final String GDPR_APPLIES_SP_KEY = "info/gdpr_applies";
    private static final String FORCE_GDPR_APPLIES_SP_KEY = "info/force_gdpr_applies";
    @Deprecated
    private static final String UDID_SP_KEY = "info/udid";
    private static final String IFA_SP_KEY = "info/ifa";
    private static final String LAST_CHANGED_MS_SP_KEY = "info/last_changed_ms";
    private static final String CONSENT_STATUS_BEFORE_DNT_SP_KEY = "info/consent_status_before_dnt";
    private static final String LANGUAGE_MACRO_KEY = "%%LANGUAGE%%";
    @NonNull
    private final Context mAppContext;
    @NonNull
    private String mAdUnitId;
    @Nullable
    private String mCachedLastAdUnitIdUsedForInit;
    @NonNull
    private ConsentStatus mConsentStatus;
    @Nullable
    private ConsentStatus mLastSuccessfullySyncedConsentStatus;
    @Nullable
    private String mConsentChangeReason;
    private boolean mForceGdprApplies;
    @Nullable
    private String mIfa;
    @Nullable
    private String mLastChangedMs;
    @Nullable
    private ConsentStatus mConsentStatusBeforeDnt;
    private boolean mIsWhitelisted;
    @Nullable
    private String mCurrentVendorListVersion;
    @Nullable
    private String mCurrentVendorListLink;
    @Nullable
    private String mCurrentPrivacyPolicyVersion;
    @Nullable
    private String mCurrentPrivacyPolicyLink;
    @Nullable
    private String mCurrentVendorListIabFormat;
    @Nullable
    private String mCurrentVendorListIabHash;
    @Nullable
    private String mConsentedVendorListVersion;
    @Nullable
    private String mConsentedPrivacyPolicyVersion;
    @Nullable
    private String mConsentedVendorListIabFormat;
    @Nullable
    private String mExtras;
    private boolean mReacquireConsent;
    @Nullable
    private Boolean mGdprApplies;

    PersonalInfoData(@NonNull Context context) {
        Preconditions.checkNotNull(context);
        this.mAppContext = context.getApplicationContext();
        this.mConsentStatus = ConsentStatus.UNKNOWN;
        this.mAdUnitId = "";
        this.getStateFromDisk();
    }

    private void getStateFromDisk() {
        SharedPreferences sharedPreferences = SharedPreferencesHelper.getSharedPreferences(this.mAppContext, PERSONAL_INFO_DATA_SHARED_PREFS);
        this.mAdUnitId = sharedPreferences.getString(AD_UNIT_ID_SP_KEY, "");
        this.mCachedLastAdUnitIdUsedForInit = sharedPreferences.getString(CACHED_LAST_AD_UNIT_ID_USED_FOR_INIT_SP_KEY, null);
        this.mConsentStatus = ConsentStatus.fromString(sharedPreferences.getString(CONSENT_STATUS_SP_KEY, ConsentStatus.UNKNOWN.name()));
        String lastSuccessfullySyncedConsentStatusString = sharedPreferences.getString(LAST_SUCCESSFULLY_SYNCED_CONSENT_STATUS_SP_KEY, null);
        this.mLastSuccessfullySyncedConsentStatus = TextUtils.isEmpty((CharSequence)lastSuccessfullySyncedConsentStatusString) ? null : ConsentStatus.fromString(lastSuccessfullySyncedConsentStatusString);
        this.mIsWhitelisted = sharedPreferences.getBoolean(IS_WHITELISTED_SP_KEY, false);
        this.mCurrentVendorListVersion = sharedPreferences.getString(CURRENT_VENDOR_LIST_VERSION_SP_KEY, null);
        this.mCurrentVendorListLink = sharedPreferences.getString(CURRENT_VENDOR_LIST_LINK_SP_KEY, null);
        this.mCurrentPrivacyPolicyVersion = sharedPreferences.getString(CURRENT_PRIVACY_POLICY_VERSION_SP_KEY, null);
        this.mCurrentPrivacyPolicyLink = sharedPreferences.getString(CURRENT_PRIVACY_POLICY_LINK_SP_KEY, null);
        this.mCurrentVendorListIabFormat = sharedPreferences.getString(CURRENT_VENDOR_LIST_IAB_FORMAT_SP_KEY, null);
        this.mCurrentVendorListIabHash = sharedPreferences.getString(CURRENT_VENDOR_LIST_IAB_HASH_SP_KEY, null);
        this.mConsentedVendorListVersion = sharedPreferences.getString(CONSENTED_VENDOR_LIST_VERSION_SP_KEY, null);
        this.mConsentedPrivacyPolicyVersion = sharedPreferences.getString(CONSENTED_PRIVACY_POLICY_VERSION_SP_KEY, null);
        this.mConsentedVendorListIabFormat = sharedPreferences.getString(CONSENTED_VENDOR_LIST_IAB_FORMAT_SP_KEY, null);
        this.mExtras = sharedPreferences.getString(EXTRAS_SP_KEY, null);
        this.mConsentChangeReason = sharedPreferences.getString(CONSENT_CHANGE_REASON_SP_KEY, null);
        this.mReacquireConsent = sharedPreferences.getBoolean(REACQUIRE_CONSENT_SP_KEY, false);
        String gdprAppliesString = sharedPreferences.getString(GDPR_APPLIES_SP_KEY, null);
        this.mGdprApplies = TextUtils.isEmpty((CharSequence)gdprAppliesString) ? null : Boolean.valueOf(Boolean.parseBoolean(gdprAppliesString));
        this.mForceGdprApplies = sharedPreferences.getBoolean(FORCE_GDPR_APPLIES_SP_KEY, false);
        String udid = sharedPreferences.getString(UDID_SP_KEY, null);
        if (!TextUtils.isEmpty((CharSequence)udid)) {
            this.mIfa = udid.replace("ifa:", "");
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(IFA_SP_KEY, this.mIfa);
            editor.remove(UDID_SP_KEY);
            editor.apply();
        } else {
            this.mIfa = sharedPreferences.getString(IFA_SP_KEY, null);
        }
        this.mLastChangedMs = sharedPreferences.getString(LAST_CHANGED_MS_SP_KEY, null);
        String consentStatusBeforeDnt = sharedPreferences.getString(CONSENT_STATUS_BEFORE_DNT_SP_KEY, null);
        this.mConsentStatusBeforeDnt = TextUtils.isEmpty((CharSequence)consentStatusBeforeDnt) ? null : ConsentStatus.fromString(consentStatusBeforeDnt);
    }

    void writeToDisk() {
        SharedPreferences.Editor editor = SharedPreferencesHelper.getSharedPreferences(this.mAppContext, PERSONAL_INFO_DATA_SHARED_PREFS).edit();
        editor.putString(AD_UNIT_ID_SP_KEY, this.mAdUnitId);
        editor.putString(CACHED_LAST_AD_UNIT_ID_USED_FOR_INIT_SP_KEY, this.mCachedLastAdUnitIdUsedForInit);
        editor.putString(CONSENT_STATUS_SP_KEY, this.mConsentStatus.name());
        editor.putString(LAST_SUCCESSFULLY_SYNCED_CONSENT_STATUS_SP_KEY, this.mLastSuccessfullySyncedConsentStatus == null ? null : this.mLastSuccessfullySyncedConsentStatus.name());
        editor.putBoolean(IS_WHITELISTED_SP_KEY, this.mIsWhitelisted);
        editor.putString(CURRENT_VENDOR_LIST_VERSION_SP_KEY, this.mCurrentVendorListVersion);
        editor.putString(CURRENT_VENDOR_LIST_LINK_SP_KEY, this.mCurrentVendorListLink);
        editor.putString(CURRENT_PRIVACY_POLICY_VERSION_SP_KEY, this.mCurrentPrivacyPolicyVersion);
        editor.putString(CURRENT_PRIVACY_POLICY_LINK_SP_KEY, this.mCurrentPrivacyPolicyLink);
        editor.putString(CURRENT_VENDOR_LIST_IAB_FORMAT_SP_KEY, this.mCurrentVendorListIabFormat);
        editor.putString(CURRENT_VENDOR_LIST_IAB_HASH_SP_KEY, this.mCurrentVendorListIabHash);
        editor.putString(CONSENTED_VENDOR_LIST_VERSION_SP_KEY, this.mConsentedVendorListVersion);
        editor.putString(CONSENTED_PRIVACY_POLICY_VERSION_SP_KEY, this.mConsentedPrivacyPolicyVersion);
        editor.putString(CONSENTED_VENDOR_LIST_IAB_FORMAT_SP_KEY, this.mConsentedVendorListIabFormat);
        editor.putString(EXTRAS_SP_KEY, this.mExtras);
        editor.putString(CONSENT_CHANGE_REASON_SP_KEY, this.mConsentChangeReason);
        editor.putBoolean(REACQUIRE_CONSENT_SP_KEY, this.mReacquireConsent);
        editor.putString(GDPR_APPLIES_SP_KEY, this.mGdprApplies == null ? null : this.mGdprApplies.toString());
        editor.putBoolean(FORCE_GDPR_APPLIES_SP_KEY, this.mForceGdprApplies);
        editor.putString(IFA_SP_KEY, this.mIfa);
        editor.putString(LAST_CHANGED_MS_SP_KEY, this.mLastChangedMs);
        editor.putString(CONSENT_STATUS_BEFORE_DNT_SP_KEY, this.mConsentStatusBeforeDnt == null ? null : this.mConsentStatusBeforeDnt.name());
        editor.apply();
    }

    @NonNull
    String getAdUnitId() {
        return this.mAdUnitId;
    }

    void setAdUnit(@NonNull String adUnitId) {
        this.mAdUnitId = adUnitId;
    }

    @Nullable
    String getCachedLastAdUnitIdUsedForInit() {
        return this.mCachedLastAdUnitIdUsedForInit;
    }

    void setCachedLastAdUnitIdUsedForInit(@NonNull String adUnitId) {
        this.mCachedLastAdUnitIdUsedForInit = adUnitId;
    }

    @Override
    @Nullable
    public String chooseAdUnit() {
        String adUnitId = this.mAdUnitId;
        if (!TextUtils.isEmpty((CharSequence)adUnitId)) {
            return adUnitId;
        }
        return this.mCachedLastAdUnitIdUsedForInit;
    }

    @NonNull
    ConsentStatus getConsentStatus() {
        return this.mConsentStatus;
    }

    void setConsentStatus(@NonNull ConsentStatus consentStatus) {
        this.mConsentStatus = consentStatus;
    }

    @Nullable
    ConsentStatus getLastSuccessfullySyncedConsentStatus() {
        return this.mLastSuccessfullySyncedConsentStatus;
    }

    void setLastSuccessfullySyncedConsentStatus(@Nullable ConsentStatus lastSuccessfullySyncedConsentStatus) {
        this.mLastSuccessfullySyncedConsentStatus = lastSuccessfullySyncedConsentStatus;
    }

    boolean isWhitelisted() {
        return this.mIsWhitelisted;
    }

    void setWhitelisted(boolean whitelisted) {
        this.mIsWhitelisted = whitelisted;
    }

    @Override
    @Nullable
    public String getCurrentVendorListVersion() {
        return this.mCurrentVendorListVersion;
    }

    void setCurrentVendorListVersion(@Nullable String currentVendorListVersion) {
        this.mCurrentVendorListVersion = currentVendorListVersion;
    }

    @Override
    @NonNull
    public String getCurrentVendorListLink() {
        return this.getCurrentVendorListLink(null);
    }

    @Override
    @NonNull
    public String getCurrentVendorListLink(@Nullable String language) {
        return PersonalInfoData.replaceLanguageMacro(this.mCurrentVendorListLink, this.mAppContext, language);
    }

    void setCurrentVendorListLink(@Nullable String currentVendorListLink) {
        this.mCurrentVendorListLink = currentVendorListLink;
    }

    @Override
    @Nullable
    public String getCurrentPrivacyPolicyVersion() {
        return this.mCurrentPrivacyPolicyVersion;
    }

    void setCurrentPrivacyPolicyVersion(@Nullable String currentPrivacyPolicyVersion) {
        this.mCurrentPrivacyPolicyVersion = currentPrivacyPolicyVersion;
    }

    @Override
    @NonNull
    public String getCurrentPrivacyPolicyLink() {
        return this.getCurrentPrivacyPolicyLink(null);
    }

    @Override
    @NonNull
    public String getCurrentPrivacyPolicyLink(@Nullable String language) {
        return PersonalInfoData.replaceLanguageMacro(this.mCurrentPrivacyPolicyLink, this.mAppContext, language);
    }

    void setCurrentPrivacyPolicyLink(@Nullable String currentPrivacyPolicyLink) {
        this.mCurrentPrivacyPolicyLink = currentPrivacyPolicyLink;
    }

    @Override
    @Nullable
    public String getCurrentVendorListIabFormat() {
        return this.mCurrentVendorListIabFormat;
    }

    void setCurrentVendorListIabFormat(@Nullable String currentVendorListIabFormat) {
        this.mCurrentVendorListIabFormat = currentVendorListIabFormat;
    }

    @Nullable
    String getCurrentVendorListIabHash() {
        return this.mCurrentVendorListIabHash;
    }

    void setCurrentVendorListIabHash(@Nullable String currentVendorListIabHash) {
        this.mCurrentVendorListIabHash = currentVendorListIabHash;
    }

    @Override
    @Nullable
    public String getConsentedVendorListVersion() {
        return this.mConsentedVendorListVersion;
    }

    void setConsentedVendorListVersion(@Nullable String consentedVendorListVersion) {
        this.mConsentedVendorListVersion = consentedVendorListVersion;
    }

    @Override
    @Nullable
    public String getConsentedPrivacyPolicyVersion() {
        return this.mConsentedPrivacyPolicyVersion;
    }

    void setConsentedPrivacyPolicyVersion(@Nullable String consentedPrivacyPolicyVersion) {
        this.mConsentedPrivacyPolicyVersion = consentedPrivacyPolicyVersion;
    }

    @Override
    @Nullable
    public String getConsentedVendorListIabFormat() {
        return this.mConsentedVendorListIabFormat;
    }

    void setConsentedVendorListIabFormat(@Nullable String consentedVendorListIabFormat) {
        this.mConsentedVendorListIabFormat = consentedVendorListIabFormat;
    }

    @Nullable
    public String getExtras() {
        return this.mExtras;
    }

    public void setExtras(@Nullable String extras) {
        this.mExtras = extras;
    }

    @Nullable
    String getConsentChangeReason() {
        return this.mConsentChangeReason;
    }

    void setConsentChangeReason(@Nullable String consentChangeReason) {
        this.mConsentChangeReason = consentChangeReason;
    }

    boolean shouldReacquireConsent() {
        return this.mReacquireConsent;
    }

    void setShouldReacquireConsent(boolean reacquireConsent) {
        this.mReacquireConsent = reacquireConsent;
    }

    @Nullable
    Boolean getGdprApplies() {
        return this.mGdprApplies;
    }

    void setGdprApplies(@Nullable Boolean gdprApplies) {
        this.mGdprApplies = gdprApplies;
    }

    @Override
    public boolean isForceGdprApplies() {
        return this.mForceGdprApplies;
    }

    void setForceGdprApplies(boolean forceGdprApplies) {
        this.mForceGdprApplies = forceGdprApplies;
    }

    @Nullable
    String getIfa() {
        return this.mIfa;
    }

    void setIfa(@Nullable String ifa) {
        this.mIfa = ifa;
    }

    @Nullable
    String getLastChangedMs() {
        return this.mLastChangedMs;
    }

    void setLastChangedMs(@Nullable String lastChangedMs) {
        this.mLastChangedMs = lastChangedMs;
    }

    @Nullable
    ConsentStatus getConsentStatusBeforeDnt() {
        return this.mConsentStatusBeforeDnt;
    }

    void setConsentStatusBeforeDnt(@Nullable ConsentStatus consentStatusBeforeDnt) {
        this.mConsentStatusBeforeDnt = consentStatusBeforeDnt;
    }

    @VisibleForTesting
    @NonNull
    static String replaceLanguageMacro(@Nullable String input, @NonNull Context context, @Nullable String language) {
        Preconditions.checkNotNull(context);
        if (TextUtils.isEmpty((CharSequence)input)) {
            return "";
        }
        return input.replaceAll(LANGUAGE_MACRO_KEY, PersonalInfoData.validateLanguage(context, language));
    }

    @NonNull
    private static String validateLanguage(@NonNull Context context, @Nullable String language) {
        Preconditions.checkNotNull(context);
        for (String isoLanguage : Locale.getISOLanguages()) {
            if (isoLanguage == null || !isoLanguage.equals(language)) continue;
            return language;
        }
        return ClientMetadata.getCurrentLanguage(context);
    }
}

