/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.privacy;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.privacy.PrivacyKey;
import com.mopub.common.privacy.SyncResponse;
import com.mopub.network.MoPubNetworkError;
import com.mopub.network.MoPubRequest;
import com.mopub.volley.Cache;
import com.mopub.volley.DefaultRetryPolicy;
import com.mopub.volley.NetworkResponse;
import com.mopub.volley.Response;
import com.mopub.volley.RetryPolicy;
import com.mopub.volley.VolleyError;
import com.mopub.volley.toolbox.HttpHeaderParser;
import org.json.JSONException;
import org.json.JSONObject;

public class SyncRequest
extends MoPubRequest<SyncResponse> {
    @Nullable
    private Listener mListener;

    public SyncRequest(@NonNull Context context, @NonNull String url, @Nullable Listener listener) {
        super(context, url, listener);
        this.mListener = listener;
        DefaultRetryPolicy retryPolicy = new DefaultRetryPolicy(2500, 0, 1.0f);
        this.setRetryPolicy((RetryPolicy)retryPolicy);
        this.setShouldCache(false);
    }

    protected Response<SyncResponse> parseNetworkResponse(NetworkResponse networkResponse) {
        SyncResponse.Builder builder = new SyncResponse.Builder();
        String responseBody = this.parseStringBody(networkResponse);
        try {
            JSONObject jsonBody = new JSONObject(responseBody);
            builder.setIsGdprRegion(jsonBody.getString(PrivacyKey.IS_GDPR_REGION.getKey())).setForceExplicitNo(jsonBody.optString(PrivacyKey.FORCE_EXPLICIT_NO.getKey())).setInvalidateConsent(jsonBody.optString(PrivacyKey.INVALIDATE_CONSENT.getKey())).setReacquireConsent(jsonBody.optString(PrivacyKey.REACQUIRE_CONSENT.getKey())).setIsWhitelisted(jsonBody.getString(PrivacyKey.IS_WHITELISTED.getKey())).setForceGdprApplies(jsonBody.optString(PrivacyKey.FORCE_GDPR_APPLIES.getKey())).setCurrentVendorListVersion(jsonBody.getString(PrivacyKey.CURRENT_VENDOR_LIST_VERSION.getKey())).setCurrentVendorListLink(jsonBody.getString(PrivacyKey.CURRENT_VENDOR_LIST_LINK.getKey())).setCurrentPrivacyPolicyLink(jsonBody.getString(PrivacyKey.CURRENT_PRIVACY_POLICY_LINK.getKey())).setCurrentPrivacyPolicyVersion(jsonBody.getString(PrivacyKey.CURRENT_PRIVACY_POLICY_VERSION.getKey())).setCurrentVendorListIabFormat(jsonBody.optString(PrivacyKey.CURRENT_VENDOR_LIST_IAB_FORMAT.getKey())).setCurrentVendorListIabHash(jsonBody.getString(PrivacyKey.CURRENT_VENDOR_LIST_IAB_HASH.getKey())).setCallAgainAfterSecs(jsonBody.optString(PrivacyKey.CALL_AGAIN_AFTER_SECS.getKey())).setExtras(jsonBody.optString(PrivacyKey.EXTRAS.getKey())).setConsentChangeReason(jsonBody.optString(PrivacyKey.CONSENT_CHANGE_REASON.getKey()));
        }
        catch (JSONException e) {
            return Response.error((VolleyError)new MoPubNetworkError("Unable to parse sync request network response.", MoPubNetworkError.Reason.BAD_BODY, null));
        }
        return Response.success((Object)builder.build(), (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)networkResponse));
    }

    protected void deliverResponse(SyncResponse syncResponse) {
        if (this.mListener != null) {
            this.mListener.onSuccess(syncResponse);
        }
    }

    public static interface Listener
    extends Response.ErrorListener {
        public void onSuccess(SyncResponse var1);
    }
}

