/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.util;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.StatFs;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.mopub.common.CreativeOrientation;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Reflection;
import com.mopub.common.util.Utils;
import java.io.File;
import java.net.SocketException;

public class DeviceUtils {
    private static final int MAX_MEMORY_CACHE_SIZE = 0x1E00000;
    private static final int MIN_DISK_CACHE_SIZE = 0x1E00000;
    private static final int MAX_DISK_CACHE_SIZE = 0x6400000;

    private DeviceUtils() {
    }

    public static boolean isNetworkAvailable(@Nullable Context context) {
        if (context == null) {
            return false;
        }
        if (!DeviceUtils.isPermissionGranted(context, "android.permission.INTERNET")) {
            return false;
        }
        if (!DeviceUtils.isPermissionGranted(context, "android.permission.ACCESS_NETWORK_STATE")) {
            return true;
        }
        try {
            ConnectivityManager connnectionManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connnectionManager.getActiveNetworkInfo();
            return networkInfo.isConnected();
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public static int memoryCacheSizeBytes(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        long memoryClass = activityManager.getMemoryClass();
        try {
            int flagLargeHeap = ApplicationInfo.class.getDeclaredField("FLAG_LARGE_HEAP").getInt(null);
            if (Utils.bitMaskContainsFlag(context.getApplicationInfo().flags, flagLargeHeap)) {
                memoryClass = ((Integer)new Reflection.MethodBuilder(activityManager, "getLargeMemoryClass").execute()).intValue();
            }
        }
        catch (Exception e) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Unable to reflectively determine large heap size.");
        }
        long result = Math.min(0x1E00000L, memoryClass / 8L * 1024L * 1024L);
        return (int)result;
    }

    public static long diskCacheSizeBytes(File dir, long minSize) {
        long size = minSize;
        try {
            StatFs statFs = new StatFs(dir.getAbsolutePath());
            long availableBytes = (long)statFs.getBlockCount() * (long)statFs.getBlockSize();
            size = availableBytes / 50L;
        }
        catch (IllegalArgumentException e) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Unable to calculate 2% of available disk space, defaulting to minimum");
        }
        return Math.max(Math.min(size, 0x6400000L), 0x1E00000L);
    }

    public static long diskCacheSizeBytes(File dir) {
        return DeviceUtils.diskCacheSizeBytes(dir, 0x1E00000L);
    }

    public static int getScreenOrientation(@NonNull Activity activity) {
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        int deviceOrientation = activity.getResources().getConfiguration().orientation;
        return DeviceUtils.getScreenOrientationFromRotationAndOrientation(rotation, deviceOrientation);
    }

    static int getScreenOrientationFromRotationAndOrientation(int rotation, int orientation) {
        if (1 == orientation) {
            switch (rotation) {
                case 1: 
                case 2: {
                    return 9;
                }
            }
            return 1;
        }
        if (2 == orientation) {
            switch (rotation) {
                case 2: 
                case 3: {
                    return 8;
                }
            }
            return 0;
        }
        MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Unknown screen orientation. Defaulting to portrait.");
        return 9;
    }

    public static void lockOrientation(@NonNull Activity activity, @NonNull CreativeOrientation creativeOrientation) {
        int requestedOrientation;
        if (!Preconditions.NoThrow.checkNotNull((Object)creativeOrientation) || !Preconditions.NoThrow.checkNotNull(activity)) {
            return;
        }
        Display display = ((WindowManager)activity.getSystemService("window")).getDefaultDisplay();
        int currentRotation = display.getRotation();
        int deviceOrientation = activity.getResources().getConfiguration().orientation;
        int currentOrientation = DeviceUtils.getScreenOrientationFromRotationAndOrientation(currentRotation, deviceOrientation);
        if (CreativeOrientation.PORTRAIT == creativeOrientation) {
            requestedOrientation = 9 == currentOrientation ? 9 : 1;
        } else if (CreativeOrientation.LANDSCAPE == creativeOrientation) {
            requestedOrientation = 8 == currentOrientation ? 8 : 0;
        } else {
            return;
        }
        activity.setRequestedOrientation(requestedOrientation);
    }

    @NonNull
    public static Point getDeviceDimensions(@NonNull Context context) {
        Integer bestWidthPixels = null;
        Integer bestHeightPixels = null;
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        if (windowManager != null) {
            Display display = windowManager.getDefaultDisplay();
            Point screenSize = new Point();
            display.getRealSize(screenSize);
            bestWidthPixels = screenSize.x;
            bestHeightPixels = screenSize.y;
        }
        if (bestWidthPixels == null) {
            DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
            bestWidthPixels = displayMetrics.widthPixels;
            bestHeightPixels = displayMetrics.heightPixels;
        }
        return new Point(bestWidthPixels.intValue(), bestHeightPixels.intValue());
    }

    public static boolean isPermissionGranted(@NonNull Context context, @NonNull String permission2) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(permission2);
        try {
            return ContextCompat.checkSelfPermission((Context)context, (String)permission2) == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Deprecated
    @Nullable
    public static String getIpAddress(IP ip) throws SocketException {
        return null;
    }

    @Deprecated
    @Nullable
    public static String getHashedUdid(Context context) {
        return null;
    }

    @Deprecated
    public static enum IP {
        IPv4,
        IPv6;

    }

    public static enum ForceOrientation {
        FORCE_PORTRAIT("portrait"),
        FORCE_LANDSCAPE("landscape"),
        DEVICE_ORIENTATION("device"),
        UNDEFINED("");

        @NonNull
        private final String mKey;

        private ForceOrientation(String key) {
            this.mKey = key;
        }

        @NonNull
        public static ForceOrientation getForceOrientation(@Nullable String key) {
            for (ForceOrientation orientation : ForceOrientation.values()) {
                if (!orientation.mKey.equalsIgnoreCase(key)) continue;
                return orientation;
            }
            return UNDEFINED;
        }
    }
}

