/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.util;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import androidx.annotation.NonNull;
import com.mopub.common.Preconditions;

public class Dips {
    public static float pixelsToFloatDips(float pixels, @NonNull Context context) {
        Preconditions.checkNotNull(context);
        return pixels / Dips.getDensity(context);
    }

    public static int pixelsToIntDips(float pixels, @NonNull Context context) {
        Preconditions.checkNotNull(context);
        return (int)(Dips.pixelsToFloatDips(pixels, context) + 0.5f);
    }

    public static float dipsToFloatPixels(float dips, @NonNull Context context) {
        Preconditions.checkNotNull(context);
        return dips * Dips.getDensity(context);
    }

    public static int dipsToIntPixels(float dips, @NonNull Context context) {
        Preconditions.checkNotNull(context);
        return (int)(Dips.dipsToFloatPixels(dips, context) + 0.5f);
    }

    private static float getDensity(@NonNull Context context) {
        Preconditions.checkNotNull(context);
        return context.getResources().getDisplayMetrics().density;
    }

    public static float asFloatPixels(float dips, @NonNull Context context) {
        Preconditions.checkNotNull(context);
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return TypedValue.applyDimension((int)1, (float)dips, (DisplayMetrics)displayMetrics);
    }

    public static int asIntPixels(float dips, @NonNull Context context) {
        Preconditions.checkNotNull(context);
        return (int)(Dips.asFloatPixels(dips, context) + 0.5f);
    }

    public static int screenWidthAsIntDips(@NonNull Context context) {
        Preconditions.checkNotNull(context);
        return Dips.pixelsToIntDips(context.getResources().getDisplayMetrics().widthPixels, context);
    }

    public static int screenHeightAsIntDips(@NonNull Context context) {
        Preconditions.checkNotNull(context);
        return Dips.pixelsToIntDips(context.getResources().getDisplayMetrics().heightPixels, context);
    }
}

