/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.util;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.MoPub;
import com.mopub.common.MoPubBrowser;
import com.mopub.common.Preconditions;
import com.mopub.common.UrlAction;
import com.mopub.common.logging.MoPubLog;
import com.mopub.exceptions.IntentNotResolvableException;
import com.mopub.exceptions.UrlParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Intents {
    private static final Map<String, String> STORE_SCHEME_TO_URL_MAP;

    private Intents() {
    }

    public static void startActivity(@NonNull Context context, @NonNull Intent intent) throws IntentNotResolvableException {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(intent);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        try {
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            throw new IntentNotResolvableException(e);
        }
    }

    public static Intent getStartActivityIntent(@NonNull Context context, @NonNull Class clazz, @Nullable Bundle extras) {
        Intent intent = new Intent(context, clazz);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        if (extras != null) {
            intent.putExtras(extras);
        }
        return intent;
    }

    public static boolean deviceCanHandleIntent(@NonNull Context context, @NonNull Intent intent) {
        try {
            PackageManager packageManager = context.getPackageManager();
            List activities = packageManager.queryIntentActivities(intent, 0);
            return !activities.isEmpty();
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public static Intent intentForNativeBrowserScheme(@NonNull Uri uri) throws UrlParseException {
        Preconditions.checkNotNull(uri);
        if (!UrlAction.OPEN_NATIVE_BROWSER.shouldTryHandlingUrl(uri)) {
            String supportedSchemes = "mopubnativebrowser://";
            if (MoPub.getBrowserAgent() == MoPub.BrowserAgent.NATIVE) {
                supportedSchemes = supportedSchemes + ", http://, or https://";
            }
            throw new UrlParseException("URI does not have " + supportedSchemes + " scheme.");
        }
        if ("mopubnativebrowser".equalsIgnoreCase(uri.getScheme())) {
            Uri intentUri = Intents.parseMoPubNativeBrowserUri(uri);
            return new Intent("android.intent.action.VIEW", intentUri);
        }
        if (MoPub.getBrowserAgent() == MoPub.BrowserAgent.NATIVE) {
            return new Intent("android.intent.action.VIEW", uri);
        }
        throw new UrlParseException("Invalid URI: " + uri.toString());
    }

    private static Uri parseMoPubNativeBrowserUri(@NonNull Uri uri) throws UrlParseException {
        String urlToOpenInNativeBrowser;
        Preconditions.checkNotNull(uri);
        if (!"navigate".equals(uri.getHost())) {
            throw new UrlParseException("URL missing 'navigate' host parameter.");
        }
        try {
            urlToOpenInNativeBrowser = uri.getQueryParameter("url");
        }
        catch (UnsupportedOperationException e) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Could not handle url: " + uri);
            throw new UrlParseException("Passed-in URL did not create a hierarchical URI.");
        }
        if (urlToOpenInNativeBrowser == null) {
            throw new UrlParseException("URL missing 'url' query parameter.");
        }
        return Uri.parse((String)urlToOpenInNativeBrowser);
    }

    public static Intent intentForShareTweet(@NonNull Uri uri) throws UrlParseException {
        String tweetId;
        String screenName;
        if (!UrlAction.HANDLE_SHARE_TWEET.shouldTryHandlingUrl(uri)) {
            throw new UrlParseException("URL does not have mopubshare://tweet? format.");
        }
        try {
            screenName = uri.getQueryParameter("screen_name");
            tweetId = uri.getQueryParameter("tweet_id");
        }
        catch (UnsupportedOperationException e) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Could not handle url: " + uri);
            throw new UrlParseException("Passed-in URL did not create a hierarchical URI.");
        }
        if (TextUtils.isEmpty((CharSequence)screenName)) {
            throw new UrlParseException("URL missing non-empty 'screen_name' query parameter.");
        }
        if (TextUtils.isEmpty((CharSequence)tweetId)) {
            throw new UrlParseException("URL missing non-empty 'tweet_id' query parameter.");
        }
        String tweetUrl = String.format("https://twitter.com/%s/status/%s", screenName, tweetId);
        String shareMessage = String.format("Check out @%s's Tweet: %s", screenName, tweetUrl);
        Intent shareTweetIntent = new Intent("android.intent.action.SEND");
        shareTweetIntent.setType("text/plain");
        shareTweetIntent.putExtra("android.intent.extra.SUBJECT", shareMessage);
        shareTweetIntent.putExtra("android.intent.extra.TEXT", shareMessage);
        return shareTweetIntent;
    }

    public static void showMoPubBrowserForUrl(@NonNull Context context, @NonNull Uri uri, @Nullable String dspCreativeId) throws IntentNotResolvableException {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(uri);
        MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Final URI to show in browser: " + uri);
        Bundle extras = new Bundle();
        extras.putString("URL", uri.toString());
        if (!TextUtils.isEmpty((CharSequence)dspCreativeId)) {
            extras.putString("mopub-dsp-creative-id", dspCreativeId);
        }
        Intent intent = Intents.getStartActivityIntent(context, MoPubBrowser.class, extras);
        String errorMessage = "Could not show MoPubBrowser for url: " + uri + "\n\tPerhaps you forgot to declare com.mopub.common.MoPubBrowser in your Android manifest file.";
        Intents.launchIntentForUserClick(context, intent, errorMessage);
    }

    public static void launchIntentForUserClick(@NonNull Context context, @NonNull Intent intent, @Nullable String errorMessage) throws IntentNotResolvableException {
        Preconditions.NoThrow.checkNotNull(context);
        Preconditions.NoThrow.checkNotNull(intent);
        try {
            Intents.startActivity(context, intent);
        }
        catch (IntentNotResolvableException e) {
            throw new IntentNotResolvableException(errorMessage + "\n" + e.getMessage());
        }
    }

    public static void launchApplicationUrl(@NonNull Context context, @NonNull Uri uri) throws IntentNotResolvableException {
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(uri);
        if (Intents.deviceCanHandleIntent(context, intent)) {
            Intents.launchApplicationIntent(context, intent);
        } else if (STORE_SCHEME_TO_URL_MAP.containsKey(intent.getScheme()) && intent.getData() != null && !TextUtils.isEmpty((CharSequence)intent.getData().getQuery())) {
            String storeBrowserUrl = String.format(STORE_SCHEME_TO_URL_MAP.get(intent.getScheme()), intent.getData().getQuery());
            Intent storeBrowserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)storeBrowserUrl));
            Intents.launchApplicationIntent(context, storeBrowserIntent);
        } else {
            throw new IntentNotResolvableException("Could not handle application specific action: " + uri + "\n\tYou may be running in the emulator or another device which does not have the required application.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void launchApplicationIntent(@NonNull Context context, @NonNull Intent intent) throws IntentNotResolvableException {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(intent);
        if (Intents.deviceCanHandleIntent(context, intent)) {
            String errorMessage = "Unable to open intent: " + intent;
            if (!(context instanceof Activity)) {
                intent.addFlags(0x10000000);
            }
            Intents.launchIntentForUserClick(context, intent, errorMessage);
            return;
        } else {
            String fallbackUrl = intent.getStringExtra("browser_fallback_url");
            if (TextUtils.isEmpty((CharSequence)fallbackUrl)) {
                if (STORE_SCHEME_TO_URL_MAP.containsKey(intent.getScheme())) throw new IntentNotResolvableException("Device could not handle neither intent nor market url.\nIntent: " + intent.toString());
                Intents.launchApplicationUrl(context, Intents.getPlayStoreUri(intent));
                return;
            } else {
                Uri fallbackUri = Uri.parse((String)fallbackUrl);
                String fallbackScheme = fallbackUri.getScheme();
                if ("http".equalsIgnoreCase(fallbackScheme) || "https".equalsIgnoreCase(fallbackScheme)) {
                    Intents.showMoPubBrowserForUrl(context, fallbackUri, null);
                    return;
                } else {
                    Intents.launchApplicationUrl(context, fallbackUri);
                }
            }
        }
    }

    @NonNull
    public static Uri getPlayStoreUri(@NonNull Intent intent) {
        Preconditions.checkNotNull(intent);
        return Uri.parse((String)("market://details?id=" + intent.getPackage()));
    }

    public static void launchActionViewIntent(@NonNull Context context, @NonNull Uri uri, @Nullable String errorMessage) throws IntentNotResolvableException {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(uri);
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        Intents.launchIntentForUserClick(context, intent, errorMessage);
    }

    @Deprecated
    public static boolean canHandleApplicationUrl(Context context, Uri uri) {
        return false;
    }

    @Deprecated
    public static boolean canHandleApplicationUrl(Context context, Uri uri, boolean logError) {
        return false;
    }

    static {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put("market", "https://play.google.com/store/apps/details?%s");
        tempMap.put("amzn", "http://www.amazon.com/gp/mas/dl/android?%s");
        STORE_SCHEME_TO_URL_MAP = Collections.unmodifiableMap(tempMap);
    }
}

