/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.widget.Toast;
import androidx.annotation.NonNull;
import com.mopub.common.MoPubBrowser;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.privacy.ConsentDialogActivity;
import com.mopub.common.util.Intents;
import com.mopub.common.util.Utils;
import java.util.ArrayList;
import java.util.List;

public class ManifestUtils {
    private static final String CONSENT_ACTIVITY = "com.mopub.common.privacy.ConsentDialogActivity";
    private static final String FULLSCREEN_ACTIVITY = "com.mopub.mobileads.MoPubFullscreenActivity";
    private static FlagCheckUtil sFlagCheckUtil = new FlagCheckUtil();
    private static final List<Class<? extends Activity>> REQUIRED_WEB_VIEW_SDK_ACTIVITIES = new ArrayList<Class<? extends Activity>>(1);
    private static final List<Class<? extends Activity>> REQUIRED_NATIVE_SDK_ACTIVITIES;
    private static final List<Class<? extends Activity>> REQUIRED_GDPR_ACTIVITIES;

    private ManifestUtils() {
    }

    public static void checkGdprActivitiesDeclared(@NonNull Context context) {
        if (!Preconditions.NoThrow.checkNotNull(context, "context is not allowed to be null")) {
            return;
        }
        ManifestUtils.displayWarningForMissingActivities(context, REQUIRED_GDPR_ACTIVITIES);
        ManifestUtils.displayWarningForMisconfiguredActivities(context, REQUIRED_GDPR_ACTIVITIES);
    }

    public static void checkWebViewActivitiesDeclared(@NonNull Context context) {
        if (!Preconditions.NoThrow.checkNotNull(context, "context is not allowed to be null")) {
            return;
        }
        ManifestUtils.displayWarningForMissingActivities(context, REQUIRED_WEB_VIEW_SDK_ACTIVITIES);
        ManifestUtils.displayWarningForMisconfiguredActivities(context, REQUIRED_WEB_VIEW_SDK_ACTIVITIES);
    }

    public static void checkNativeActivitiesDeclared(@NonNull Context context) {
        if (!Preconditions.NoThrow.checkNotNull(context, "context is not allowed to be null")) {
            return;
        }
        ManifestUtils.displayWarningForMissingActivities(context, REQUIRED_NATIVE_SDK_ACTIVITIES);
        ManifestUtils.displayWarningForMisconfiguredActivities(context, REQUIRED_NATIVE_SDK_ACTIVITIES);
    }

    @VisibleForTesting
    static void displayWarningForMissingActivities(@NonNull Context context, @NonNull List<Class<? extends Activity>> requiredActivities) {
        List<Class<? extends Activity>> undeclaredActivities = ManifestUtils.filterDeclaredActivities(context, requiredActivities, false);
        if (undeclaredActivities.isEmpty()) {
            return;
        }
        ManifestUtils.logWarningToast(context);
        ManifestUtils.logMissingActivities(undeclaredActivities);
    }

    @VisibleForTesting
    static void displayWarningForMisconfiguredActivities(@NonNull Context context, @NonNull List<Class<? extends Activity>> requiredActivities) {
        List<Class<? extends Activity>> declaredActivities = ManifestUtils.filterDeclaredActivities(context, requiredActivities, true);
        List<Class<? extends Activity>> misconfiguredActivities = ManifestUtils.getMisconfiguredActivities(context, declaredActivities);
        if (misconfiguredActivities.isEmpty()) {
            return;
        }
        ManifestUtils.logWarningToast(context);
        ManifestUtils.logMisconfiguredActivities(context, misconfiguredActivities);
    }

    public static boolean isDebuggable(@NonNull Context context) {
        int applicationFlags = context.getApplicationInfo().flags;
        return Utils.bitMaskContainsFlag(applicationFlags, 2);
    }

    private static List<Class<? extends Activity>> filterDeclaredActivities(@NonNull Context context, @NonNull List<Class<? extends Activity>> requiredActivities, boolean isDeclared) {
        ArrayList<Class<? extends Activity>> activities = new ArrayList<Class<? extends Activity>>();
        for (Class<? extends Activity> activityClass : requiredActivities) {
            Intent intent = new Intent(context, activityClass);
            if (Intents.deviceCanHandleIntent(context, intent) != isDeclared) continue;
            activities.add(activityClass);
        }
        return activities;
    }

    @TargetApi(value=13)
    private static List<Class<? extends Activity>> getMisconfiguredActivities(@NonNull Context context, @NonNull List<Class<? extends Activity>> activities) {
        ArrayList<Class<? extends Activity>> misconfiguredActivities = new ArrayList<Class<? extends Activity>>();
        for (Class<? extends Activity> activity : activities) {
            ActivityConfigChanges activityConfigChanges;
            try {
                activityConfigChanges = ManifestUtils.getActivityConfigChanges(context, activity);
            }
            catch (PackageManager.NameNotFoundException e) {
                continue;
            }
            if (activityConfigChanges.hasKeyboardHidden && activityConfigChanges.hasOrientation && activityConfigChanges.hasScreenSize) continue;
            misconfiguredActivities.add(activity);
        }
        return misconfiguredActivities;
    }

    private static void logMissingActivities(@NonNull List<Class<? extends Activity>> undeclaredActivities) {
        StringBuilder stringBuilder = new StringBuilder("AndroidManifest permissions for the following required MoPub activities are missing:\n");
        for (Class<? extends Activity> activity : undeclaredActivities) {
            stringBuilder.append("\n\t").append(activity.getName());
        }
        stringBuilder.append("\n\nPlease update your manifest to include them.");
        MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, stringBuilder.toString());
    }

    private static void logMisconfiguredActivities(@NonNull Context context, @NonNull List<Class<? extends Activity>> misconfiguredActivities) {
        StringBuilder stringBuilder = new StringBuilder("In AndroidManifest, the android:configChanges param is missing values for the following MoPub activities:\n");
        for (Class<? extends Activity> activity : misconfiguredActivities) {
            ActivityConfigChanges activityConfigChanges;
            try {
                activityConfigChanges = ManifestUtils.getActivityConfigChanges(context, activity);
            }
            catch (PackageManager.NameNotFoundException e) {
                continue;
            }
            if (!activityConfigChanges.hasKeyboardHidden) {
                stringBuilder.append("\n\tThe android:configChanges param for activity " + activity.getName() + " must include keyboardHidden.");
            }
            if (!activityConfigChanges.hasOrientation) {
                stringBuilder.append("\n\tThe android:configChanges param for activity " + activity.getName() + " must include orientation.");
            }
            if (activityConfigChanges.hasScreenSize) continue;
            stringBuilder.append("\n\tThe android:configChanges param for activity " + activity.getName() + " must include screenSize.");
        }
        stringBuilder.append("\n\nPlease update your manifest to include them.");
        MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, stringBuilder.toString());
    }

    private static ActivityConfigChanges getActivityConfigChanges(@NonNull Context context, @NonNull Class<? extends Activity> activity) throws PackageManager.NameNotFoundException {
        ActivityInfo activityInfo = context.getPackageManager().getActivityInfo(new ComponentName(context, activity.getName()), 0);
        ActivityConfigChanges activityConfigChanges = new ActivityConfigChanges();
        activityConfigChanges.hasKeyboardHidden = sFlagCheckUtil.hasFlag(activity, activityInfo.configChanges, 32);
        activityConfigChanges.hasOrientation = sFlagCheckUtil.hasFlag(activity, activityInfo.configChanges, 128);
        activityConfigChanges.hasScreenSize = true;
        activityConfigChanges.hasScreenSize = sFlagCheckUtil.hasFlag(activity, activityInfo.configChanges, 1024);
        return activityConfigChanges;
    }

    private static void logWarningToast(@NonNull Context context) {
        if (ManifestUtils.isDebuggable(context)) {
            String message = "ERROR: YOUR MOPUB INTEGRATION IS INCOMPLETE.\nCheck logcat and update your AndroidManifest.xml with the correct activities and configuration.";
            Context applicationContext = context.getApplicationContext();
            if (applicationContext != null) {
                Toast toast = Toast.makeText((Context)applicationContext, (CharSequence)"ERROR: YOUR MOPUB INTEGRATION IS INCOMPLETE.\nCheck logcat and update your AndroidManifest.xml with the correct activities and configuration.", (int)1);
                toast.setGravity(7, 0, 0);
                toast.show();
            }
        }
    }

    @Deprecated
    @VisibleForTesting
    static List<Class<? extends Activity>> getRequiredWebViewSdkActivities() {
        return REQUIRED_WEB_VIEW_SDK_ACTIVITIES;
    }

    @Deprecated
    @VisibleForTesting
    static List<Class<? extends Activity>> getRequiredNativeSdkActivities() {
        return REQUIRED_NATIVE_SDK_ACTIVITIES;
    }

    @Deprecated
    @VisibleForTesting
    static void setFlagCheckUtil(FlagCheckUtil flagCheckUtil) {
        sFlagCheckUtil = flagCheckUtil;
    }

    static {
        try {
            Class<?> moPubFullscreenActivity = Class.forName(FULLSCREEN_ACTIVITY);
            REQUIRED_WEB_VIEW_SDK_ACTIVITIES.add(moPubFullscreenActivity);
        }
        catch (ClassNotFoundException e) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "ManifestUtils running without interstitial module");
        }
        REQUIRED_WEB_VIEW_SDK_ACTIVITIES.add(MoPubBrowser.class);
        REQUIRED_NATIVE_SDK_ACTIVITIES = new ArrayList<Class<? extends Activity>>(1);
        REQUIRED_NATIVE_SDK_ACTIVITIES.add(MoPubBrowser.class);
        REQUIRED_GDPR_ACTIVITIES = new ArrayList<Class<? extends Activity>>(1);
        REQUIRED_GDPR_ACTIVITIES.add(ConsentDialogActivity.class);
    }

    static class FlagCheckUtil {
        FlagCheckUtil() {
        }

        public boolean hasFlag(Class clazz, int bitMask, int flag) {
            return Utils.bitMaskContainsFlag(bitMask, flag);
        }
    }

    private static class ActivityConfigChanges {
        public boolean hasKeyboardHidden;
        public boolean hasOrientation;
        public boolean hasScreenSize;

        private ActivityConfigChanges() {
        }
    }
}

