/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.MoPubReward;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.AdData;
import com.mopub.mobileads.AdLifecycleListener;
import com.mopub.mobileads.BaseAd;
import com.mopub.mobileads.MoPubAd;
import com.mopub.mobileads.MoPubErrorCode;
import org.jetbrains.annotations.NotNull;

public abstract class AdAdapter
implements AdLifecycleListener.LoadListener,
AdLifecycleListener.InteractionListener {
    @NonNull
    private final Handler mMainHandler;
    protected final Runnable mTimeout;
    @Nullable
    protected BaseAd mBaseAd;
    protected Context mContext;
    protected boolean mInvalidated;
    protected AdData mAdData;
    protected boolean mIsReady = false;
    @Nullable
    protected AdLifecycleListener.LoadListener mLoadListener;
    @Nullable
    protected AdLifecycleListener.InteractionListener mInteractionListener;

    abstract void show(@Nullable MoPubAd var1);

    abstract void doInvalidate();

    public AdAdapter(@NonNull Context context, @NonNull String className, @NonNull AdData adData) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(className);
        Preconditions.checkNotNull(adData);
        this.mContext = context;
        this.mMainHandler = new Handler(Looper.getMainLooper());
        this.mAdData = adData;
        this.mTimeout = () -> {
            MoPubLog.log(MoPubLog.AdLogEvent.CUSTOM_WITH_THROWABLE, "AdAdapter() failed", MoPubErrorCode.NETWORK_TIMEOUT);
            this.onAdLoadFailed(MoPubErrorCode.NETWORK_TIMEOUT);
            this.mMainHandler.post(this::invalidate);
        };
    }

    public final void load(@NonNull AdLifecycleListener.LoadListener loadListener) {
        Preconditions.checkNotNull(loadListener);
        MoPubLog.log(MoPubLog.AdLogEvent.LOAD_ATTEMPTED, new Object[0]);
        if (this.isInvalidated() || this.mBaseAd == null) {
            return;
        }
        this.mLoadListener = loadListener;
        this.mMainHandler.postDelayed(this.mTimeout, (long)this.getTimeoutDelayMilliseconds());
        try {
            this.mBaseAd.internalLoad(this.mContext, this, this.mAdData);
        }
        catch (Exception e) {
            MoPubLog.log(MoPubLog.AdLogEvent.LOAD_FAILED, MoPubErrorCode.INTERNAL_ERROR.getIntCode(), MoPubErrorCode.INTERNAL_ERROR);
            this.onAdLoadFailed(MoPubErrorCode.INTERNAL_ERROR);
        }
    }

    void invalidate() {
        this.doInvalidate();
        this.mBaseAd = null;
        this.mContext = null;
        this.mAdData = null;
        this.mLoadListener = null;
        this.mInteractionListener = null;
        this.mInvalidated = true;
        this.mIsReady = false;
    }

    public boolean isReady() {
        return this.mIsReady;
    }

    private int getTimeoutDelayMilliseconds() {
        return this.mAdData.getTimeoutDelayMillis();
    }

    @Nullable
    public String getBaseAdClassName() {
        return this.mBaseAd != null ? this.mBaseAd.getClass().getName() : null;
    }

    @VisibleForTesting
    protected void setLoadListener(@NonNull AdLifecycleListener.LoadListener loadListener) {
        Preconditions.checkNotNull(loadListener);
        this.mLoadListener = loadListener;
    }

    protected void setInteractionListener(@NonNull AdLifecycleListener.InteractionListener interactionListener) {
        Preconditions.checkNotNull(interactionListener);
        this.mInteractionListener = interactionListener;
    }

    boolean isInvalidated() {
        return this.mInvalidated;
    }

    private void cancelTimeout() {
        this.mMainHandler.removeCallbacks(this.mTimeout);
    }

    protected String getAdNetworkId() {
        return this.mBaseAd != null ? this.mBaseAd.getAdNetworkId() : "";
    }

    protected boolean isAutomaticImpressionAndClickTrackingEnabled() {
        BaseAd baseAd = this.mBaseAd;
        if (baseAd == null) {
            return true;
        }
        return baseAd.isAutomaticImpressionAndClickTrackingEnabled();
    }

    @Override
    public void onAdLoaded() {
        if (this.isInvalidated()) {
            return;
        }
        MoPubLog.log(MoPubLog.AdLogEvent.LOAD_SUCCESS, new Object[0]);
        this.mIsReady = true;
        this.cancelTimeout();
        this.mMainHandler.post(() -> {
            if (this.mLoadListener != null) {
                this.mLoadListener.onAdLoaded();
            }
        });
    }

    @Override
    public void onAdLoadFailed(@NotNull MoPubErrorCode errorCode) {
        Preconditions.checkNotNull(errorCode);
        if (this.isInvalidated()) {
            return;
        }
        this.cancelTimeout();
        this.mMainHandler.post(() -> {
            if (this.mLoadListener != null) {
                this.mLoadListener.onAdLoadFailed(errorCode);
            }
        });
    }

    @Override
    public void onAdFailed(@NotNull MoPubErrorCode errorCode) {
        Preconditions.checkNotNull(errorCode);
        if (this.isInvalidated()) {
            return;
        }
        this.cancelTimeout();
        this.mMainHandler.post(() -> {
            if (this.mInteractionListener != null) {
                this.mInteractionListener.onAdFailed(errorCode);
            }
        });
    }

    @Override
    public void onAdShown() {
        if (this.isInvalidated()) {
            return;
        }
        this.mMainHandler.post(() -> {
            BaseAd baseAd;
            if (this.mInteractionListener != null) {
                this.mInteractionListener.onAdShown();
            }
            if ((baseAd = this.mBaseAd) == null || baseAd.isAutomaticImpressionAndClickTrackingEnabled()) {
                if (this.mInteractionListener != null) {
                    this.mInteractionListener.onAdImpression();
                }
                if (baseAd != null) {
                    baseAd.trackMpxAndThirdPartyImpressions();
                }
            }
        });
    }

    @Override
    public void onAdClicked() {
        if (this.isInvalidated()) {
            return;
        }
        this.mMainHandler.post(() -> {
            if (this.mInteractionListener != null) {
                this.mInteractionListener.onAdClicked();
            }
        });
    }

    @Override
    public void onAdImpression() {
        if (this.isInvalidated()) {
            return;
        }
        this.mMainHandler.post(() -> {
            BaseAd baseAd = this.mBaseAd;
            if (baseAd != null && !baseAd.isAutomaticImpressionAndClickTrackingEnabled()) {
                if (this.mInteractionListener != null) {
                    this.mInteractionListener.onAdImpression();
                }
                baseAd.trackMpxAndThirdPartyImpressions();
            }
        });
    }

    @Override
    public void onAdDismissed() {
        if (this.isInvalidated()) {
            return;
        }
        this.mMainHandler.post(() -> {
            if (this.mInteractionListener != null) {
                this.mInteractionListener.onAdDismissed();
            }
        });
    }

    @Override
    public void onAdComplete(@Nullable MoPubReward moPubReward) {
        if (this.isInvalidated()) {
            return;
        }
        this.mMainHandler.post(() -> {
            if (this.mInteractionListener != null) {
                this.mInteractionListener.onAdComplete(moPubReward);
            }
        });
    }

    @Override
    public void onAdResumeAutoRefresh() {
        this.mMainHandler.post(() -> {
            if (this.mInteractionListener != null) {
                this.mInteractionListener.onAdResumeAutoRefresh();
            }
        });
    }

    @Override
    public void onAdPauseAutoRefresh() {
        this.mMainHandler.post(() -> {
            if (this.mInteractionListener != null) {
                this.mInteractionListener.onAdPauseAutoRefresh();
            }
        });
    }

    @Override
    public void onAdExpanded() {
        if (this.isInvalidated()) {
            return;
        }
        this.mMainHandler.post(() -> {
            if (this.mInteractionListener != null) {
                this.mInteractionListener.onAdExpanded();
            }
        });
    }

    @Override
    public void onAdCollapsed() {
        if (this.isInvalidated()) {
            return;
        }
        this.mMainHandler.post(() -> {
            if (this.mInteractionListener != null) {
                this.mInteractionListener.onAdCollapsed();
            }
        });
    }

    public static class BaseAdNotFoundException
    extends Exception {
        String message;
        Throwable cause;

        public BaseAdNotFoundException(Exception exception) {
            this.message = exception.getMessage();
            this.cause = exception.getCause();
            MoPubLog.log(MoPubLog.AdLogEvent.CUSTOM_WITH_THROWABLE, "AdAdapter.create() failed with exception", exception);
        }
    }
}

