/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.AdFormat;
import com.mopub.common.Preconditions;
import com.mopub.common.util.ResponseHeader;
import com.mopub.network.HeaderUtils;
import org.json.JSONObject;

public class AdTypeTranslator {
    public static final String BANNER_SUFFIX = "_banner";
    public static final String INTERSTITIAL_SUFFIX = "_interstitial";

    static String getAdNetworkType(String adType, String fullAdType) {
        String adNetworkType = "interstitial".equals(adType) ? fullAdType : adType;
        return adNetworkType != null ? adNetworkType : "unknown";
    }

    public static String getBaseAdClassName(@NonNull AdFormat adFormat, @NonNull String adType, @Nullable String fullAdType, @Nullable JSONObject headers) {
        Preconditions.checkNotNull((Object)adFormat);
        Preconditions.checkNotNull(adType);
        switch (adType.toLowerCase()) {
            case "custom": {
                return HeaderUtils.extractHeader(headers, ResponseHeader.CUSTOM_EVENT_NAME);
            }
            case "json": {
                return BaseAdType.MOPUB_NATIVE.toString();
            }
            case "json_video": {
                return BaseAdType.MOPUB_VIDEO_NATIVE.toString();
            }
            case "interstitial": {
                if ("admob_full".equals(fullAdType)) {
                    return BaseAdType.fromString(fullAdType + INTERSTITIAL_SUFFIX).toString();
                }
            }
            case "rewarded_video": 
            case "rewarded_playable": 
            case "fullscreen": {
                return BaseAdType.MOPUB_FULLSCREEN.toString();
            }
            case "html": 
            case "mraid": {
                return (AdFormat.BANNER.equals((Object)adFormat) ? BaseAdType.MOPUB_INLINE : BaseAdType.MOPUB_FULLSCREEN).toString();
            }
        }
        return BaseAdType.fromString(adType + BANNER_SUFFIX).toString();
    }

    public static enum BaseAdType {
        GOOGLE_PLAY_SERVICES_BANNER("admob_native_banner", "com.mopub.mobileads.GooglePlayServicesBanner", false),
        GOOGLE_PLAY_SERVICES_INTERSTITIAL("admob_full_interstitial", "com.mopub.mobileads.GooglePlayServicesInterstitial", false),
        MOPUB_NATIVE("mopub_native", "com.mopub.nativeads.MoPubCustomEventNative", true),
        MOPUB_VIDEO_NATIVE("mopub_video_native", "com.mopub.nativeads.MoPubCustomEventVideoNative", true),
        MOPUB_INLINE("mopub_inline", "com.mopub.mobileads.MoPubInline", true),
        MOPUB_FULLSCREEN("fullscreen", "com.mopub.mobileads.MoPubFullscreen", true),
        UNSPECIFIED("", null, false);

        @NonNull
        private final String mKey;
        @Nullable
        private final String mClassName;
        private final boolean mIsMoPubSpecific;

        private BaseAdType(String key, String className, boolean isMoPubSpecific) {
            this.mKey = key;
            this.mClassName = className;
            this.mIsMoPubSpecific = isMoPubSpecific;
        }

        private static BaseAdType fromString(@Nullable String key) {
            for (BaseAdType baseAdType : BaseAdType.values()) {
                if (!baseAdType.mKey.equals(key)) continue;
                return baseAdType;
            }
            return UNSPECIFIED;
        }

        private static BaseAdType fromClassName(@Nullable String className) {
            for (BaseAdType baseAdType : BaseAdType.values()) {
                if (baseAdType.mClassName == null || !baseAdType.mClassName.equals(className)) continue;
                return baseAdType;
            }
            return UNSPECIFIED;
        }

        public String toString() {
            return this.mClassName;
        }

        public static boolean isMoPubSpecific(@Nullable String className) {
            return BaseAdType.fromClassName((String)className).mIsMoPubSpecific;
        }
    }
}

