/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Point;
import android.location.Location;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.AdFormat;
import com.mopub.common.Constants;
import com.mopub.common.LocationService;
import com.mopub.common.MoPub;
import com.mopub.common.MoPubReward;
import com.mopub.common.Preconditions;
import com.mopub.common.ViewabilityVendor;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.DeviceUtils;
import com.mopub.common.util.Dips;
import com.mopub.common.util.Reflection;
import com.mopub.common.util.Utils;
import com.mopub.mobileads.AdAdapter;
import com.mopub.mobileads.AdData;
import com.mopub.mobileads.AdLifecycleListener;
import com.mopub.mobileads.MoPubAd;
import com.mopub.mobileads.MoPubError;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.MoPubView;
import com.mopub.mobileads.WebViewAdUrlGenerator;
import com.mopub.network.AdLoader;
import com.mopub.network.AdResponse;
import com.mopub.network.MoPubNetworkError;
import com.mopub.network.SingleImpression;
import com.mopub.network.TrackingRequest;
import com.mopub.volley.NetworkResponse;
import com.mopub.volley.Request;
import com.mopub.volley.VolleyError;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;

public class AdViewController
implements AdLifecycleListener.LoadListener,
AdLifecycleListener.InteractionListener {
    static final int DEFAULT_REFRESH_TIME_MILLISECONDS = 60000;
    private static final int MAX_REFRESH_TIME_MILLISECONDS = 600000;
    private static final double BACKOFF_FACTOR = 1.5;
    private static final FrameLayout.LayoutParams WRAP_AND_CENTER_LAYOUT_PARAMS = new FrameLayout.LayoutParams(-2, -2, 17);
    private static final WeakHashMap<View, Boolean> sViewShouldHonorServerDimensions = new WeakHashMap();
    private static final String INLINE_AD_ADAPTER = "com.mopub.mobileads.InlineAdAdapter";
    private static final String FULLSCREEN_AD_ADAPTER = "com.mopub.mobileads.FullscreenAdAdapter";
    private final long mBroadcastIdentifier;
    @Nullable
    private Context mContext;
    @Nullable
    private MoPubAd mMoPubAd;
    @Nullable
    private WebViewAdUrlGenerator mUrlGenerator;
    @Nullable
    private Request mActiveRequest;
    @Nullable
    AdLoader mAdLoader;
    @NonNull
    private final AdLoader.Listener mAdListener;
    @Nullable
    private AdResponse mAdResponse;
    @Nullable
    private String mBaseAdClassName;
    private final Runnable mRefreshRunnable;
    private boolean mIsDestroyed;
    private Handler mHandler;
    private boolean mHasOverlay;
    @VisibleForTesting
    int mBackoffPower = 1;
    private Map<String, Object> mLocalExtras = new HashMap<String, Object>();
    private boolean mCurrentAutoRefreshStatus = true;
    private boolean mShouldAllowAutoRefresh = true;
    private String mKeywords;
    private String mUserDataKeywords;
    private Point mRequestedAdSize;
    private WindowInsets mWindowInsets;
    private boolean mIsTesting;
    private boolean mAdWasLoaded;
    private AdAdapter mAdAdapter;
    @Nullable
    private String mAdUnitId;
    @Nullable
    private Integer mRefreshTimeMillis;
    @NonNull
    private String mLastTrackedRequestId;
    private long mOnPauseViewedTimeMillis;
    private long mShowStartedTimestampMillis;

    public static void setShouldHonorServerDimensions(View view) {
        sViewShouldHonorServerDimensions.put(view, true);
    }

    private static boolean getShouldHonorServerDimensions(View view) {
        return sViewShouldHonorServerDimensions.get(view) != null;
    }

    public AdViewController(@NonNull Context context, @NonNull MoPubAd moPubAd) {
        this.mContext = context;
        this.mMoPubAd = moPubAd;
        this.mBroadcastIdentifier = Utils.generateUniqueId();
        this.mUrlGenerator = new WebViewAdUrlGenerator(this.mContext.getApplicationContext());
        this.mAdListener = new AdLoader.Listener(){

            @Override
            public void onSuccess(AdResponse response) {
                AdViewController.this.onAdLoadSuccess(response);
            }

            public void onErrorResponse(VolleyError volleyError) {
                AdViewController.this.onAdLoadError(volleyError);
            }
        };
        this.mRefreshRunnable = new Runnable(){

            @Override
            public void run() {
                MoPubAd moPubAd = AdViewController.this.getMoPubAd();
                if (moPubAd != null) {
                    AdViewController.this.setRequestedAdSize(moPubAd.resolveAdSize());
                }
                AdViewController.this.internalLoadAd();
            }
        };
        this.mOnPauseViewedTimeMillis = 0L;
        this.mRefreshTimeMillis = 60000;
        this.mHandler = new Handler();
        this.mLastTrackedRequestId = "";
    }

    @VisibleForTesting
    void onAdLoadSuccess(@NonNull AdResponse adResponse) {
        this.mBackoffPower = 1;
        this.mAdResponse = adResponse;
        this.mBaseAdClassName = adResponse.getBaseAdClassName();
        this.mRefreshTimeMillis = this.mAdResponse.getRefreshTimeMillis();
        this.mActiveRequest = null;
        this.loadBaseAd();
        this.scheduleRefreshTimerIfEnabled();
    }

    @VisibleForTesting
    void onAdLoadError(VolleyError error) {
        MoPubErrorCode errorCode;
        MoPubNetworkError moPubNetworkError;
        if (error instanceof MoPubNetworkError && (moPubNetworkError = (MoPubNetworkError)error).getRefreshTimeMillis() != null) {
            this.mRefreshTimeMillis = moPubNetworkError.getRefreshTimeMillis();
        }
        if ((errorCode = AdViewController.getErrorCodeFromVolleyError(error, this.mContext)) == MoPubErrorCode.SERVER_ERROR) {
            ++this.mBackoffPower;
        }
        this.adDidFail(errorCode);
    }

    @VisibleForTesting
    @NonNull
    static MoPubErrorCode getErrorCodeFromVolleyError(@NonNull VolleyError error, @Nullable Context context) {
        NetworkResponse networkResponse = error.networkResponse;
        if (error instanceof MoPubNetworkError) {
            switch (((MoPubNetworkError)error).getReason()) {
                case WARMING_UP: {
                    return MoPubErrorCode.WARMUP;
                }
                case NO_FILL: {
                    return MoPubErrorCode.NO_FILL;
                }
                case TOO_MANY_REQUESTS: {
                    return MoPubErrorCode.TOO_MANY_REQUESTS;
                }
            }
            return MoPubErrorCode.UNSPECIFIED;
        }
        if (networkResponse == null) {
            if (!DeviceUtils.isNetworkAvailable(context)) {
                return MoPubErrorCode.NO_CONNECTION;
            }
            return MoPubErrorCode.UNSPECIFIED;
        }
        if (error.networkResponse.statusCode >= 400) {
            return MoPubErrorCode.SERVER_ERROR;
        }
        return MoPubErrorCode.UNSPECIFIED;
    }

    @Nullable
    public MoPubAd getMoPubAd() {
        return this.mMoPubAd;
    }

    @Nullable
    public AdAdapter getAdAdapter() {
        return this.mAdAdapter;
    }

    @Nullable
    public Context getContext() {
        return this.mContext;
    }

    public void loadAd() {
        this.mBackoffPower = 1;
        this.internalLoadAd();
    }

    private void internalLoadAd() {
        this.mAdWasLoaded = true;
        if (TextUtils.isEmpty((CharSequence)this.mAdUnitId)) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Can't load an ad in this ad view because the ad unit ID is not set. Did you forget to call setAdUnitId()?");
            this.adDidFail(MoPubErrorCode.MISSING_AD_UNIT_ID);
            return;
        }
        if (!this.isNetworkAvailable()) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Can't load an ad because there is no network connectivity.");
            this.adDidFail(MoPubErrorCode.NO_CONNECTION);
            return;
        }
        String adUrl = this.generateAdUrl();
        this.loadNonJavascript(adUrl, null);
    }

    void loadNonJavascript(@Nullable String url, @Nullable MoPubError moPubError) {
        if (url == null) {
            this.adDidFail(MoPubErrorCode.NO_FILL);
            return;
        }
        if (!url.startsWith("javascript:")) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Loading url: " + url);
        }
        if (this.mActiveRequest != null) {
            if (!TextUtils.isEmpty((CharSequence)this.mAdUnitId)) {
                MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Already loading an ad for " + this.mAdUnitId + ", wait to finish.");
            }
            return;
        }
        this.fetchAd(url, moPubError);
    }

    @Deprecated
    public void reload() {
        this.loadAd();
    }

    boolean loadFailUrl(MoPubErrorCode errorCode) {
        if (errorCode == null) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM_WITH_THROWABLE, "Load failed.", MoPubErrorCode.UNSPECIFIED.getIntCode(), MoPubErrorCode.UNSPECIFIED);
        } else {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM_WITH_THROWABLE, "Load failed.", errorCode, errorCode.getIntCode());
        }
        if (this.mAdLoader != null && this.mAdLoader.hasMoreAds()) {
            this.loadNonJavascript("", errorCode);
            return true;
        }
        this.adDidFail(MoPubErrorCode.NO_FILL);
        return false;
    }

    void setNotLoading() {
        if (this.mActiveRequest != null) {
            if (!this.mActiveRequest.isCanceled()) {
                this.mActiveRequest.cancel();
            }
            this.mActiveRequest = null;
        }
        this.mAdLoader = null;
    }

    public String getKeywords() {
        return this.mKeywords;
    }

    public void setKeywords(String keywords) {
        this.mKeywords = keywords;
    }

    public String getUserDataKeywords() {
        if (!MoPub.canCollectPersonalInformation()) {
            return null;
        }
        return this.mUserDataKeywords;
    }

    public void setUserDataKeywords(String userDataKeywords) {
        if (!MoPub.canCollectPersonalInformation()) {
            this.mUserDataKeywords = null;
            return;
        }
        this.mUserDataKeywords = userDataKeywords;
    }

    @Nullable
    public Location getLocation() {
        return LocationService.getLastKnownLocation(this.mContext);
    }

    public void setLocation(Location location) {
    }

    void setRequestedAdSize(Point requestedAdSize) {
        this.mRequestedAdSize = requestedAdSize;
    }

    public void setWindowInsets(WindowInsets windowInsets) {
        this.mWindowInsets = windowInsets;
    }

    public String getAdUnitId() {
        return this.mAdUnitId;
    }

    @Nullable
    public String getBaseAdClassName() {
        return this.mBaseAdClassName;
    }

    public void setAdUnitId(@NonNull String adUnitId) {
        this.mAdUnitId = adUnitId;
    }

    public long getBroadcastIdentifier() {
        return this.mBroadcastIdentifier;
    }

    public int getAdWidth() {
        if (this.mAdResponse != null && this.mAdResponse.getWidth() != null) {
            return this.mAdResponse.getWidth();
        }
        return 0;
    }

    public int getAdHeight() {
        if (this.mAdResponse != null && this.mAdResponse.getHeight() != null) {
            return this.mAdResponse.getHeight();
        }
        return 0;
    }

    @Deprecated
    public boolean getAutorefreshEnabled() {
        return this.getCurrentAutoRefreshStatus();
    }

    public boolean getCurrentAutoRefreshStatus() {
        return this.mCurrentAutoRefreshStatus;
    }

    void pauseRefresh() {
        this.setAutoRefreshStatus(false);
    }

    void resumeRefresh() {
        if (this.mShouldAllowAutoRefresh && !this.mHasOverlay) {
            this.setAutoRefreshStatus(true);
        }
    }

    void setShouldAllowAutoRefresh(boolean shouldAllowAutoRefresh) {
        this.mShouldAllowAutoRefresh = shouldAllowAutoRefresh;
        this.setAutoRefreshStatus(shouldAllowAutoRefresh);
    }

    private void setAutoRefreshStatus(boolean newAutoRefreshStatus) {
        boolean autoRefreshStatusChanged;
        boolean bl = autoRefreshStatusChanged = this.mAdWasLoaded && this.mCurrentAutoRefreshStatus != newAutoRefreshStatus;
        if (autoRefreshStatusChanged) {
            String enabledString = newAutoRefreshStatus ? "enabled" : "disabled";
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Refresh " + enabledString + " for ad unit (" + this.mAdUnitId + ").");
        }
        this.mCurrentAutoRefreshStatus = newAutoRefreshStatus;
        if (this.mAdWasLoaded && this.mCurrentAutoRefreshStatus) {
            this.mShowStartedTimestampMillis = SystemClock.uptimeMillis();
            this.scheduleRefreshTimerIfEnabled();
        } else if (!this.mCurrentAutoRefreshStatus) {
            this.mOnPauseViewedTimeMillis += SystemClock.uptimeMillis() - this.mShowStartedTimestampMillis;
            this.cancelRefreshTimer();
        }
    }

    void engageOverlay() {
        this.mHasOverlay = true;
        this.pauseRefresh();
    }

    void dismissOverlay() {
        this.mHasOverlay = false;
        this.resumeRefresh();
    }

    public String getDspCreativeId() {
        if (this.mAdUnitId != null && this.mAdResponse != null) {
            return this.mAdResponse.getDspCreativeId();
        }
        return "";
    }

    public boolean getAllowCustomClose() {
        if (this.mAdResponse == null) {
            return false;
        }
        return this.mAdResponse.allowCustomClose();
    }

    @Nullable
    public String getFullAdType() {
        if (this.mAdResponse == null) {
            return null;
        }
        return this.mAdResponse.getFullAdType();
    }

    public boolean getTesting() {
        return this.mIsTesting;
    }

    public void setTesting(boolean enabled) {
        this.mIsTesting = enabled;
    }

    boolean isDestroyed() {
        return this.mIsDestroyed;
    }

    void cleanup() {
        if (this.mIsDestroyed) {
            return;
        }
        this.setNotLoading();
        this.setAutoRefreshStatus(false);
        this.cancelRefreshTimer();
        this.invalidateAdapter();
        this.mMoPubAd = null;
        this.mContext = null;
        this.mUrlGenerator = null;
        this.mLastTrackedRequestId = "";
        this.mIsDestroyed = true;
    }

    @NonNull
    Integer getAdTimeoutDelay(AdFormat adFormat) {
        int defaultValue = adFormat == AdFormat.BANNER ? 10000 : 30000;
        if (this.mAdResponse == null) {
            return defaultValue;
        }
        return this.mAdResponse.getAdTimeoutMillis(defaultValue);
    }

    void registerClick() {
        if (this.mAdResponse != null) {
            TrackingRequest.makeTrackingHttpRequest(this.mAdResponse.getClickTrackingUrls(), this.mContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fetchAd(@NonNull String url, @Nullable MoPubError moPubError) {
        MoPubAd moPubAd = this.getMoPubAd();
        if (moPubAd == null || this.mContext == null) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Can't load an ad in this ad view because it was destroyed.");
            this.setNotLoading();
            return;
        }
        AdViewController adViewController = this;
        synchronized (adViewController) {
            if (this.mAdLoader == null || !this.mAdLoader.hasMoreAds()) {
                this.mAdLoader = new AdLoader(url, moPubAd.getAdFormat(), this.mAdUnitId, this.mContext, this.mAdListener);
            }
        }
        this.mActiveRequest = this.mAdLoader.loadNextAd(moPubError);
    }

    void forceRefresh() {
        this.invalidateAdapter();
        this.setNotLoading();
        this.loadAd();
    }

    protected void invalidateAdapter() {
        AdAdapter adAdapter = this.getAdAdapter();
        if (adAdapter != null) {
            adAdapter.invalidate();
            this.mAdAdapter = null;
        }
    }

    @Nullable
    String generateAdUrl() {
        if (this.mUrlGenerator == null) {
            return null;
        }
        boolean canCollectPersonalInformation = MoPub.canCollectPersonalInformation();
        this.mUrlGenerator.withAdUnitId(this.mAdUnitId).withKeywords(this.mKeywords).withUserDataKeywords(canCollectPersonalInformation ? this.mUserDataKeywords : null).withRequestedAdSize(this.mRequestedAdSize).withWindowInsets(this.mWindowInsets);
        return this.mUrlGenerator.generateUrlString(Constants.HOST);
    }

    void adDidFail(MoPubErrorCode errorCode) {
        MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Ad failed to load.");
        this.setNotLoading();
        MoPubAd moPubAd = this.getMoPubAd();
        if (moPubAd == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mAdUnitId)) {
            this.scheduleRefreshTimerIfEnabled();
        }
        moPubAd.onAdLoadFailed(errorCode);
    }

    void scheduleRefreshTimerIfEnabled() {
        this.cancelRefreshTimer();
        if (this.mCurrentAutoRefreshStatus && this.mRefreshTimeMillis != null && this.mRefreshTimeMillis > 0) {
            long maxExpectedRefreshTimeMillis = Math.min(600000L, (long)this.mRefreshTimeMillis.intValue() * (long)Math.pow(1.5, this.mBackoffPower));
            long currentExpectedRefreshTimeMillis = maxExpectedRefreshTimeMillis - this.mOnPauseViewedTimeMillis;
            if (currentExpectedRefreshTimeMillis < 0L) {
                currentExpectedRefreshTimeMillis = maxExpectedRefreshTimeMillis;
            }
            this.mHandler.postDelayed(this.mRefreshRunnable, currentExpectedRefreshTimeMillis);
        }
    }

    void setLocalExtras(Map<String, Object> localExtras) {
        this.mLocalExtras = localExtras != null ? new TreeMap<String, Object>(localExtras) : new TreeMap();
    }

    Map<String, Object> getLocalExtras() {
        return this.mLocalExtras != null ? new TreeMap<String, Object>(this.mLocalExtras) : new TreeMap();
    }

    private void cancelRefreshTimer() {
        this.mHandler.removeCallbacks(this.mRefreshRunnable);
    }

    @SuppressLint(value={"MissingPermission"})
    private boolean isNetworkAvailable() {
        if (this.mContext == null) {
            return false;
        }
        if (!DeviceUtils.isPermissionGranted(this.mContext, "android.permission.ACCESS_NETWORK_STATE")) {
            return true;
        }
        ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }

    void setAdContentView(final View view) {
        final MoPubAd moPubAd = this.getMoPubAd();
        if (moPubAd instanceof MoPubView) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ((MoPubView)moPubAd).removeAllViews();
                    ((MoPubView)moPubAd).addView(view, (ViewGroup.LayoutParams)AdViewController.this.getAdLayoutParams(view));
                }
            });
        }
    }

    private FrameLayout.LayoutParams getAdLayoutParams(View view) {
        Integer width = null;
        Integer height = null;
        if (this.mAdResponse != null) {
            width = this.mAdResponse.getWidth();
            height = this.mAdResponse.getHeight();
        }
        if (width != null && height != null && AdViewController.getShouldHonorServerDimensions(view) && width > 0 && height > 0 && this.mContext != null) {
            int scaledWidth = Dips.asIntPixels(width.intValue(), this.mContext);
            int scaledHeight = Dips.asIntPixels(height.intValue(), this.mContext);
            return new FrameLayout.LayoutParams(scaledWidth, scaledHeight, 17);
        }
        return WRAP_AND_CENTER_LAYOUT_PARAMS;
    }

    protected void loadBaseAd() {
        String baseAdClassName = this.mAdResponse.getBaseAdClassName();
        Map<String, String> serverExtras = this.mAdResponse.getServerExtras();
        String adType = this.mAdResponse.getAdType();
        String fullAdType = this.mAdResponse.getFullAdType();
        String impressionMinVisibleDipsString = this.mAdResponse.getImpressionMinVisibleDips();
        String impressionMinVisibleMsString = this.mAdResponse.getImpressionMinVisibleMs();
        boolean allowCustomClose = this.mAdResponse.allowCustomClose();
        Set<ViewabilityVendor> viewabilityVendors = this.mAdResponse.getViewabilityVendors();
        Preconditions.checkNotNull(serverExtras);
        MoPubAd moPubAd = this.getMoPubAd();
        if (moPubAd == null) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Can't load an ad in this ad view because it was destroyed.");
            this.loadFailUrl(MoPubErrorCode.INTERNAL_ERROR);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)baseAdClassName)) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Couldn't invoke base ad because the server did not specify one.");
            this.loadFailUrl(MoPubErrorCode.ADAPTER_NOT_FOUND);
            return;
        }
        this.invalidateAdapter();
        MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Loading ad adapter.");
        TreeMap<String, String> extras = new TreeMap<String, String>(serverExtras);
        for (String key : this.mLocalExtras.keySet()) {
            Object value = this.mLocalExtras.get(key);
            if (value == null || extras.containsKey(key)) continue;
            extras.put(key, value.toString());
        }
        String adapterClassName = moPubAd.getAdFormat() == AdFormat.BANNER ? INLINE_AD_ADAPTER : FULLSCREEN_AD_ADAPTER;
        String adPayload = serverExtras.remove("html-response-body");
        AdData adData = new AdData.Builder().extras(extras).broadcastIdentifier(this.getBroadcastIdentifier()).timeoutDelayMillis(this.getAdTimeoutDelay(moPubAd.getAdFormat())).impressionMinVisibleDips(impressionMinVisibleDipsString).impressionMinVisibleMs(impressionMinVisibleMsString).dspCreativeId(this.getDspCreativeId()).adPayload(adPayload != null ? adPayload : "").adWidth(this.getAdWidth()).adHeight(this.getAdHeight()).adType(adType).fullAdType(fullAdType).allowCustomClose(allowCustomClose).viewabilityVendors(viewabilityVendors).build();
        if (Reflection.classFound(adapterClassName)) {
            try {
                Class<AdAdapter> adAdapterClass = Class.forName(adapterClassName).asSubclass(AdAdapter.class);
                Constructor<AdAdapter> adAdapterConstructor = adAdapterClass.getDeclaredConstructor(Context.class, String.class, AdData.class);
                adAdapterConstructor.setAccessible(true);
                this.mAdAdapter = adAdapterConstructor.newInstance(this.mContext, baseAdClassName, adData);
                this.mAdAdapter.load(this);
            }
            catch (Exception e) {
                MoPubLog.log(MoPubLog.SdkLogEvent.ERROR_WITH_THROWABLE, "Error loading ad adapter", e);
                this.loadFailUrl(MoPubErrorCode.ADAPTER_NOT_FOUND);
            }
        } else {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM_WITH_THROWABLE, "Could not load adapter", MoPubErrorCode.ADAPTER_NOT_FOUND, MoPubErrorCode.ADAPTER_NOT_FOUND.getIntCode());
            this.loadFailUrl(MoPubErrorCode.ADAPTER_NOT_FOUND);
        }
    }

    void show() {
        this.mOnPauseViewedTimeMillis = 0L;
        this.mShowStartedTimestampMillis = SystemClock.uptimeMillis();
        AdAdapter adAdapter = this.getAdAdapter();
        if (adAdapter != null) {
            adAdapter.setInteractionListener(this);
            adAdapter.show(this.getMoPubAd());
        }
    }

    @Deprecated
    @VisibleForTesting
    Integer getRefreshTimeMillis() {
        return this.mRefreshTimeMillis;
    }

    @Deprecated
    @VisibleForTesting
    void setRefreshTimeMillis(@Nullable Integer refreshTimeMillis) {
        this.mRefreshTimeMillis = refreshTimeMillis;
    }

    @Override
    public void onAdLoaded() {
        this.scheduleRefreshTimerIfEnabled();
        if (this.mAdLoader != null) {
            this.mAdLoader.creativeDownloadSuccess();
            this.mAdLoader = null;
        } else {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "mAdLoader is not supposed to be null");
        }
        MoPubAd moPubAd = this.getMoPubAd();
        if (moPubAd != null) {
            moPubAd.onAdLoaded();
        }
    }

    @Override
    public void onAdLoadFailed(@NotNull MoPubErrorCode errorCode) {
        if (!this.loadFailUrl(errorCode)) {
            this.adDidFail(errorCode);
        }
    }

    @Override
    public void onAdFailed(@NotNull MoPubErrorCode errorCode) {
        MoPubAd moPubAd = this.getMoPubAd();
        if (moPubAd != null) {
            moPubAd.onAdLoadFailed(errorCode);
        }
    }

    @Override
    public void onAdShown() {
        MoPubAd moPubAd = this.getMoPubAd();
        if (moPubAd != null) {
            moPubAd.onAdShown();
        }
    }

    @Override
    public void onAdClicked() {
        MoPubAd moPubAd = this.getMoPubAd();
        if (moPubAd != null) {
            moPubAd.onAdClicked();
        }
    }

    @Override
    public void onAdImpression() {
        if (this.mAdResponse != null) {
            String requestId = this.mAdResponse.getRequestId();
            if (this.mLastTrackedRequestId.equals(requestId)) {
                MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Ignoring duplicate impression.");
                return;
            }
            if (requestId != null) {
                this.mLastTrackedRequestId = requestId;
            }
            TrackingRequest.makeTrackingHttpRequest(this.mAdResponse.getImpressionTrackingUrls(), this.mContext);
            new SingleImpression(this.mAdResponse.getAdUnitId(), this.mAdResponse.getImpressionData()).sendImpression();
        }
    }

    @Override
    public void onAdDismissed() {
        MoPubAd moPubAd = this.getMoPubAd();
        if (moPubAd != null) {
            moPubAd.onAdDismissed();
        }
    }

    @Override
    public void onAdComplete(@Nullable MoPubReward moPubReward) {
        MoPubAd moPubAd = this.getMoPubAd();
        if (moPubAd != null) {
            moPubAd.onAdComplete(moPubReward);
        }
    }

    @Override
    public void onAdResumeAutoRefresh() {
        MoPubAd moPubAd = this.getMoPubAd();
        if (moPubAd != null) {
            moPubAd.onAdResumeAutoRefresh();
        }
    }

    @Override
    public void onAdPauseAutoRefresh() {
        MoPubAd moPubAd = this.getMoPubAd();
        if (moPubAd != null) {
            moPubAd.onAdPauseAutoRefresh();
        }
    }

    @Override
    public void onAdExpanded() {
        MoPubAd moPubAd = this.getMoPubAd();
        if (moPubAd != null) {
            moPubAd.onAdExpanded();
        }
    }

    @Override
    public void onAdCollapsed() {
        MoPubAd moPubAd = this.getMoPubAd();
        if (moPubAd != null) {
            moPubAd.onAdCollapsed();
        }
    }

    @VisibleForTesting
    public void setMoPubAd(@Nullable MoPubAd moPubAd) {
        this.mMoPubAd = moPubAd;
    }

    @VisibleForTesting
    public void setAdResponse(@Nullable AdResponse adResponse) {
        this.mAdResponse = adResponse;
    }

    @VisibleForTesting
    long getOnPauseViewedTimeMillis() {
        return this.mOnPauseViewedTimeMillis;
    }

    @VisibleForTesting
    long getShowStartedTimestampMillis() {
        return this.mShowStartedTimestampMillis;
    }
}

