/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.mopub.common.Preconditions;

public abstract class BaseBroadcastReceiver
extends BroadcastReceiver {
    private final long mBroadcastIdentifier;
    @Nullable
    private Context mContext;

    public BaseBroadcastReceiver(long broadcastIdentifier) {
        this.mBroadcastIdentifier = broadcastIdentifier;
    }

    public static void broadcastAction(@NonNull Context context, long broadcastIdentifier, @NonNull String action) {
        Preconditions.checkNotNull(context, "context cannot be null");
        Preconditions.checkNotNull(action, "action cannot be null");
        Intent intent = new Intent(action);
        intent.putExtra("broadcastIdentifier", broadcastIdentifier);
        LocalBroadcastManager.getInstance((Context)context.getApplicationContext()).sendBroadcast(intent);
    }

    @NonNull
    public abstract IntentFilter getIntentFilter();

    public void register(@NonNull BroadcastReceiver broadcastReceiver, @NonNull Context context) {
        this.mContext = context.getApplicationContext();
        LocalBroadcastManager.getInstance((Context)this.mContext).registerReceiver(broadcastReceiver, this.getIntentFilter());
    }

    public void unregister(@Nullable BroadcastReceiver broadcastReceiver) {
        if (this.mContext != null && broadcastReceiver != null) {
            LocalBroadcastManager.getInstance((Context)this.mContext).unregisterReceiver(broadcastReceiver);
            this.mContext = null;
        }
    }

    public boolean shouldConsumeBroadcast(@NonNull Intent intent) {
        Preconditions.checkNotNull(intent, "intent cannot be null");
        long receivedIdentifier = intent.getLongExtra("broadcastIdentifier", -1L);
        return this.mBroadcastIdentifier == receivedIdentifier;
    }
}

