/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.WebSettings;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.Constants;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.BaseWebViewViewability;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.ViewGestureDetector;
import com.mopub.network.Networking;

public class BaseHtmlWebView
extends BaseWebViewViewability {
    @NonNull
    private final ViewGestureDetector mViewGestureDetector;

    public BaseHtmlWebView(Context context) {
        super(context);
        this.disableScrollingAndZoom();
        this.getSettings().setJavaScriptEnabled(true);
        this.mViewGestureDetector = new ViewGestureDetector(context);
        this.setBackgroundColor(0);
    }

    public void init() {
        this.initializeOnTouchListener();
    }

    public void loadUrl(@Nullable String url) {
        if (url == null) {
            return;
        }
        if (url.startsWith("javascript:")) {
            super.loadUrl(url);
            return;
        }
        MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Loading url: " + url);
    }

    public void stopLoading() {
        if (this.mIsDestroyed) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, BaseHtmlWebView.class.getSimpleName() + "#stopLoading() called after destroy()");
            return;
        }
        WebSettings webSettings = this.getSettings();
        if (webSettings == null) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, BaseHtmlWebView.class.getSimpleName() + "#getSettings() returned null");
            return;
        }
        webSettings.setJavaScriptEnabled(false);
        super.stopLoading();
        webSettings.setJavaScriptEnabled(true);
    }

    private void disableScrollingAndZoom() {
        this.setHorizontalScrollBarEnabled(false);
        this.setHorizontalScrollbarOverlay(false);
        this.setVerticalScrollBarEnabled(false);
        this.setVerticalScrollbarOverlay(false);
        this.getSettings().setSupportZoom(false);
    }

    void loadHtmlResponse(String htmlResponse) {
        this.loadDataWithBaseURL(Networking.getBaseUrlScheme() + "://" + Constants.HOST + "/", htmlResponse, "text/html", "utf-8", null);
    }

    void initializeOnTouchListener() {
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                BaseHtmlWebView.this.mViewGestureDetector.onTouchEvent(event);
                return event.getAction() == 2;
            }
        });
    }

    public void onResetUserClick() {
        ViewGestureDetector gestureDetector = this.mViewGestureDetector;
        if (gestureDetector != null) {
            gestureDetector.onResetUserClick();
        }
    }

    public boolean wasClicked() {
        ViewGestureDetector gestureDetector = this.mViewGestureDetector;
        return gestureDetector != null && gestureDetector.isClicked();
    }

    public static interface BaseWebViewListener {
        public void onLoaded(View var1);

        public void onFailedToLoad(@NonNull MoPubErrorCode var1);

        public void onRenderProcessGone(@NonNull MoPubErrorCode var1);

        public void onFailed();

        public void onClicked();

        public void onExpand();

        public void onResize(boolean var1);

        public void onClose();
    }
}

