/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import androidx.annotation.Nullable;
import com.mopub.common.CreativeOrientation;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Utils;
import com.mopub.mobileads.MraidVideoPlayerActivity;
import com.mopub.mobileads.VastVideoConfig;
import java.io.Serializable;

public class BaseVideoPlayerActivity
extends Activity {
    public static final String VIDEO_CLASS_EXTRAS_KEY = "video_view_class_name";
    public static final String VIDEO_URL = "video_url";

    public static void startMraid(Context context, String videoUrl) {
        Intent intentVideoPlayerActivity = BaseVideoPlayerActivity.createIntentMraid(context, videoUrl);
        try {
            context.startActivity(intentVideoPlayerActivity);
        }
        catch (ActivityNotFoundException e) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Activity MraidVideoPlayerActivity not found. Did you declare it in your AndroidManifest.xml?");
        }
    }

    static Intent createIntentMraid(Context context, String videoUrl) {
        Intent intentVideoPlayerActivity = new Intent(context, MraidVideoPlayerActivity.class);
        intentVideoPlayerActivity.setFlags(0x10000000);
        intentVideoPlayerActivity.putExtra(VIDEO_CLASS_EXTRAS_KEY, "mraid");
        intentVideoPlayerActivity.putExtra(VIDEO_URL, videoUrl);
        return intentVideoPlayerActivity;
    }

    static void startVast(Context context, VastVideoConfig vastVideoConfig, long broadcastIdentifier, @Nullable CreativeOrientation orientation) {
        Intent intentVideoPlayerActivity = BaseVideoPlayerActivity.createIntentVast(context, vastVideoConfig, broadcastIdentifier, orientation);
        try {
            context.startActivity(intentVideoPlayerActivity);
        }
        catch (ActivityNotFoundException e) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Attempt to start with VastVideoConfig failed. Activity MraidVideoPlayerActivity not found. Did you declare it in your AndroidManifest.xml?");
        }
    }

    static Intent createIntentVast(Context context, VastVideoConfig vastVideoConfig, long broadcastIdentifier, @Nullable CreativeOrientation orientation) {
        Intent intentVideoPlayerActivity = new Intent(context, MraidVideoPlayerActivity.class);
        intentVideoPlayerActivity.setFlags(0x10000000);
        intentVideoPlayerActivity.putExtra(VIDEO_CLASS_EXTRAS_KEY, "vast_new");
        intentVideoPlayerActivity.putExtra("vast_video_config", (Serializable)vastVideoConfig);
        intentVideoPlayerActivity.putExtra("broadcastIdentifier", broadcastIdentifier);
        intentVideoPlayerActivity.putExtra("com_mopub_orientation", (Serializable)((Object)orientation));
        return intentVideoPlayerActivity;
    }

    public static void startNativeVideo(Context context, long nativeVideoId, VastVideoConfig vastVideoConfig) {
        Intent intentVideoPlayerActivity = BaseVideoPlayerActivity.createIntentNativeVideo(context, nativeVideoId, vastVideoConfig);
        try {
            context.startActivity(intentVideoPlayerActivity);
        }
        catch (ActivityNotFoundException e) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Activity MraidVideoPlayerActivity not found. Did you declare it in your AndroidManifest.xml?");
        }
    }

    public static Intent createIntentNativeVideo(Context context, long nativeVideoId, VastVideoConfig vastVideoConfig) {
        Intent intentVideoPlayerActivity = new Intent(context, MraidVideoPlayerActivity.class);
        intentVideoPlayerActivity.setFlags(0x10000000);
        intentVideoPlayerActivity.putExtra(VIDEO_CLASS_EXTRAS_KEY, "native");
        intentVideoPlayerActivity.putExtra("native_video_id", nativeVideoId);
        intentVideoPlayerActivity.putExtra("native_vast_video_config", (Serializable)vastVideoConfig);
        return intentVideoPlayerActivity;
    }

    protected void onStart() {
        super.onStart();
        Utils.hideNavigationBar(this);
    }

    protected void onDestroy() {
        super.onDestroy();
        AudioManager am = (AudioManager)this.getSystemService("audio");
        if (am != null) {
            am.abandonAudioFocus(null);
        }
    }
}

