/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.BaseBroadcastReceiver;

public abstract class BaseVideoViewController {
    private final Context mContext;
    private final RelativeLayout mLayout;
    @NonNull
    private final BaseVideoViewControllerListener mBaseVideoViewControllerListener;
    @Nullable
    private Long mBroadcastIdentifier;

    protected BaseVideoViewController(Context context, @Nullable Long broadcastIdentifier, @NonNull BaseVideoViewControllerListener baseVideoViewControllerListener) {
        Preconditions.checkNotNull(baseVideoViewControllerListener);
        this.mContext = context;
        this.mBroadcastIdentifier = broadcastIdentifier;
        this.mBaseVideoViewControllerListener = baseVideoViewControllerListener;
        this.mLayout = new RelativeLayout(this.mContext);
    }

    protected void onCreate() {
        RelativeLayout.LayoutParams adViewLayout = new RelativeLayout.LayoutParams(-1, -1);
        adViewLayout.addRule(13);
        this.mLayout.addView(this.getVideoView(), 0, (ViewGroup.LayoutParams)adViewLayout);
        this.mBaseVideoViewControllerListener.onSetContentView((View)this.mLayout);
    }

    protected abstract View getVideoView();

    protected abstract void onPause();

    protected abstract void onResume();

    protected abstract void onDestroy();

    protected abstract void onSaveInstanceState(@NonNull Bundle var1);

    protected abstract void onConfigurationChanged(Configuration var1);

    protected abstract void onBackPressed();

    public boolean backButtonEnabled() {
        return true;
    }

    void onActivityResult(int requestCode, int resultCode, Intent data) {
    }

    @NonNull
    protected BaseVideoViewControllerListener getBaseVideoViewControllerListener() {
        return this.mBaseVideoViewControllerListener;
    }

    protected Context getContext() {
        return this.mContext;
    }

    public ViewGroup getLayout() {
        return this.mLayout;
    }

    protected void videoError(boolean shouldFinish) {
        MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Video cannot be played.");
        this.broadcastAction("com.mopub.action.fullscreen.fail");
        if (shouldFinish) {
            this.mBaseVideoViewControllerListener.onFinish();
        }
    }

    protected void videoCompleted(boolean shouldFinish) {
        if (shouldFinish) {
            this.mBaseVideoViewControllerListener.onFinish();
        }
    }

    void broadcastAction(String action) {
        if (this.mBroadcastIdentifier != null) {
            BaseBroadcastReceiver.broadcastAction(this.mContext, this.mBroadcastIdentifier, action);
        } else {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Tried to broadcast a video event without a broadcast identifier to send to.");
        }
    }

    public static interface BaseVideoViewControllerListener {
        public void onSetContentView(View var1);

        public void onSetRequestedOrientation(int var1);

        public void onFinish();

        public void onStartActivityForResult(Class<? extends Activity> var1, int var2, Bundle var3);
    }
}

