/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.util.Views;
import com.mopub.mobileads.util.WebViews;

public class BaseWebView
extends WebView {
    private static boolean sDeadlockCleared = false;
    protected boolean mIsDestroyed;
    private final Handler handler = new Handler(Looper.getMainLooper());
    protected boolean delayDestroy = false;

    public BaseWebView(Context context) {
        super(context.getApplicationContext());
        this.restrictDeviceContentAccess();
        WebViews.setDisableJSChromeClient(this);
        if (!sDeadlockCleared) {
            this.clearWebViewDeadlock(this.getContext());
            sDeadlockCleared = true;
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        WebViews.manageThirdPartyCookies(this);
    }

    public void destroy() {
        if (this.mIsDestroyed) {
            return;
        }
        this.mIsDestroyed = true;
        Views.removeFromParent((View)this);
        this.removeAllViews();
        if (this.delayDestroy) {
            this.handler.postDelayed(this::delayedDestroy, 1000L);
        } else {
            super.destroy();
        }
    }

    private void delayedDestroy() {
        super.destroy();
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected void enableJavascriptCaching() {
        this.getSettings().setJavaScriptEnabled(true);
        this.getSettings().setDomStorageEnabled(true);
        this.getSettings().setAppCacheEnabled(true);
        this.getSettings().setAppCachePath(this.getContext().getCacheDir().getAbsolutePath());
    }

    private void restrictDeviceContentAccess() {
        this.getSettings().setAllowFileAccess(false);
        this.getSettings().setAllowContentAccess(false);
        this.getSettings().setAllowFileAccessFromFileURLs(false);
        this.getSettings().setAllowUniversalAccessFromFileURLs(false);
    }

    private void clearWebViewDeadlock(@NonNull Context context) {
        if (Build.VERSION.SDK_INT == 19) {
            WebView webView = new WebView(context.getApplicationContext());
            webView.setBackgroundColor(0);
            webView.loadDataWithBaseURL(null, "", "text/html", "UTF-8", null);
            WindowManager.LayoutParams params = new WindowManager.LayoutParams();
            params.width = 1;
            params.height = 1;
            params.type = 2005;
            params.flags = 0x1000018;
            params.format = -2;
            params.gravity = 0x800033;
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            windowManager.addView((View)webView, (ViewGroup.LayoutParams)params);
        }
    }

    @Deprecated
    @VisibleForTesting
    void setIsDestroyed(boolean isDestroyed) {
        this.mIsDestroyed = isDestroyed;
    }
}

