/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.mopub.common.ExternalViewabilitySessionManager;
import com.mopub.common.ViewabilityManager;
import com.mopub.common.ViewabilityObstruction;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.BaseWebView;

public class BaseWebViewViewability
extends BaseWebView {
    protected State state = State.INIT;
    @NonNull
    protected ExternalViewabilitySessionManager externalViewabilityTracker;
    protected boolean viewabilityEnabled = ViewabilityManager.isViewabilityEnabled();
    protected boolean automaticImpression = true;
    protected boolean pageLoaded = false;
    protected boolean pageVisible = false;

    public BaseWebViewViewability(Context context) {
        super(context);
        this.externalViewabilityTracker = ExternalViewabilitySessionManager.create();
        if (this.viewabilityEnabled) {
            this.delayDestroy = true;
        }
        this.log("BaseWebViewViewability() " + (Object)((Object)this));
    }

    private void changeState(@NonNull State newState) {
        if (!this.viewabilityEnabled) {
            return;
        }
        boolean modified = false;
        switch (newState) {
            case STARTED: {
                if (this.state != State.INIT || !this.pageLoaded) break;
                this.externalViewabilityTracker.createWebViewSession(this);
                this.externalViewabilityTracker.startSession();
                modified = true;
                break;
            }
            case IMPRESSED: {
                if (this.state != State.STARTED || !this.pageVisible) break;
                this.externalViewabilityTracker.trackImpression();
                modified = true;
                break;
            }
            case STOPPED: {
                if (this.state == State.INIT || this.state == State.STOPPED) break;
                this.externalViewabilityTracker.endSession();
                modified = true;
            }
        }
        if (modified) {
            this.state = newState;
        } else {
            this.log("Skip state transition " + (Object)((Object)this.state) + " to " + (Object)((Object)newState));
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.log("onAttachedToWindow() " + (Object)((Object)this));
        if (this.pageLoaded) {
            this.changeState(State.STARTED);
        }
    }

    protected void onDetachedFromWindow() {
        this.changeState(State.STOPPED);
        super.onDetachedFromWindow();
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.log("onVisibilityChanged: " + visibility + " " + (Object)((Object)this));
        boolean bl = this.pageVisible = visibility == 0;
        if (this.automaticImpression) {
            this.changeState(State.IMPRESSED);
        }
    }

    public void disableTracking() {
        this.viewabilityEnabled = false;
    }

    public void enableTracking() {
        this.viewabilityEnabled = true;
    }

    public void disableAutomaticImpression() {
        this.automaticImpression = false;
    }

    public void setPageLoaded() {
        this.log("setPageLoaded() " + (Object)((Object)this));
        this.pageLoaded = true;
        this.changeState(State.STARTED);
        if (this.automaticImpression) {
            this.changeState(State.IMPRESSED);
        }
    }

    public void notifyImpression() {
        this.changeState(State.IMPRESSED);
    }

    void registerFriendlyObstruction(@NonNull View view, @NonNull ViewabilityObstruction purpose) {
        if (this.viewabilityEnabled) {
            this.externalViewabilityTracker.registerFriendlyObstruction(view, purpose);
        }
    }

    @VisibleForTesting
    void setMockExternalTracker(@NonNull ExternalViewabilitySessionManager mockExternalTracker) {
        this.externalViewabilityTracker = mockExternalTracker;
    }

    private void log(@NonNull String message) {
        if (ViewabilityManager.isViewabilityEnabled()) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "OMSDK " + message);
        }
    }

    protected static enum State {
        INIT,
        STARTED,
        IMPRESSED,
        STOPPED;

    }
}

