/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.VisibleForTesting;
import com.mopub.mobileads.AdViewController;
import com.mopub.mobileads.BaseHtmlWebView;
import com.mopub.mobileads.BaseWebView;
import com.mopub.mobileads.HtmlWebView;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.MoPubWebViewController;

public class HtmlController
extends MoPubWebViewController {
    private BaseHtmlWebView.BaseWebViewListener mHtmlWebViewListener = new HtmlWebViewListener();

    public HtmlController(@NonNull Context context, @Nullable String dspCreativeId) {
        super(context, dspCreativeId);
        this.mDefaultAdContainer.setLayoutParams(this.getLayoutParams());
    }

    @Override
    protected BaseWebView createWebView() {
        HtmlWebView htmlWebView = new HtmlWebView(this.mContext);
        AdViewController.setShouldHonorServerDimensions((View)htmlWebView);
        htmlWebView.init(this.mHtmlWebViewListener, this.mDspCreativeId);
        return htmlWebView;
    }

    @Override
    protected void doFillContent(@NonNull String htmlData) {
        ((HtmlWebView)this.mWebView).loadHtmlResponse(htmlData);
    }

    @Override
    protected void destroy() {
        super.destroy();
        if (this.mWebView != null) {
            this.mWebView.destroy();
            this.mWebView = null;
        }
    }

    @Override
    protected ViewGroup.LayoutParams getLayoutParams() {
        return new FrameLayout.LayoutParams(-2, -2, 17);
    }

    @Override
    @NonNull
    public View getAdContainer() {
        return this.mWebView != null ? this.mWebView : this.mDefaultAdContainer;
    }

    @VisibleForTesting
    public void setWebView(BaseWebView baseWebView) {
        this.mWebView = baseWebView;
    }

    @VisibleForTesting
    public BaseWebView getWebView() {
        return this.mWebView;
    }

    class HtmlWebViewListener
    implements BaseHtmlWebView.BaseWebViewListener {
        HtmlWebViewListener() {
        }

        @Override
        public void onLoaded(View view) {
            if (HtmlController.this.mBaseWebViewListener != null) {
                HtmlController.this.mBaseWebViewListener.onLoaded(view);
            }
        }

        @Override
        public void onFailedToLoad(@NonNull MoPubErrorCode errorCode) {
            if (HtmlController.this.mBaseWebViewListener != null) {
                HtmlController.this.mBaseWebViewListener.onFailedToLoad(MoPubErrorCode.HTML_LOAD_ERROR);
            }
        }

        @Override
        public void onFailed() {
            if (HtmlController.this.mBaseWebViewListener != null) {
                HtmlController.this.mBaseWebViewListener.onFailed();
            }
        }

        @Override
        public void onRenderProcessGone(@NonNull MoPubErrorCode errorCode) {
            if (HtmlController.this.mBaseWebViewListener != null) {
                HtmlController.this.mBaseWebViewListener.onRenderProcessGone(errorCode);
            }
        }

        @Override
        public void onClicked() {
            if (HtmlController.this.mBaseWebViewListener != null) {
                HtmlController.this.mBaseWebViewListener.onClicked();
            }
        }

        @Override
        public void onExpand() {
            if (HtmlController.this.mBaseWebViewListener != null) {
                HtmlController.this.mBaseWebViewListener.onExpand();
            }
        }

        @Override
        public void onResize(boolean toOriginalSize) {
            if (HtmlController.this.mBaseWebViewListener != null) {
                HtmlController.this.mBaseWebViewListener.onResize(toOriginalSize);
            }
        }

        @Override
        public void onClose() {
            if (HtmlController.this.mBaseWebViewListener != null) {
                HtmlController.this.mBaseWebViewListener.onClose();
            }
        }
    }
}

