/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.NonNull;
import com.mopub.common.UrlAction;
import com.mopub.common.UrlHandler;
import com.mopub.mobileads.BaseHtmlWebView;
import com.mopub.mobileads.MoPubErrorCode;
import java.util.EnumSet;

class HtmlWebViewClient
extends WebViewClient {
    private final EnumSet<UrlAction> SUPPORTED_URL_ACTIONS = EnumSet.of(UrlAction.HANDLE_MOPUB_SCHEME, new UrlAction[]{UrlAction.IGNORE_ABOUT_SCHEME, UrlAction.HANDLE_PHONE_SCHEME, UrlAction.OPEN_APP_MARKET, UrlAction.OPEN_NATIVE_BROWSER, UrlAction.OPEN_IN_APP_BROWSER, UrlAction.HANDLE_SHARE_TWEET, UrlAction.FOLLOW_DEEP_LINK_WITH_FALLBACK, UrlAction.FOLLOW_DEEP_LINK});
    private final Context mContext;
    private final String mDspCreativeId;
    private BaseHtmlWebView.BaseWebViewListener mBaseWebViewListener;
    private final BaseHtmlWebView mHtmlWebView;

    HtmlWebViewClient(BaseHtmlWebView htmlWebView, BaseHtmlWebView.BaseWebViewListener baseWebViewListener, String dspCreativeId) {
        this.mHtmlWebView = htmlWebView;
        this.mDspCreativeId = dspCreativeId;
        this.mContext = htmlWebView.getContext();
        this.mBaseWebViewListener = baseWebViewListener;
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        new UrlHandler.Builder().withDspCreativeId(this.mDspCreativeId).withSupportedUrlActions(this.SUPPORTED_URL_ACTIONS).withResultActions(new UrlHandler.ResultActions(){

            @Override
            public void urlHandlingSucceeded(@NonNull String url, @NonNull UrlAction urlAction) {
                if (HtmlWebViewClient.this.mHtmlWebView.wasClicked()) {
                    if (HtmlWebViewClient.this.mBaseWebViewListener != null) {
                        HtmlWebViewClient.this.mBaseWebViewListener.onClicked();
                    }
                    HtmlWebViewClient.this.mHtmlWebView.onResetUserClick();
                }
            }

            @Override
            public void urlHandlingFailed(@NonNull String url, @NonNull UrlAction lastFailedUrlAction) {
            }
        }).withMoPubSchemeListener(new UrlHandler.MoPubSchemeListener(){

            @Override
            public void onFinishLoad() {
                HtmlWebViewClient.this.mHtmlWebView.setPageLoaded();
                if (HtmlWebViewClient.this.mBaseWebViewListener != null) {
                    HtmlWebViewClient.this.mBaseWebViewListener.onLoaded((View)HtmlWebViewClient.this.mHtmlWebView);
                }
            }

            @Override
            public void onClose() {
                if (HtmlWebViewClient.this.mBaseWebViewListener != null) {
                    HtmlWebViewClient.this.mBaseWebViewListener.onClose();
                }
            }

            @Override
            public void onFailLoad() {
                HtmlWebViewClient.this.mHtmlWebView.stopLoading();
                if (HtmlWebViewClient.this.mBaseWebViewListener != null) {
                    HtmlWebViewClient.this.mBaseWebViewListener.onFailedToLoad(MoPubErrorCode.HTML_LOAD_ERROR);
                }
            }

            @Override
            public void onCrash() {
                if (HtmlWebViewClient.this.mBaseWebViewListener != null) {
                    HtmlWebViewClient.this.mBaseWebViewListener.onFailed();
                }
            }
        }).build().handleUrl(this.mContext, url, this.mHtmlWebView.wasClicked());
        return true;
    }
}

