/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.location.Location;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.AdFormat;
import com.mopub.common.MoPubReward;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.ManifestUtils;
import com.mopub.common.util.Visibility;
import com.mopub.mobileads.AdViewController;
import com.mopub.mobileads.MoPubAd;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.base.R;
import com.mopub.mobileads.factories.AdViewControllerFactory;

public class MoPubView
extends FrameLayout
implements MoPubAd {
    @Nullable
    protected AdViewController mAdViewController;
    private Context mContext;
    private int mScreenVisibility;
    private BroadcastReceiver mScreenStateReceiver;
    private MoPubAdSize mMoPubAdSize;
    private BannerAdListener mBannerAdListener;

    public MoPubView(Context context) {
        this(context, null);
    }

    public MoPubView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mMoPubAdSize = this.getMoPubAdSizeFromAttributeSet(context, attrs, MoPubAdSize.MATCH_VIEW);
        ManifestUtils.checkWebViewActivitiesDeclared(context);
        this.mContext = context;
        this.mScreenVisibility = this.getVisibility();
        this.setHorizontalScrollBarEnabled(false);
        this.setVerticalScrollBarEnabled(false);
        this.setAdViewController(AdViewControllerFactory.create(context, this));
        this.registerScreenStateBroadcastReceiver();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (Build.VERSION.SDK_INT >= 28) {
            this.setWindowInsets(this.getRootWindowInsets());
        }
    }

    public WindowInsets onApplyWindowInsets(WindowInsets insets) {
        if (Build.VERSION.SDK_INT >= 28) {
            this.setWindowInsets(insets);
        }
        return super.onApplyWindowInsets(insets);
    }

    private void registerScreenStateBroadcastReceiver() {
        this.mScreenStateReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (!Visibility.isScreenVisible(MoPubView.this.mScreenVisibility) || intent == null) {
                    return;
                }
                String action = intent.getAction();
                if ("android.intent.action.USER_PRESENT".equals(action)) {
                    MoPubView.this.setAdVisibility(0);
                } else if ("android.intent.action.SCREEN_OFF".equals(action)) {
                    MoPubView.this.setAdVisibility(8);
                }
            }
        };
        IntentFilter filter = new IntentFilter("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.USER_PRESENT");
        this.mContext.registerReceiver(this.mScreenStateReceiver, filter);
    }

    private void unregisterScreenStateBroadcastReceiver() {
        try {
            this.mContext.unregisterReceiver(this.mScreenStateReceiver);
        }
        catch (Exception IllegalArgumentException2) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Failed to unregister screen state broadcast receiver (never registered).");
        }
    }

    public void loadAd(MoPubAdSize moPubAdSize) {
        this.setAdSize(moPubAdSize);
        this.loadAd();
    }

    public void destroy() {
        MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Destroy() called");
        this.unregisterScreenStateBroadcastReceiver();
        this.removeAllViews();
        if (this.mAdViewController != null) {
            this.mAdViewController.cleanup();
            this.mAdViewController = null;
        }
    }

    protected void onWindowVisibilityChanged(int visibility) {
        if (Visibility.hasScreenVisibilityChanged(this.mScreenVisibility, visibility)) {
            this.mScreenVisibility = visibility;
            this.setAdVisibility(this.mScreenVisibility);
        }
    }

    private void setAdVisibility(int visibility) {
        if (this.mAdViewController == null) {
            return;
        }
        if (Visibility.isScreenVisible(visibility)) {
            this.mAdViewController.resumeRefresh();
        } else {
            this.mAdViewController.pauseRefresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MoPubAdSize getMoPubAdSizeFromAttributeSet(Context context, AttributeSet attrs, MoPubAdSize defaultMoPubAdSize) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MoPubView, 0, 0);
        MoPubAdSize returnValue = defaultMoPubAdSize;
        try {
            int moPubAdSizeInt = a.getInteger(R.styleable.MoPubView_moPubAdSize, defaultMoPubAdSize.toInt());
            returnValue = MoPubAdSize.valueOf(moPubAdSizeInt);
        }
        catch (Resources.NotFoundException rnfe) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM_WITH_THROWABLE, new Object[]{"Encountered a problem while setting the MoPubAdSize", rnfe});
        }
        finally {
            a.recycle();
        }
        return returnValue;
    }

    @Override
    @NonNull
    public Point resolveAdSize() {
        Point resolvedAdSize = new Point(this.getWidth(), this.getHeight());
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (this.getParent() != null && layoutParams != null && layoutParams.width < 0) {
            resolvedAdSize.x = ((View)this.getParent()).getWidth();
        }
        if (this.mMoPubAdSize != MoPubAdSize.MATCH_VIEW) {
            float density = this.mContext.getResources().getDisplayMetrics().density;
            resolvedAdSize.y = (int)Math.ceil((float)this.mMoPubAdSize.toInt() * density);
        } else if (this.getParent() != null && layoutParams != null && layoutParams.height < 0) {
            resolvedAdSize.y = ((View)this.getParent()).getHeight();
        }
        return resolvedAdSize;
    }

    @Override
    @NonNull
    public AdFormat getAdFormat() {
        return AdFormat.BANNER;
    }

    @Deprecated
    public void setLocation(Location location) {
    }

    public Activity getActivity() {
        return (Activity)this.mContext;
    }

    public void setBannerAdListener(BannerAdListener listener) {
        this.mBannerAdListener = listener;
    }

    public BannerAdListener getBannerAdListener() {
        return this.mBannerAdListener;
    }

    public void setAutorefreshEnabled(boolean enabled) {
        if (this.mAdViewController != null) {
            this.mAdViewController.setShouldAllowAutoRefresh(enabled);
        }
    }

    public boolean getAutorefreshEnabled() {
        if (this.mAdViewController != null) {
            return this.mAdViewController.getCurrentAutoRefreshStatus();
        }
        MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Can't get autorefresh status for destroyed MoPubView. Returning false.");
        return false;
    }

    public void setTesting(boolean testing) {
        if (this.mAdViewController != null) {
            this.mAdViewController.setTesting(testing);
        }
    }

    public boolean getTesting() {
        if (this.mAdViewController != null) {
            return this.mAdViewController.getTesting();
        }
        MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Can't get testing status for destroyed MoPubView. Returning false.");
        return false;
    }

    public void forceRefresh() {
        if (this.mAdViewController != null) {
            this.mAdViewController.forceRefresh();
        }
    }

    public void setAdSize(MoPubAdSize moPubAdSize) {
        this.mMoPubAdSize = moPubAdSize;
    }

    public MoPubAdSize getAdSize() {
        return this.mMoPubAdSize;
    }

    void setWindowInsets(@NonNull WindowInsets windowInsets) {
        if (this.mAdViewController != null) {
            this.mAdViewController.setWindowInsets(windowInsets);
        }
    }

    @Override
    public AdViewController getAdViewController() {
        return this.mAdViewController;
    }

    @Override
    public void setAdViewController(@Nullable AdViewController adViewController) {
        this.mAdViewController = adViewController;
    }

    @Deprecated
    public void setTimeout(int milliseconds) {
    }

    @Deprecated
    public String getResponseString() {
        return null;
    }

    @Deprecated
    public String getClickTrackingUrl() {
        return null;
    }

    @Override
    public void onAdLoaded() {
        if (this.mAdViewController != null) {
            this.mAdViewController.show();
        }
        if (this.mBannerAdListener != null) {
            this.mBannerAdListener.onBannerLoaded(this);
        }
    }

    @Override
    public void onAdLoadFailed(@NonNull MoPubErrorCode errorCode) {
        if (this.mBannerAdListener != null) {
            this.mBannerAdListener.onBannerFailed(this, errorCode);
        }
    }

    @Override
    public void onAdFailed(@NonNull MoPubErrorCode errorCode) {
        if (this.mBannerAdListener != null) {
            this.mBannerAdListener.onBannerFailed(this, errorCode);
        }
    }

    @Override
    public void onAdExpanded() {
        if (this.mAdViewController != null) {
            this.mAdViewController.engageOverlay();
        }
        if (this.mBannerAdListener != null) {
            this.mBannerAdListener.onBannerExpanded(this);
        }
    }

    @Override
    public void onAdCollapsed() {
        if (this.mAdViewController != null) {
            this.mAdViewController.dismissOverlay();
        }
        if (this.mBannerAdListener != null) {
            this.mBannerAdListener.onBannerCollapsed(this);
        }
    }

    @Override
    public void onAdClicked() {
        if (this.mAdViewController != null) {
            this.mAdViewController.registerClick();
        }
        if (this.mBannerAdListener != null) {
            this.mBannerAdListener.onBannerClicked(this);
        }
    }

    @Override
    public void onAdPauseAutoRefresh() {
        if (this.mAdViewController != null) {
            this.mAdViewController.engageOverlay();
        }
    }

    @Override
    public void onAdResumeAutoRefresh() {
        if (this.mAdViewController != null) {
            this.mAdViewController.dismissOverlay();
        }
    }

    @Override
    public void onAdShown() {
    }

    @Override
    public void onAdImpression() {
    }

    @Override
    public void onAdDismissed() {
    }

    @Override
    public void onAdComplete(@Nullable MoPubReward moPubReward) {
    }

    public static enum MoPubAdSize implements MoPubAdSizeInt
    {
        MATCH_VIEW(-1),
        HEIGHT_50(50),
        HEIGHT_90(90),
        HEIGHT_250(250),
        HEIGHT_280(280);

        private final int mSizeInt;

        private MoPubAdSize(int sizeInt) {
            this.mSizeInt = sizeInt;
        }

        @NonNull
        public static MoPubAdSize valueOf(int adSizeInt) {
            switch (adSizeInt) {
                case 50: {
                    return HEIGHT_50;
                }
                case 90: {
                    return HEIGHT_90;
                }
                case 250: {
                    return HEIGHT_250;
                }
                case 280: {
                    return HEIGHT_280;
                }
            }
            return MATCH_VIEW;
        }

        public int toInt() {
            return this.mSizeInt;
        }
    }

    static interface MoPubAdSizeInt {
        public static final int MATCH_VIEW_INT = -1;
        public static final int HEIGHT_50_INT = 50;
        public static final int HEIGHT_90_INT = 90;
        public static final int HEIGHT_250_INT = 250;
        public static final int HEIGHT_280_INT = 280;
    }

    public static interface BannerAdListener {
        public void onBannerLoaded(@NonNull MoPubView var1);

        public void onBannerFailed(MoPubView var1, MoPubErrorCode var2);

        public void onBannerClicked(MoPubView var1);

        public void onBannerExpanded(MoPubView var1);

        public void onBannerCollapsed(MoPubView var1);
    }
}

